/*
 * Decompiled with CFR 0.152.
 */
package com.bafomdad.realfilingcabinet.helpers.enums;

import com.bafomdad.realfilingcabinet.blocks.BlockRFC;
import com.bafomdad.realfilingcabinet.blocks.tiles.TileFilingCabinet;
import com.bafomdad.realfilingcabinet.entity.EntityCabinet;
import com.bafomdad.realfilingcabinet.helpers.UpgradeHelper;
import com.bafomdad.realfilingcabinet.utils.SmeltingUtils;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public enum UpgradeType {
    CREATIVE(null, "TAG_creativeUpgrade"),
    CRAFTING(new ResourceLocation("realfilingcabinet", "textures/model/craftingcabinet.png"), "TAG_craftingUpgrade"),
    ENDER(new ResourceLocation("realfilingcabinet", "textures/model/endercabinet.png"), "TAG_enderUpgrade"),
    OREDICT(new ResourceLocation("realfilingcabinet", "textures/model/oredictcabinet.png"), "TAG_oredictUpgrade"),
    MOB(new ResourceLocation("realfilingcabinet", "textures/model/mobcabinet.png"), "TAG_mobUpgrade"),
    FLUID(new ResourceLocation("realfilingcabinet", "textures/model/fluidcabinet.png"), "TAG_fluidUpgrade"),
    LIFE(null, "TAG_lifeUpgrade"){

        @Override
        public void tickUpgrade(TileEntity tile) {
            TileFilingCabinet tfc = (TileFilingCabinet)tile;
            World world = tfc.func_145831_w();
            BlockPos pos = tfc.func_174877_v();
            if (!UpgradeHelper.getUpgrade(tfc, "TAG_lifeUpgrade").isEmpty()) {
                if (!world.field_72995_K) {
                    EntityCabinet cabinet = new EntityCabinet(world);
                    IBlockState state = world.func_180495_p(pos);
                    float angle = ((EnumFacing)state.func_177229_b((IProperty)BlockRFC.FACING)).func_185119_l();
                    cabinet.func_70080_a((double)pos.func_177958_n() + 0.5, pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, angle, 0.0f);
                    for (int i = 0; i < tfc.getInventory().getSlots(); ++i) {
                        ItemStack folder = tfc.getInventory().getFolder(i);
                        if (folder.func_190926_b()) continue;
                        cabinet.getInventory().setStackInSlot(i, folder);
                    }
                    if (tfc.isCabinetLocked()) {
                        cabinet.func_184754_b(tfc.getOwner());
                    } else {
                        cabinet.homePos = pos.func_177986_g();
                    }
                    cabinet.setLegit();
                    world.func_72838_d((Entity)cabinet);
                }
                world.func_175698_g(pos);
            }
        }
    }
    ,
    SMELTING(new ResourceLocation("realfilingcabinet", "textures/model/smeltingcabinet.png"), "TAG_smeltingUpgrade"){

        @Override
        public void tickUpgrade(TileEntity tile) {
            TileFilingCabinet tfc = (TileFilingCabinet)tile;
            if (SmeltingUtils.canSmelt(tfc)) {
                SmeltingUtils.incrementSmeltTime(tfc);
                if (tfc.func_145831_w().func_82737_E() % 40L == 0L) {
                    SmeltingUtils.createSmeltingJob(tfc);
                    tfc.markBlockForUpdate();
                }
                return;
            }
        }
    };

    final ResourceLocation res;
    final String tag;

    private UpgradeType(ResourceLocation res, String tag) {
        this.res = res;
        this.tag = tag;
    }

    public ResourceLocation getTexture() {
        return this.res;
    }

    public String getTag() {
        return this.tag;
    }

    public void tickUpgrade(TileEntity tile) {
    }
}

