/*
 * Decompiled with CFR 0.152.
 */
package com.bafomdad.realfilingcabinet.blocks.tiles;

import com.bafomdad.realfilingcabinet.api.IUpgrade;
import com.bafomdad.realfilingcabinet.api.upgrades.Upgrades;
import com.bafomdad.realfilingcabinet.blocks.tiles.TileEntityRFC;
import com.bafomdad.realfilingcabinet.helpers.UpgradeHelper;
import com.bafomdad.realfilingcabinet.inventory.FluidRFC;
import com.bafomdad.realfilingcabinet.utils.EnderUtils;
import com.bafomdad.realfilingcabinet.utils.SmeltingUtils;
import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class TileFilingCabinet
extends TileEntityRFC {
    private FluidRFC fluidInv = new FluidRFC(this);
    public String upgrade = "";
    public List<int[]> smeltingJobs = Lists.newArrayList();
    public int fuelTime = 0;
    public ItemStack uncraftableItem = ItemStack.field_190927_a;
    private int rfcHash = -1;

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        Upgrades upgrade = UpgradeHelper.getUpgrade(this);
        if (!upgrade.isEmpty()) {
            ((IUpgrade)upgrade.getUpgrade().func_77973_b()).tickUpgrade(upgrade.getUpgrade(), this);
        }
    }

    @Override
    public void writeCustomNBT(NBTTagCompound tag) {
        super.writeCustomNBT(tag);
        tag.func_74782_a("RFC_isCraftable", (NBTBase)this.uncraftableItem.serializeNBT());
        tag.func_74778_a("RFC_upgrade", this.upgrade);
        if (this.rfcHash != -1) {
            tag.func_74768_a("RFC_enderhash", this.rfcHash);
        }
        SmeltingUtils.writeSmeltNBT(this, tag);
    }

    @Override
    public void readCustomNBT(NBTTagCompound tag) {
        super.readCustomNBT(tag);
        if (tag.func_74764_b("RFC_isCraftable")) {
            this.uncraftableItem = new ItemStack((NBTTagCompound)tag.func_74781_a("RFC_isCraftable"));
        }
        this.upgrade = tag.func_74779_i("RFC_upgrade");
        if (tag.func_74764_b("RFC_enderhash")) {
            this.rfcHash = tag.func_74762_e("RFC_enderhash");
        }
        SmeltingUtils.readSmeltNBT(this, tag);
    }

    public IFluidHandler getFluidInventory() {
        return this.fluidInv;
    }

    public void setHash() {
        this.rfcHash = EnderUtils.createHash(this);
    }

    public int getHash() {
        return this.rfcHash;
    }

    @Override
    public boolean hasCapability(@Nonnull Capability<?> cap, EnumFacing side) {
        return !UpgradeHelper.getUpgrade(this, "TAG_fluidUpgrade").isEmpty() ? cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY : super.hasCapability(cap, side);
    }

    @Override
    public <T> T getCapability(@Nonnull Capability<T> cap, EnumFacing side) {
        if (cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)this.fluidInv);
        }
        return super.getCapability(cap, side);
    }

    @Override
    public void getDrops(NonNullList<ItemStack> list) {
        super.getDrops(list);
        if (UpgradeHelper.hasUpgrade(this)) {
            list.add((Object)UpgradeHelper.getUpgrade(this).getUpgrade());
        }
    }
}

