/*
 * Decompiled with CFR 0.152.
 */
package com.bafomdad.realfilingcabinet.blocks;

import com.bafomdad.realfilingcabinet.api.IFolder;
import com.bafomdad.realfilingcabinet.api.IUpgrade;
import com.bafomdad.realfilingcabinet.blocks.BlockRFC;
import com.bafomdad.realfilingcabinet.blocks.tiles.TileEntityRFC;
import com.bafomdad.realfilingcabinet.blocks.tiles.TileFilingCabinet;
import com.bafomdad.realfilingcabinet.helpers.UpgradeHelper;
import com.bafomdad.realfilingcabinet.helpers.enums.FolderType;
import com.bafomdad.realfilingcabinet.init.RFCItems;
import com.bafomdad.realfilingcabinet.init.RFCSounds;
import com.bafomdad.realfilingcabinet.utils.AutocraftingUtils;
import com.bafomdad.realfilingcabinet.utils.FolderUtils;
import com.bafomdad.realfilingcabinet.utils.SmeltingUtils;
import com.bafomdad.realfilingcabinet.utils.StorageUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class BlockFilingCabinet
extends BlockRFC {
    static float f = 0.0625f;
    protected static final AxisAlignedBB BASE_AABB = new AxisAlignedBB(0.0 + (double)f, 0.0, 0.0 + (double)f, 1.0 - (double)f, 1.0 - (double)f, 1.0 - (double)f);

    public BlockFilingCabinet() {
        super(Material.field_151573_f);
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB aabb, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean wat) {
        BlockFilingCabinet.func_185492_a((BlockPos)pos, (AxisAlignedBB)aabb, collidingBoxes, (AxisAlignedBB)BASE_AABB);
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileFilingCabinet();
    }

    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        if (!(entity instanceof EntityLivingBase)) {
            return;
        }
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileFilingCabinet) {
            TileFilingCabinet tfc = (TileFilingCabinet)tile;
            if (UpgradeHelper.getUpgrade(tfc, "TAG_mobUpgrade").isEmpty()) {
                return;
            }
            for (int i = 0; i < tfc.getInventory().getSlots(); ++i) {
                Object obj = FolderUtils.get(tfc.getInventory().getFolder(i)).insert((EntityLivingBase)entity, false);
                if (obj == null) continue;
                tfc.markBlockForUpdate();
                break;
            }
        }
    }

    @Override
    public void leftClick(TileEntity tile, EntityPlayer player) {
        if (player.field_71075_bZ.field_75098_d) {
            return;
        }
        TileFilingCabinet tileRFC = (TileFilingCabinet)tile;
        if (player.func_70093_af() && player.func_184614_ca().func_77973_b() == RFCItems.MAGNIFYINGGLASS) {
            if (!tileRFC.func_145831_w().field_72995_K) {
                UpgradeHelper.removeUpgrade(player, tileRFC);
            }
            tileRFC.markBlockForUpdate();
            return;
        }
        if (UpgradeHelper.getUpgrade(tileRFC, "TAG_craftingUpgrade").isEmpty()) {
            StorageUtils.extractStackManually(tileRFC, player);
            return;
        }
        ItemStack toCraft = tileRFC.getFilter().func_77946_l();
        if (!tileRFC.getFilter().func_190926_b() && toCraft.func_77951_h()) {
            toCraft.func_77964_b(0);
        }
        if (AutocraftingUtils.canCraft(tileRFC.getFilter(), tileRFC)) {
            ItemStack stack = toCraft;
            stack.func_190920_e(AutocraftingUtils.getOutputSize());
            if (!UpgradeHelper.isCreative(tileRFC)) {
                AutocraftingUtils.doCraft(tileRFC.getFilter(), (IItemHandler)tileRFC.getInventory());
            }
            ItemHandlerHelper.giveItemToPlayer((EntityPlayer)player, (ItemStack)stack);
        }
    }

    @Override
    public void rightClick(TileEntity tile, EntityPlayer player, EnumFacing side) {
        TileFilingCabinet tileRFC = (TileFilingCabinet)tile;
        ItemStack stack = player.func_184614_ca();
        if (tileRFC.calcLastClick(player)) {
            StorageUtils.addAllStacksManually(tileRFC, player);
            tileRFC.markBlockForUpdate();
            return;
        }
        if (!player.func_70093_af() && stack.func_190926_b()) {
            if (!tileRFC.func_145831_w().field_72995_K) {
                tileRFC.isOpen = !tileRFC.isOpen;
                tileRFC.func_70296_d();
            }
            player.func_184185_a(RFCSounds.SQUEAK, 0.75f, 1.0f);
            tileRFC.markBlockForUpdate();
            return;
        }
        if (player.func_70093_af() && stack.func_190926_b()) {
            StorageUtils.folderExtract(tileRFC, player);
            return;
        }
        if (!stack.func_190926_b() && tileRFC.isOpen && stack.func_77973_b() instanceof IFolder) {
            if (stack.func_77973_b() == RFCItems.FOLDER && stack.func_77952_i() == FolderType.ENDER.ordinal()) {
                player.func_184611_a(EnumHand.MAIN_HAND, ItemStack.field_190927_a);
                return;
            }
            if (!UpgradeHelper.getUpgrade(tileRFC, "TAG_enderUpgrade").isEmpty()) {
                return;
            }
            for (int i = 0; i < tileRFC.getInventory().getSlots(); ++i) {
                if (!tileRFC.getInventory().getFolder(i).func_190926_b()) continue;
                tileRFC.getInventory().setStackInSlot(i, stack);
                player.func_184611_a(EnumHand.MAIN_HAND, ItemStack.field_190927_a);
                tileRFC.markBlockForUpdate();
                return;
            }
        }
        if (!player.func_70093_af() && !stack.func_190926_b()) {
            if (stack.func_77973_b() == RFCItems.KEY) {
                tileRFC.doKeyStuff(player, stack);
                return;
            }
            if (stack.func_77973_b() instanceof IUpgrade) {
                UpgradeHelper.setUpgrade(player, tileRFC, stack);
            } else {
                StorageUtils.addStackManually(tileRFC, player, stack);
            }
            tileRFC.markBlockForUpdate();
            return;
        }
    }

    @Override
    public List<String> getInfoOverlay(TileEntity tile) {
        ArrayList<String> list = new ArrayList<String>();
        if (tile instanceof TileFilingCabinet) {
            TileFilingCabinet tfc = (TileFilingCabinet)tile;
            for (int i = 0; i < tfc.getInventory().getSlots(); ++i) {
                ItemStack folder = tfc.getInventory().getFolder(i);
                FolderUtils.get(folder).addTooltips(list);
            }
        }
        if (((TileEntityRFC)tile).isCabinetLocked()) {
            list.add(TextFormatting.YELLOW + "[LOCKED]");
        }
        return list;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        TileEntity tile = worldIn.func_175625_s(pos);
        if (!(tile instanceof TileFilingCabinet)) {
            return;
        }
        if (SmeltingUtils.isSmelting((TileFilingCabinet)tile)) {
            EnumFacing enumfacing = (EnumFacing)stateIn.func_177229_b((IProperty)FACING);
            double d0 = (double)pos.func_177958_n() + 0.5;
            double d1 = (double)pos.func_177956_o() + rand.nextDouble() * 6.0 / 16.0;
            double d2 = (double)pos.func_177952_p() + 0.5;
            double d3 = 0.52;
            double d4 = rand.nextDouble() * 0.6 - 0.3;
            if (rand.nextDouble() < 0.1) {
                worldIn.func_184134_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, SoundEvents.field_187652_bv, SoundCategory.BLOCKS, 1.0f, 1.0f, false);
            }
            switch (enumfacing) {
                case WEST: {
                    worldIn.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, d0 - 0.52, d1, d2 + d4, 0.0, 0.0, 0.0, new int[0]);
                    worldIn.func_175688_a(EnumParticleTypes.FLAME, d0 - 0.52, d1, d2 + d4, 0.0, 0.0, 0.0, new int[0]);
                    break;
                }
                case EAST: {
                    worldIn.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, d0 + 0.52, d1, d2 + d4, 0.0, 0.0, 0.0, new int[0]);
                    worldIn.func_175688_a(EnumParticleTypes.FLAME, d0 + 0.52, d1, d2 + d4, 0.0, 0.0, 0.0, new int[0]);
                    break;
                }
                case NORTH: {
                    worldIn.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, d0 + d4, d1, d2 - 0.52, 0.0, 0.0, 0.0, new int[0]);
                    worldIn.func_175688_a(EnumParticleTypes.FLAME, d0 + d4, d1, d2 - 0.52, 0.0, 0.0, 0.0, new int[0]);
                    break;
                }
                case SOUTH: {
                    worldIn.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, d0 + d4, d1, d2 + 0.52, 0.0, 0.0, 0.0, new int[0]);
                    worldIn.func_175688_a(EnumParticleTypes.FLAME, d0 + d4, d1, d2 + 0.52, 0.0, 0.0, 0.0, new int[0]);
                }
            }
        }
    }
}

