/*
 * Decompiled with CFR 0.152.
 */
package malte0811.industrialwires.blocks.controlpanel;

import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.util.chickenbones.Matrix4;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import malte0811.industrialwires.IndustrialWires;
import malte0811.industrialwires.blocks.IBlockBoundsIW;
import malte0811.industrialwires.blocks.controlpanel.BlockTypes_Panel;
import malte0811.industrialwires.blocks.controlpanel.TileEntityGeneralCP;
import malte0811.industrialwires.controlpanel.ControlPanelNetwork;
import malte0811.industrialwires.controlpanel.IndicatorLight;
import malte0811.industrialwires.controlpanel.Label;
import malte0811.industrialwires.controlpanel.LightedButton;
import malte0811.industrialwires.controlpanel.PanelComponent;
import malte0811.industrialwires.controlpanel.PanelUtils;
import malte0811.industrialwires.controlpanel.PropertyComponents;
import malte0811.industrialwires.network.MessagePanelInteract;
import malte0811.industrialwires.util.MiscUtils;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class TileEntityPanel
extends TileEntityGeneralCP
implements IEBlockInterfaces.IDirectionalTile,
IBlockBoundsIW,
IEBlockInterfaces.IPlayerInteraction,
ITickable,
IEBlockInterfaces.ITileDrop {
    protected PropertyComponents.PanelRenderProperties components = new PropertyComponents.PanelRenderProperties();
    protected AxisAlignedBB defAABB;

    public TileEntityPanel() {
        int[] colors = new int[]{0xF9FFFE, 16351261, 13061821, 3847130, 16701501, 8439583, 15961002, 4673362, 0x9D9D97, 1481884, 8991416, 3949738, 8606770, 6192150};
        for (int i = 2; i < 14; ++i) {
            int color = colors[i - 2];
            IndicatorLight ind = new IndicatorLight(new ControlPanelNetwork.RSChannel(0, (byte)(i - 2)), color);
            LightedButton btn = new LightedButton(color, false, true, new ControlPanelNetwork.RSChannel(0, (byte)(i - 2)));
            Label lbl = new Label("->", color);
            ind.setX(0.0f);
            ind.setY((float)i / 16.0f);
            ind.setPanelHeight(this.components.getHeight());
            lbl.setX(0.125f);
            lbl.setY((float)i / 16.0f);
            lbl.setPanelHeight(this.components.getHeight());
            btn.setX(0.3125f);
            btn.setY((float)i / 16.0f);
            btn.setPanelHeight(this.components.getHeight());
            this.components.add(ind);
            this.components.add(lbl);
            this.components.add(btn);
        }
        for (PanelComponent pc : this.components) {
            pc.setPanel(this);
        }
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            for (PanelComponent pc : this.components) {
                pc.update();
            }
        }
    }

    @Override
    public void setNetworkAndInit(ControlPanelNetwork newNet) {
        super.setNetworkAndInit(newNet);
        for (PanelComponent pc : this.components) {
            pc.setNetwork(newNet);
        }
    }

    @Override
    public void writeNBT(NBTTagCompound out, boolean updatePacket) {
        this.writeToItemNBT(out, false);
        out.func_74768_a("facing", this.components.getFacing().func_176736_b());
        out.func_74768_a("top", this.components.getTop().func_176745_a());
    }

    @Override
    public void readNBT(NBTTagCompound in, boolean updatePacket) {
        this.readFromItemNBT(in);
        this.components.setFacing(EnumFacing.func_176731_b((int)in.func_74762_e("facing")));
        this.components.setTop(EnumFacing.func_82600_a((int)in.func_74762_e("top")));
    }

    @Nonnull
    public ItemStack getTileDrop(@Nullable EntityPlayer player, @Nonnull IBlockState state) {
        NBTTagCompound ret = new NBTTagCompound();
        this.writeToItemNBT(ret, true);
        ItemStack retStack = new ItemStack((Block)IndustrialWires.panel, 1, BlockTypes_Panel.TOP.ordinal());
        retStack.func_77982_d(ret);
        return retStack;
    }

    public void readOnPlacement(@Nullable EntityLivingBase placer, @Nonnull ItemStack stack) {
        if (!stack.func_190926_b() && stack.func_77942_o()) {
            this.readFromItemNBT(stack.func_77978_p());
        }
    }

    public void readFromItemNBT(@Nullable NBTTagCompound nbt) {
        if (nbt != null) {
            NBTTagList l = nbt.func_150295_c("components", 10);
            PanelUtils.readListFromNBT(l, this.components);
            this.panelNetwork.removeIOFor(this);
            for (PanelComponent pc : this.components) {
                pc.setPanel(this);
                if (this.field_145850_b != null && this.field_145850_b.field_72995_K) continue;
                pc.setNetwork(this.panelNetwork);
            }
            this.components.setHeight(nbt.func_74760_g("height"));
            if (nbt.func_150297_b("texture", 10)) {
                this.components.setTextureSource(new ItemStack(nbt.func_74775_l("texture")));
            }
            this.components.setAngle(nbt.func_74760_g("angle"));
        }
        this.defAABB = null;
    }

    public void writeToItemNBT(NBTTagCompound nbt, boolean toItem) {
        NBTTagList comps = new NBTTagList();
        for (PanelComponent p : this.components) {
            NBTTagCompound nbtInner = new NBTTagCompound();
            p.writeToNBT(nbtInner, toItem);
            comps.func_74742_a((NBTBase)nbtInner);
        }
        nbt.func_74782_a("components", (NBTBase)comps);
        nbt.func_74776_a("height", this.components.getHeight());
        nbt.func_74776_a("angle", this.components.getAngle());
        nbt.func_74782_a("texture", (NBTBase)this.components.getTextureSource().serializeNBT());
    }

    @Nonnull
    public EnumFacing getFacing() {
        return this.components.getFacing();
    }

    public void setFacing(@Nonnull EnumFacing facing) {
        this.components.setFacing(facing);
    }

    public int getFacingLimitation() {
        return 0;
    }

    @Nonnull
    public EnumFacing getFacingForPlacement(@Nonnull EntityLivingBase placer, @Nonnull BlockPos pos, @Nonnull EnumFacing side, float hitX, float hitY, float hitZ) {
        switch (side) {
            case UP: {
                this.components.setTop(EnumFacing.UP);
                return EnumFacing.func_176733_a((double)placer.field_70177_z);
            }
            case DOWN: {
                this.components.setTop(EnumFacing.DOWN);
                return EnumFacing.func_176733_a((double)(-placer.field_70177_z));
            }
            case NORTH: 
            case SOUTH: 
            case WEST: 
            case EAST: {
                this.components.setTop(side);
                return EnumFacing.SOUTH;
            }
        }
        return this.components.getFacing();
    }

    public boolean mirrorFacingOnPlacement(@Nonnull EntityLivingBase placer) {
        return false;
    }

    public boolean canHammerRotate(@Nonnull EnumFacing side, float hitX, float hitY, float hitZ, @Nonnull EntityLivingBase entity) {
        return false;
    }

    public boolean canRotate(@Nonnull EnumFacing axis) {
        return false;
    }

    @Override
    public AxisAlignedBB getBoundingBox() {
        if (this.defAABB == null) {
            this.defAABB = MiscUtils.apply(this.components.getPanelBaseTransform(), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, (double)this.components.getMaxHeight(), 1.0));
        }
        return this.defAABB;
    }

    public PropertyComponents.PanelRenderProperties getComponents() {
        return this.components;
    }

    @Nullable
    public Pair<PanelComponent, RayTraceResult> getSelectedComponent(EntityPlayer player, Vec3d hitVec, boolean hitAbs) {
        Matrix4 mat = this.components.getPanelTopTransformInverse();
        PanelComponent retPc = null;
        RayTraceResult retRay = null;
        Vec3d playerPosRelative = player.func_174791_d().func_72441_c((double)(-this.field_174879_c.func_177958_n()), (double)(player.func_70047_e() - (float)this.field_174879_c.func_177956_o()), (double)(-this.field_174879_c.func_177952_p()));
        Vec3d playerPosTransformed = mat.apply(playerPosRelative);
        Vec3d hitRel = hitAbs ? hitVec.func_72441_c((double)(-this.field_174879_c.func_177958_n()), (double)(-this.field_174879_c.func_177956_o()), (double)(-this.field_174879_c.func_177952_p())) : hitVec;
        RayTraceResult r = this.getBoundingBox().func_72327_a(playerPosRelative, playerPosRelative.func_178787_e(player.func_70040_Z().func_186678_a(200.0)));
        if (r != null && r.field_72307_f != null) {
            hitRel = r.field_72307_f;
        }
        Vec3d ray = hitRel.func_178788_d(playerPosRelative.func_178788_d(hitRel).func_186678_a(10.0));
        Vec3d rayTransformed = mat.apply(ray);
        Vec3d hitTransformed = mat.apply(new Vec3d(hitRel.field_72450_a, hitRel.field_72448_b, hitRel.field_72449_c));
        if (hitTransformed.field_72448_b < 0.0) {
            return null;
        }
        for (PanelComponent pc : this.components) {
            RayTraceResult hit;
            AxisAlignedBB box = pc.getBlockRelativeAABB();
            if (!(box.field_72337_e > box.field_72338_b) || (hit = (box = box.func_186662_g(0.002)).func_72327_a(playerPosTransformed, rayTransformed)) == null) continue;
            if (retPc == null) {
                retPc = pc;
                retRay = hit;
                continue;
            }
            double oldDist = retRay.field_72307_f.func_178788_d(playerPosRelative).func_189985_c();
            double newDist = hit.field_72307_f.func_178788_d(playerPosRelative).func_189985_c();
            if (!(newDist < oldDist)) continue;
            retPc = pc;
            retRay = hit;
        }
        if (retRay != null) {
            retRay.field_72307_f = retRay.field_72307_f.func_178786_a((double)retPc.getX(), 0.0, (double)retPc.getY());
        }
        return retPc != null ? new ImmutablePair((Object)retPc, retRay) : null;
    }

    public boolean interact(@Nonnull EnumFacing side, @Nonnull EntityPlayer player, @Nonnull EnumHand hand, @Nonnull ItemStack heldItem, float hitX, float hitY, float hitZ) {
        Pair<PanelComponent, RayTraceResult> pc;
        if (this.field_145850_b.field_72995_K && (pc = this.getSelectedComponent(player, new Vec3d((double)hitX, (double)hitY, (double)hitZ), false)) != null) {
            IndustrialWires.packetHandler.sendToServer((IMessage)new MessagePanelInteract(this, this.components.indexOf(pc.getKey()), ((RayTraceResult)pc.getRight()).field_72307_f));
        }
        return true;
    }

    public void interactServer(Vec3d hitRelative, int pcId, EntityPlayerMP player) {
        if (pcId >= 0 && pcId < this.components.size()) {
            ((PanelComponent)this.components.get(pcId)).interactWith(hitRelative, player);
        }
    }
}

