/*
 * Decompiled with CFR 0.152.
 */
package malte0811.industrialwires.blocks;

import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.energy.wires.IImmersiveConnectable;
import blusunrize.immersiveengineering.api.energy.wires.ImmersiveNetHandler;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.util.Utils;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import malte0811.industrialwires.IndustrialWires;
import malte0811.industrialwires.blocks.IBlockBoundsIW;
import malte0811.industrialwires.blocks.IHasDummyBlocksIW;
import malte0811.industrialwires.blocks.ItemBlockIW;
import malte0811.industrialwires.util.MiscUtils;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;

public abstract class BlockIWBase
extends Block {
    private IProperty[] properties;

    public BlockIWBase(Material mat, String name) {
        super(mat);
        this.func_149711_c(3.0f);
        this.func_149752_b(15.0f);
        this.func_149663_c("industrialwires." + name);
        this.setRegistryName("industrialwires", name);
        this.func_149647_a(IndustrialWires.creativeTab);
        IndustrialWires.blocks.add(this);
    }

    public ItemBlock createItemBlock() {
        return new ItemBlockIW(this);
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        if (this.properties == null) {
            this.properties = this.getProperties();
        }
        BlockStateContainer cont = super.func_180661_e();
        IProperty[] props = cont.func_177623_d().toArray(new IProperty[0]);
        int oldLength = props.length;
        props = Arrays.copyOf(props, oldLength + this.properties.length);
        System.arraycopy(this.properties, 0, props, oldLength, this.properties.length);
        return new BlockStateContainer((Block)this, props);
    }

    @Nonnull
    public IBlockState func_176221_a(@Nonnull IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        state = super.func_176221_a(state, worldIn, pos);
        TileEntity tile = worldIn.func_175625_s(pos);
        if (tile instanceof IHasDummyBlocksIW) {
            state = this.applyProperty(state, (IProperty)IEProperties.MULTIBLOCKSLAVE, ((IHasDummyBlocksIW)tile).isDummy());
        }
        if (tile instanceof IEBlockInterfaces.IDirectionalTile && ((IEBlockInterfaces.IDirectionalTile)tile).getFacingLimitation() >= 0) {
            state = ((IEBlockInterfaces.IDirectionalTile)tile).getFacingLimitation() == 2 ? state.func_177226_a((IProperty)IEProperties.FACING_HORIZONTAL, (Comparable)((IEBlockInterfaces.IDirectionalTile)tile).getFacing()) : state.func_177226_a((IProperty)IEProperties.FACING_ALL, (Comparable)((IEBlockInterfaces.IDirectionalTile)tile).getFacing());
        }
        return state;
    }

    @Nonnull
    public IBlockState getExtendedState(@Nonnull IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntity te;
        if ((state = super.getExtendedState(state, world, pos)) instanceof IExtendedBlockState && (te = world.func_175625_s(pos)) instanceof IImmersiveConnectable) {
            Set conns = ImmersiveNetHandler.INSTANCE.getConnections(te.func_145831_w(), pos);
            state = ((IExtendedBlockState)state).withProperty((IUnlistedProperty)IEProperties.CONNECTIONS, MiscUtils.genConnBlockstate(conns, te.func_145831_w()));
        }
        return state;
    }

    protected <V extends Comparable<V>> IBlockState applyProperty(IBlockState in, IProperty<V> prop, V val) {
        return in.func_177226_a(prop, val);
    }

    public void func_180663_b(@Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull IBlockState state) {
        TileEntity te = worldIn.func_175625_s(pos);
        if (te instanceof IHasDummyBlocksIW) {
            ((IHasDummyBlocksIW)te).breakDummies();
        }
        if (!(!(te instanceof IImmersiveConnectable) || worldIn.field_72995_K && Minecraft.func_71410_x().func_71356_B())) {
            ImmersiveNetHandler.INSTANCE.clearAllConnectionsFor(Utils.toCC((Object)te), worldIn, !worldIn.field_72995_K && worldIn.func_82736_K().func_82766_b("doTileDrops"));
        }
        super.func_180663_b(worldIn, pos, state);
        worldIn.func_175713_t(pos);
    }

    @Nonnull
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        AxisAlignedBB ret;
        TileEntity te = source.func_175625_s(pos);
        if (te instanceof IBlockBoundsIW && (ret = ((IBlockBoundsIW)te).getBoundingBox()) != null) {
            return ret;
        }
        return super.func_185496_a(state, source, pos);
    }

    public void func_185477_a(IBlockState state, @Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull AxisAlignedBB entityBox, @Nonnull List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean p_185477_7_) {
        AxisAlignedBB aabb = this.func_185496_a(state, (IBlockAccess)worldIn, pos).func_186670_a(pos);
        if (entityBox.func_72326_a(aabb)) {
            collidingBoxes.add(aabb);
        }
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        IEBlockInterfaces.IDirectionalTile directionalTe;
        TileEntity te = world.func_175625_s(pos);
        ItemStack heldItem = player.func_184586_b(hand);
        if (te instanceof IEBlockInterfaces.IDirectionalTile && Utils.isHammer((ItemStack)heldItem) && !world.field_72995_K && (directionalTe = (IEBlockInterfaces.IDirectionalTile)te).canHammerRotate(side, hitX, hitY, hitZ, (EntityLivingBase)player)) {
            EnumFacing f;
            EnumFacing original = f = directionalTe.getFacing();
            int limit = directionalTe.getFacingLimitation();
            if (limit == 0) {
                f = EnumFacing.field_82609_l[(f.ordinal() + 1) % EnumFacing.field_82609_l.length];
            } else if (limit == 1) {
                f = player.func_70093_af() ? f.func_176732_a(side.func_176740_k()).func_176734_d() : f.func_176732_a(side.func_176740_k());
            } else if (limit == 2 || limit == 5) {
                EnumFacing enumFacing = f = player.func_70093_af() ? f.func_176735_f() : f.func_176746_e();
            }
            if (f != original) {
                directionalTe.setFacing(f);
                te.func_70296_d();
                world.func_184138_a(pos, state, state, 3);
                world.func_175641_c(pos, (Block)this, 255, 0);
            }
            return true;
        }
        return te instanceof IEBlockInterfaces.IPlayerInteraction && ((IEBlockInterfaces.IPlayerInteraction)te).interact(side, player, hand, heldItem, hitX, hitY, hitZ);
    }

    public boolean func_189539_a(IBlockState state, World worldIn, BlockPos pos, int id, int param) {
        boolean def = super.func_189539_a(state, worldIn, pos, id, param);
        if ((id & 0xFF) == 255) {
            IBlockState s = worldIn.func_180495_p(pos);
            worldIn.func_184138_a(pos, s, s, 3);
            return true;
        }
        return def;
    }

    public void func_180657_a(@Nonnull World worldIn, EntityPlayer player, @Nonnull BlockPos pos, @Nonnull IBlockState state, TileEntity te, ItemStack stack) {
        ItemStack drop;
        if (te instanceof IEBlockInterfaces.ITileDrop && !(drop = ((IEBlockInterfaces.ITileDrop)te).getTileDrop(player, state)).func_190926_b()) {
            BlockIWBase.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)drop);
            return;
        }
        super.func_180657_a(worldIn, player, pos, state, te, stack);
    }

    public boolean rotateBlock(World world, @Nonnull BlockPos pos, @Nonnull EnumFacing axis) {
        return false;
    }

    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(state);
    }

    public int func_176211_b(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof IEBlockInterfaces.IRedstoneOutput) {
            return ((IEBlockInterfaces.IRedstoneOutput)te).getStrongRSOutput(state, side);
        }
        return 0;
    }

    public int func_180656_a(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof IEBlockInterfaces.IRedstoneOutput) {
            return ((IEBlockInterfaces.IRedstoneOutput)te).getWeakRSOutput(state, side);
        }
        return 0;
    }

    public boolean canConnectRedstone(IBlockState state, IBlockAccess world, BlockPos pos, @Nullable EnumFacing side) {
        TileEntity te;
        if (side != null && (te = world.func_175625_s(pos)) instanceof IEBlockInterfaces.IRedstoneOutput) {
            return ((IEBlockInterfaces.IRedstoneOutput)te).canConnectRedstone(state, side);
        }
        return false;
    }

    protected abstract IProperty[] getProperties();
}

