/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity;

import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class EntitySeekerArrow
extends EntityArrow {
    private static final DataParameter<Integer> TARGET = EntityDataManager.func_187226_a(EntitySeekerArrow.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final double seekDistance = 5.0;
    private static final double seekFactor = 0.2;
    private static final double seekAngle = 0.5235987755982988;
    private static final double seekThreshold = 0.5;

    public EntitySeekerArrow(World world) {
        super(world);
    }

    public EntitySeekerArrow(World world, EntityPlayer player) {
        super(world, (EntityLivingBase)player);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(TARGET, (Object)-1);
    }

    public void func_70071_h_() {
        if (this.isThisArrowFlying()) {
            Entity target;
            if (!this.field_70170_p.field_72995_K) {
                this.updateTarget();
            }
            if (this.field_70170_p.field_72995_K && !this.field_70254_i) {
                for (int k = 0; k < 4; ++k) {
                    this.field_70170_p.func_175688_a(EnumParticleTypes.SPELL_WITCH, this.field_70165_t + this.field_70159_w * (double)k / 4.0, this.field_70163_u + this.field_70181_x * (double)k / 4.0, this.field_70161_v + this.field_70179_y * (double)k / 4.0, -this.field_70159_w, -this.field_70181_x + 0.2, -this.field_70179_y, new int[0]);
                }
            }
            if ((target = this.getTarget()) != null) {
                Vec3d targetVec = this.getVectorToTarget(target).func_186678_a(0.2);
                Vec3d courseVec = this.getMotionVec();
                double courseLen = courseVec.func_72433_c();
                double targetLen = targetVec.func_72433_c();
                double totalLen = MathHelper.func_76133_a((double)(courseLen * courseLen + targetLen * targetLen));
                double dotProduct = courseVec.func_72430_b(targetVec) / (courseLen * targetLen);
                if (dotProduct > 0.5) {
                    Vec3d newMotion = courseVec.func_186678_a(courseLen / totalLen).func_178787_e(targetVec.func_186678_a(targetLen / totalLen));
                    this.field_70159_w = newMotion.field_72450_a;
                    this.field_70181_x = newMotion.field_72448_b;
                    this.field_70179_y = newMotion.field_72449_c;
                    this.field_70181_x += (double)0.045f;
                } else if (!this.field_70170_p.field_72995_K) {
                    this.setTarget(null);
                }
            }
        }
        super.func_70071_h_();
    }

    private void updateTarget() {
        if (this.getTarget() != null && this.getTarget().field_70128_L) {
            this.setTarget(null);
        }
        if (this.getTarget() == null) {
            AxisAlignedBB positionBB;
            AxisAlignedBB targetBB = positionBB = new AxisAlignedBB(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70165_t, this.field_70163_u, this.field_70161_v);
            Vec3d courseVec = this.getMotionVec().func_186678_a(5.0).func_178785_b(0.5235988f);
            targetBB = targetBB.func_111270_a(positionBB.func_191194_a(courseVec));
            courseVec = this.getMotionVec().func_186678_a(5.0).func_178785_b(-0.5235988f);
            targetBB = targetBB.func_111270_a(positionBB.func_191194_a(courseVec));
            targetBB = targetBB.func_72314_b(0.0, 2.5, 0.0);
            double closestDot = -1.0;
            for (EntityLivingBase living : this.field_70170_p.func_72872_a(EntityLivingBase.class, targetBB)) {
                Vec3d targetVec;
                double dot;
                if (living instanceof EntityPlayer || !((dot = (courseVec = this.getMotionVec().func_72432_b()).func_72430_b(targetVec = this.getVectorToTarget((Entity)living).func_72432_b())) > Math.max(closestDot, 0.5))) continue;
                this.setTarget((Entity)living);
                closestDot = dot;
            }
        }
    }

    private Vec3d getMotionVec() {
        return new Vec3d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
    }

    private Vec3d getVectorToTarget(Entity target) {
        return new Vec3d(target.field_70165_t - this.field_70165_t, target.field_70163_u + (double)target.func_70047_e() - this.field_70163_u, target.field_70161_v - this.field_70161_v);
    }

    @Nullable
    private Entity getTarget() {
        return this.field_70170_p.func_73045_a(((Integer)this.field_70180_af.func_187225_a(TARGET)).intValue());
    }

    private void setTarget(@Nullable Entity e) {
        this.field_70180_af.func_187227_b(TARGET, (Object)(e == null ? -1 : e.func_145782_y()));
    }

    protected ItemStack func_184550_j() {
        return new ItemStack(Items.field_151032_g);
    }

    private boolean isThisArrowFlying() {
        return (double)MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70181_x * this.field_70181_x + this.field_70179_y * this.field_70179_y)) > 1.0;
    }
}

