/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.client.shader;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.function.IntConsumer;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.client.resources.SimpleReloadableResourceManager;
import org.apache.commons.io.IOUtils;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.ARBShaderObjects;
import org.lwjgl.opengl.GL20;
import twilightforest.TFConfig;
import twilightforest.TwilightForestMod;
import twilightforest.client.TFClientEvents;
import twilightforest.client.shader.ShaderUniform;

public final class ShaderManager {
    private static IResourceManagerReloadListener shaderReloadListener;
    private static final int VERT;
    private static final int FRAG;
    private static final String PREFIX = "/assets/twilightforest/shaders/";
    public static int enderPortalShader;
    public static int twilightSkyShader;
    public static int fireflyShader;
    public static int auroraShader;
    public static int carminiteShader;
    public static int towerDeviceShader;
    public static int yellowCircuitShader;
    public static int bloomShader;
    public static int starburstShader;
    public static int shieldShader;
    public static int outlineShader;
    private static final int INFO_LOG_LENGTH;
    private static final int VALIDATE_STATUS;

    public static void initShaders() {
        IResourceManager iManager = Minecraft.func_71410_x().func_110442_L();
        if (iManager instanceof SimpleReloadableResourceManager) {
            shaderReloadListener = manager -> {
                ShaderManager.deleteProgram(twilightSkyShader);
                ShaderManager.deleteProgram(fireflyShader);
                ShaderManager.deleteProgram(auroraShader);
                ShaderManager.deleteProgram(carminiteShader);
                ShaderManager.deleteProgram(towerDeviceShader);
                ShaderManager.deleteProgram(yellowCircuitShader);
                ShaderManager.deleteProgram(starburstShader);
                ShaderManager.initShaderList();
            };
            ((SimpleReloadableResourceManager)iManager).func_110542_a(shaderReloadListener);
        }
    }

    public static IResourceManagerReloadListener getShaderReloadListener() {
        return shaderReloadListener;
    }

    private static void deleteProgram(int id) {
        if (id != 0) {
            OpenGlHelper.func_153187_e((int)id);
        }
    }

    private static void initShaderList() {
        twilightSkyShader = ShaderManager.createProgram("standard_texcoord.vert", "twilight_sky.frag");
        fireflyShader = ShaderManager.createProgram("standard_texcoord2.vert", "firefly.frag");
        auroraShader = ShaderManager.createProgram("standard_texcoord2.vert", "aurora.frag");
        carminiteShader = ShaderManager.createProgram("camera_fixed.vert", "spiral.frag");
        towerDeviceShader = ShaderManager.createProgram("camera_fixed.vert", "pulsing.frag");
        yellowCircuitShader = ShaderManager.createProgram("standard_texcoord2.vert", "pulsing_yellow.frag");
        starburstShader = ShaderManager.createProgram("standard_texcoord2.vert", "starburst.frag");
        shieldShader = ShaderManager.createProgram("standard_texcoord2.vert", "shield.frag");
    }

    public static void useShader(int shader, @Nullable IntConsumer callback) {
        if (!ShaderManager.useShaders()) {
            return;
        }
        OpenGlHelper.func_153161_d((int)shader);
        if (shader != 0 && callback != null) {
            callback.accept(shader);
        }
    }

    public static void useShader(int shader, ShaderUniform uniform) {
        if (!ShaderManager.useShaders()) {
            return;
        }
        OpenGlHelper.func_153161_d((int)shader);
        if (shader != 0) {
            uniform.assignUniform(shader);
        }
    }

    public static void useShader(int shader, ShaderUniform ... uniforms) {
        if (!ShaderManager.useShaders()) {
            return;
        }
        OpenGlHelper.func_153161_d((int)shader);
        if (shader != 0) {
            for (ShaderUniform uniform : uniforms) {
                uniform.assignUniform(shader);
            }
        }
    }

    public static void useShader(int shader) {
        if (!ShaderManager.useShaders()) {
            return;
        }
        OpenGlHelper.func_153161_d((int)shader);
    }

    public static void releaseShader() {
        ShaderManager.useShader(0);
    }

    public static boolean useShaders() {
        return TFConfig.performance.shadersSupported && OpenGlHelper.field_148824_g;
    }

    private static int createProgram(String vert, String frag) {
        int program = OpenGlHelper.func_153183_d();
        if (program == 0) {
            return 0;
        }
        int vertId = ShaderManager.createShader(PREFIX + vert, VERT);
        OpenGlHelper.func_153178_b((int)program, (int)vertId);
        int fragId = ShaderManager.createShader(PREFIX + frag, FRAG);
        OpenGlHelper.func_153178_b((int)program, (int)fragId);
        OpenGlHelper.func_153179_f((int)program);
        if (OpenGlHelper.func_153175_a((int)program, (int)OpenGlHelper.field_153207_o) == 0) {
            TwilightForestMod.LOGGER.error("Failed to create shader! (LINK) {} {}", (Object)vert, (Object)frag);
            TwilightForestMod.LOGGER.error(ShaderManager.getProgramInfoLog(program));
            return 0;
        }
        ShaderManager.glValidateProgram(program);
        if (OpenGlHelper.func_153175_a((int)program, (int)VALIDATE_STATUS) == 0) {
            TwilightForestMod.LOGGER.error("Failed to create shader! (VALIDATE) {} {}", (Object)vert, (Object)frag);
            TwilightForestMod.LOGGER.error(ShaderManager.getProgramInfoLog(program));
            return 0;
        }
        return program;
    }

    private static int createShader(String filename, int shaderType) {
        int shader = 0;
        try {
            shader = OpenGlHelper.func_153195_b((int)shaderType);
            if (shader == 0) {
                return 0;
            }
            OpenGlHelper.func_153169_a((int)shader, (ByteBuffer)ShaderManager.readFile(filename));
            OpenGlHelper.func_153170_c((int)shader);
            if (OpenGlHelper.func_153157_c((int)shader, (int)OpenGlHelper.field_153208_p) == 0) {
                TwilightForestMod.LOGGER.error("Failed to create shader! (COMPILE) {}", (Object)filename);
                throw new RuntimeException("Error creating shader: " + ShaderManager.getShaderInfoLog(shader));
            }
            return shader;
        }
        catch (Exception e) {
            OpenGlHelper.func_153180_a((int)shader);
            e.printStackTrace();
            return -1;
        }
    }

    private static ByteBuffer readFile(String path) throws IOException {
        try (InputStream in = ShaderManager.class.getResourceAsStream(path);){
            byte[] bytes = IOUtils.toByteArray((InputStream)in);
            ByteBuffer byteBuffer = (ByteBuffer)BufferUtils.createByteBuffer((int)bytes.length).put(bytes).position(0);
            return byteBuffer;
        }
    }

    private static String getShaderInfoLog(int shader) {
        return OpenGlHelper.func_153158_d((int)shader, (int)OpenGlHelper.func_153157_c((int)shader, (int)INFO_LOG_LENGTH));
    }

    private static String getProgramInfoLog(int program) {
        return OpenGlHelper.func_153166_e((int)program, (int)OpenGlHelper.func_153175_a((int)program, (int)INFO_LOG_LENGTH));
    }

    private static void glValidateProgram(int program) {
        if (OpenGlHelper.field_153214_y) {
            ARBShaderObjects.glValidateProgramARB((int)program);
        } else {
            GL20.glValidateProgram((int)program);
        }
    }

    static void glUniform2i(int location, int v0, int v1) {
        if (OpenGlHelper.field_153214_y) {
            ARBShaderObjects.glUniform2iARB((int)location, (int)v0, (int)v1);
        } else {
            GL20.glUniform2i((int)location, (int)v0, (int)v1);
        }
    }

    static void glUniform1f(int location, float v0) {
        if (OpenGlHelper.field_153214_y) {
            ARBShaderObjects.glUniform1fARB((int)location, (float)v0);
        } else {
            GL20.glUniform1f((int)location, (float)v0);
        }
    }

    static void glUniform2f(int location, float v0, float v1) {
        if (OpenGlHelper.field_153214_y) {
            ARBShaderObjects.glUniform2fARB((int)location, (float)v0, (float)v1);
        } else {
            GL20.glUniform2f((int)location, (float)v0, (float)v1);
        }
    }

    static {
        VERT = OpenGlHelper.field_153214_y ? 35633 : 35633;
        FRAG = OpenGlHelper.field_153214_y ? 35632 : 35632;
        INFO_LOG_LENGTH = OpenGlHelper.field_153214_y ? 35716 : 35716;
        VALIDATE_STATUS = OpenGlHelper.field_153214_y ? 35715 : 35715;
    }

    public static final class Uniforms {
        public static final ShaderUniform TIME = ShaderUniform.create("time", () -> (float)TFClientEvents.time + Minecraft.func_71410_x().func_184121_ak());
        public static final ShaderUniform YAW = ShaderUniform.create("yaw", () -> Minecraft.func_71410_x().field_71439_g.field_70177_z * 2.0f * (float)Math.PI / 360.0f);
        public static final ShaderUniform PITCH = ShaderUniform.create("pitch", () -> -(Minecraft.func_71410_x().field_71439_g.field_70125_A * 2.0f * (float)Math.PI) / 360.0f);
        public static final ShaderUniform RESOLUTION = ShaderUniform.create("resolution", () -> Minecraft.func_71410_x().field_71443_c, () -> Minecraft.func_71410_x().field_71440_d);
        public static final ShaderUniform ZERO = ShaderUniform.create("zero", 0);
        public static final ShaderUniform ONE = ShaderUniform.create("one", 1);
        public static final ShaderUniform TWO = ShaderUniform.create("two", 2);
        public static final ShaderUniform[] STAR_UNIFORMS = new ShaderUniform[]{TIME, YAW, PITCH, RESOLUTION, ZERO, TWO};
        public static final ShaderUniform[] TIME_UNIFORM = new ShaderUniform[]{TIME};
    }
}

