/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.item;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import slimeknights.mantle.item.ItemBlockMeta;
import slimeknights.tconstruct.library.Util;

public class ItemTank
extends ItemBlockMeta {
    public ItemTank(Block block) {
        super(block);
        this.func_185043_a(new ResourceLocation("amount"), TankCapacityGetter.INSTANCE);
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        if (stack.func_77942_o()) {
            FluidTank tank = new FluidTank(0);
            tank.readFromNBT(stack.func_77978_p());
            if (tank.getFluidAmount() > 0) {
                tooltip.add(Util.translateFormatted("tooltip.tank.fluid", tank.getFluid().getLocalizedName()));
                tooltip.add(Util.translateFormatted("tooltip.tank.amount", tank.getFluid().amount));
            }
        }
    }

    public static enum TankCapacityGetter implements IItemPropertyGetter
    {
        INSTANCE;


        public float func_185085_a(ItemStack stack, World worldIn, EntityLivingBase entityIn) {
            if (!stack.func_77942_o()) {
                return 0.0f;
            }
            FluidStack fluid = FluidStack.loadFluidStackFromNBT((NBTTagCompound)stack.func_77978_p());
            if (fluid != null && fluid.amount > 0) {
                return (float)fluid.amount / 4000.0f;
            }
            return 0.0f;
        }
    }
}

