/*
 * Decompiled with CFR 0.152.
 */
package magicbees.world;

import com.google.common.base.Predicate;
import forestry.api.apiculture.hives.IHiveGen;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class HiveGenUnderground
implements IHiveGen {
    protected final int minLevel;
    protected final int range;
    protected final Block replace;
    private final int surroundCount;

    public HiveGenUnderground(int minLevel, int range, int surroundCount) {
        this(minLevel, range, Blocks.field_150348_b, surroundCount);
    }

    public HiveGenUnderground(int minLevel, int range, Block replace, int surroundCount) {
        this.minLevel = minLevel;
        this.range = range;
        this.replace = replace;
        this.surroundCount = surroundCount;
    }

    @Nullable
    public BlockPos getPosForHive(@Nonnull World world, int x, int z) {
        return new BlockPos(x, this.minLevel + world.field_73012_v.nextInt(this.range), z);
    }

    public boolean isValidLocation(@Nonnull World world, @Nonnull BlockPos blockPos) {
        int i = this.surroundCount;
        for (EnumFacing f : EnumFacing.field_82609_l) {
            if (HiveGenUnderground.isReplaceableOreGen(world.func_180495_p(blockPos.func_177972_a(f)), world, blockPos, this.replace)) {
                --i;
            }
            if (i > 0) continue;
            return true;
        }
        return false;
    }

    public boolean canReplace(@Nonnull IBlockState iBlockState, @Nonnull World world, @Nonnull BlockPos blockPos) {
        return !world.func_175623_d(blockPos) && HiveGenUnderground.isReplaceableOreGen(iBlockState, world, blockPos, this.replace);
    }

    public static boolean isReplaceableOreGen(IBlockState iBlockState, World world, BlockPos blockPos, final Block replace) {
        return iBlockState.func_177230_c().isReplaceableOreGen(iBlockState, (IBlockAccess)world, blockPos, (Predicate)new Predicate<IBlockState>(){

            public boolean apply(IBlockState input) {
                return input.func_177230_c() == replace;
            }
        });
    }
}

