/*
 * Decompiled with CFR 0.152.
 */
package magicbees.integration.thermalexpansion;

import com.google.common.base.Preconditions;
import magicbees.api.module.IMagicBeesInitialisationEvent;
import magicbees.api.module.IMagicBeesModule;
import magicbees.api.module.MagicBeesModule;
import magicbees.bees.BeeIntegrationInterface;
import magicbees.elec332.corerepack.compat.forestry.allele.AlleleEffectSpawnMob;
import magicbees.elec332.corerepack.item.ItemEnumBased;
import magicbees.init.ItemRegister;
import magicbees.item.types.EnumDropType;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.event.FMLInterModComms;

@MagicBeesModule(owner="magicbees", name="ThermalExpansion Integration", modDependencies="thermalexpansion")
public class IntegrationThermalExpansion
implements IMagicBeesModule {
    @Override
    public void init(IMagicBeesInitialisationEvent event) {
        ItemEnumBased drops = (ItemEnumBased)((Object)Preconditions.checkNotNull(ItemRegister.dropItem));
        IntegrationThermalExpansion.addCrucibleRecipe(drops.getStackFromType(EnumDropType.CARBON), FluidRegistry.getFluid((String)"coal"));
        IntegrationThermalExpansion.addCrucibleRecipe(drops.getStackFromType(EnumDropType.DESTABILIZED), FluidRegistry.getFluid((String)"redstone"));
        IntegrationThermalExpansion.addCrucibleRecipe(drops.getStackFromType(EnumDropType.ENDEARING), FluidRegistry.getFluid((String)"ender"));
        IntegrationThermalExpansion.addCrucibleRecipe(drops.getStackFromType(EnumDropType.LUX), FluidRegistry.getFluid((String)"glowstone"));
        BeeIntegrationInterface.effectSpawnBasalz = new AlleleEffectSpawnMob(BeeIntegrationInterface.te_spawnBasalz_name, new ResourceLocation("thermalfoundation:basalz")).setThrottle(100).setSpawnChance(80);
        BeeIntegrationInterface.effectSpawnBlitz = new AlleleEffectSpawnMob(BeeIntegrationInterface.te_spawnBlitz_name, new ResourceLocation("thermalfoundation:blitz")).setThrottle(100).setSpawnChance(80);
        BeeIntegrationInterface.effectSpawnBlizz = new AlleleEffectSpawnMob(BeeIntegrationInterface.te_spawnBlizz_name, new ResourceLocation("thermalfoundation:blizz")).setThrottle(100).setSpawnChance(80);
    }

    private static void addCrucibleRecipe(ItemStack in, Fluid out) {
        IntegrationThermalExpansion.addCrucibleRecipe(in, new FluidStack((Fluid)Preconditions.checkNotNull((Object)out), 50));
    }

    private static void addCrucibleRecipe(ItemStack in, FluidStack out) {
        NBTTagCompound main = new NBTTagCompound();
        main.func_74768_a("energy", 4000);
        main.func_74782_a("input", (NBTBase)((ItemStack)Preconditions.checkNotNull((Object)in)).func_77955_b(new NBTTagCompound()));
        main.func_74782_a("output", (NBTBase)((FluidStack)Preconditions.checkNotNull((Object)out)).writeToNBT(new NBTTagCompound()));
        FMLInterModComms.sendMessage((String)"thermalexpansion", (String)"addcruciblerecipe", (NBTTagCompound)main);
    }
}

