/*
 * Decompiled with CFR 0.152.
 */
package magicbees.integration.botania;

import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.EnumBeeType;
import forestry.api.apiculture.IBee;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.ISpeciesType;
import java.util.List;
import java.util.Random;
import magicbees.integration.botania.BotaniaIntegrationConfig;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import vazkii.botania.api.subtile.SubTileFunctional;

public class SubTileHibeescus
extends SubTileFunctional {
    public static final String NAME = "hibeescus";
    private final int MANA_PER_OPERATION = 10000;
    private final int OPERATION_TICKS_TIME = 18000;
    private final double RANGE = 0.75;
    private ItemStack beeSlot = ItemStack.field_190927_a;
    private long operationTicksRemaining;
    private float manaCostRollover;

    public int getColor() {
        return 0xF94F4F;
    }

    public void onUpdate() {
        super.onUpdate();
        if (this.supertile.func_145831_w().field_72995_K) {
            return;
        }
        if (!this.beeSlot.func_190926_b()) {
            this.progressOperation();
        } else if (this.isTimeToPickUpItem() && this.redstoneSignal == 0) {
            this.findBeeItemToHold();
        }
    }

    private boolean isTimeToPickUpItem() {
        return (this.supertile.func_145831_w().func_82737_E() ^ (long)this.supertile.func_174877_v().func_177958_n() ^ (long)this.supertile.func_174877_v().func_177952_p()) % 11L == 0L;
    }

    private void progressOperation() {
        if (0L < this.operationTicksRemaining && 0 < this.mana) {
            --this.operationTicksRemaining;
            this.manaCostRollover += this.getManaPerOpTick();
            if (1.0f <= this.manaCostRollover) {
                int amount = (int)this.manaCostRollover;
                this.mana -= amount;
                this.manaCostRollover -= (float)amount;
            }
        } else if (this.operationTicksRemaining <= 0L) {
            IBee bee = BeeManager.beeRoot.getMember(this.beeSlot);
            if (bee == null) {
                return;
            }
            bee.setIsNatural(true);
            EnumBeeType beeType = EnumBeeType.QUEEN;
            if (bee.getMate() == null) {
                beeType = EnumBeeType.PRINCESS;
            }
            ItemStack outputStack = BeeManager.beeRoot.getMemberStack((IIndividual)bee, (ISpeciesType)beeType);
            EntityItem entity = this.dropItemStackInRange(outputStack);
            this.supertile.func_145831_w().func_72838_d((Entity)entity);
            this.beeSlot = ItemStack.field_190927_a;
        }
    }

    private EntityItem dropItemStackInRange(ItemStack outputStack) {
        Random r = this.supertile.func_145831_w().field_73012_v;
        EntityItem entity = new EntityItem(this.supertile.func_145831_w(), (double)this.supertile.func_174877_v().func_177958_n() - 0.75 + (double)r.nextInt(2), (double)(this.supertile.func_174877_v().func_177956_o() + 1), (double)this.supertile.func_174877_v().func_177952_p() - 0.75 + (double)r.nextInt(2), outputStack);
        entity.field_70159_w = 0.0;
        entity.field_70181_x = 0.0;
        entity.field_70179_y = 0.0;
        return entity;
    }

    private void findBeeItemToHold() {
        List items = this.supertile.func_145831_w().func_72872_a(EntityItem.class, this.getSearchBoundingBox());
        for (EntityItem itemEntity : items) {
            ItemStack item = itemEntity.func_92059_d();
            if (itemEntity.field_70128_L || !this.isItemPrincessOrQueen(item)) continue;
            this.beeSlot = itemEntity.func_92059_d().func_77946_l();
            this.beeSlot.func_190920_e(1);
            this.operationTicksRemaining = (long)(18000.0f * BotaniaIntegrationConfig.hibeescusTicksMultiplier) + (long)this.supertile.func_145831_w().field_73012_v.nextInt(200);
            this.manaCostRollover = 0.0f;
            item.func_190918_g(1);
            if (item.func_190916_E() > 0) break;
            itemEntity.func_70106_y();
            break;
        }
    }

    private boolean isItemPrincessOrQueen(ItemStack stack) {
        IBee bee;
        boolean isBee;
        boolean bl = isBee = BeeManager.beeRoot.isMember(stack, (ISpeciesType)EnumBeeType.PRINCESS) || BeeManager.beeRoot.isMember(stack, (ISpeciesType)EnumBeeType.QUEEN);
        return isBee && (bee = BeeManager.beeRoot.getMember(stack)) != null && !bee.isNatural();
    }

    private AxisAlignedBB getSearchBoundingBox() {
        BlockPos pos = this.supertile.func_174877_v();
        int xCoord = pos.func_177958_n();
        int yCoord = pos.func_177956_o();
        int zCoord = pos.func_177952_p();
        return new AxisAlignedBB((double)xCoord - 0.75, (double)yCoord, (double)zCoord - 0.75, (double)xCoord + 0.75 + 1.0, (double)(yCoord + 1), (double)zCoord + 0.75 + 1.0);
    }

    public void readFromPacketNBT(NBTTagCompound cmp) {
        super.readFromPacketNBT(cmp);
        if (cmp.func_74764_b("slot")) {
            NBTTagCompound itemTag = (NBTTagCompound)cmp.func_74781_a("slot");
            this.beeSlot = new ItemStack(itemTag);
        }
        this.operationTicksRemaining = cmp.func_74763_f("operationTicks");
        this.manaCostRollover = cmp.func_74760_g("manaRollover");
    }

    public void writeToPacketNBT(NBTTagCompound cmp) {
        super.writeToPacketNBT(cmp);
        if (!this.beeSlot.func_190926_b()) {
            NBTTagCompound itemTag = new NBTTagCompound();
            this.beeSlot.func_77955_b(itemTag);
            cmp.func_74782_a("slot", (NBTBase)itemTag);
        }
        cmp.func_74772_a("operationTicks", this.operationTicksRemaining);
        cmp.func_74776_a("manaRollover", this.manaCostRollover);
    }

    public List<ItemStack> getDrops(List<ItemStack> list) {
        if (!this.beeSlot.func_190926_b()) {
            list.add(this.beeSlot);
        }
        return super.getDrops(list);
    }

    public int getMaxMana() {
        return this.getFinalOperationManaCost() / 20;
    }

    private int getFinalOperationManaCost() {
        return (int)(10000.0f * BotaniaIntegrationConfig.hibeescusManaCostMultiplier);
    }

    private float getManaPerOpTick() {
        return this.getFinalOperationManaCost() / 18000;
    }

    public boolean acceptsRedstone() {
        return true;
    }
}

