/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.item;

import com.lothrazar.cyclicmagic.ModCyclic;
import com.lothrazar.cyclicmagic.capability.IPlayerExtendedProperties;
import com.lothrazar.cyclicmagic.config.IHasConfig;
import com.lothrazar.cyclicmagic.data.IHasRecipe;
import com.lothrazar.cyclicmagic.item.core.ItemFoodCreative;
import com.lothrazar.cyclicmagic.net.PacketSyncPlayerHealth;
import com.lothrazar.cyclicmagic.registry.CapabilityRegistry;
import com.lothrazar.cyclicmagic.registry.RecipeRegistry;
import com.lothrazar.cyclicmagic.registry.SoundRegistry;
import com.lothrazar.cyclicmagic.util.UtilChat;
import com.lothrazar.cyclicmagic.util.UtilEntity;
import com.lothrazar.cyclicmagic.util.UtilSound;
import java.util.List;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFishFood;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemHeartContainer
extends ItemFoodCreative
implements IHasRecipe,
IHasConfig {
    private static final int numFood = 2;
    private int heartChangeOnEat = 1;
    public static int defaultHearts = 10;
    private static int maxHearts = 20;

    public ItemHeartContainer(int heartChangeOnEat) {
        super(2, false);
        this.heartChangeOnEat = heartChangeOnEat;
    }

    protected void func_77849_c(ItemStack par1ItemStack, World world, EntityPlayer player) {
        if (!this.canEat(player)) {
            return;
        }
        IPlayerExtendedProperties prop = CapabilityRegistry.getPlayerProperties(player);
        int healthChange = 2 * this.heartChangeOnEat;
        int newVal = UtilEntity.incrementMaxHealth((EntityLivingBase)player, healthChange);
        prop.setMaxHealth(newVal);
        UtilChat.sendStatusMessage(player, newVal / 2 + "");
        UtilSound.playSound(player, SoundRegistry.heart_container);
    }

    @Override
    public IRecipe addRecipe() {
        if (this.heartChangeOnEat > 0) {
            return RecipeRegistry.addShapelessRecipe(new ItemStack((Item)this), Items.field_179560_bq, Blocks.field_150392_bi, Items.field_151158_bO, "gemDiamond", Items.field_151106_aX, "blockEmerald", new ItemStack(Items.field_151115_aP, 1, ItemFishFood.FishType.SALMON.func_150976_a()), new ItemStack(Items.field_151153_ao, 1, 0), Items.field_151170_bI);
        }
        return RecipeRegistry.addShapelessRecipe(new ItemStack((Item)this), Items.field_185164_cV, Items.field_151055_y, Items.field_151102_aT, "dirt", Items.field_151105_aU, "cobblestone", new ItemStack(Items.field_151070_bp), Items.field_151034_e, Items.field_151070_bp);
    }

    @SubscribeEvent
    public void onPlayerWarp(PlayerEvent.PlayerChangedDimensionEvent event) {
        IPlayerExtendedProperties props = CapabilityRegistry.getPlayerProperties(event.player);
        if (props.getMaxHealth() > 0 && event.player instanceof EntityPlayerMP) {
            ModCyclic.network.sendTo((IMessage)new PacketSyncPlayerHealth(props.getMaxHealth()), (EntityPlayerMP)event.player);
        }
    }

    @Override
    public void syncConfig(Configuration config) {
        maxHearts = config.getInt("HeartContainerMax", "modpacks", 20, 10, 100, "Maximum number of heart containers you can get by eating heart containers.  Does not limit the /sethearts command");
        defaultHearts = config.getInt("HeartContainerDefault", "cyclicmagic.player", 10, 1, 100, "Default number of heart containers a new player will start with when first joining the world.  Will not affect existing players once they have joined.  (For Maximum heart limit given by the heart container see 'modpacks' category in the config file)");
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
        tooltip.add(UtilChat.lang(this.func_77658_a() + ".tooltip"));
    }

    private boolean canEat(EntityPlayer player) {
        double currentHearts = UtilEntity.getMaxHealth((EntityLivingBase)player) / 2.0;
        return !(currentHearts + (double)this.heartChangeOnEat > (double)maxHearts) && !(currentHearts + (double)this.heartChangeOnEat < 1.0);
    }

    @Override
    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer player, EnumHand hand) {
        if (!this.canEat(player)) {
            return new ActionResult(EnumActionResult.FAIL, (Object)player.func_184586_b(hand));
        }
        return super.func_77659_a(worldIn, player, hand);
    }
}

