/*
 * Decompiled with CFR 0.152.
 */
package nc.recipe.ingredient;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import nc.recipe.IngredientSorption;
import nc.recipe.ingredient.IItemIngredient;
import nc.recipe.ingredient.ItemArrayIngredient;
import nc.recipe.ingredient.ItemIngredient;
import nc.util.OreDictHelper;
import net.minecraft.item.ItemStack;

public class OreIngredient
implements IItemIngredient {
    public String oreName;
    public final List<ItemStack> cachedStackList;
    public int stackSize;

    public OreIngredient(String oreName, int stackSize) {
        this.oreName = oreName;
        this.cachedStackList = OreDictHelper.getPrioritisedStackList(oreName);
        this.stackSize = stackSize;
    }

    @Override
    public ItemStack getStack() {
        if (this.cachedStackList == null || this.cachedStackList.isEmpty() || this.cachedStackList.get(0) == null) {
            return null;
        }
        ItemStack item = this.cachedStackList.get(0).func_77946_l();
        item.func_190920_e(this.stackSize);
        return item;
    }

    @Override
    public String getIngredientName() {
        return "ore:" + this.oreName;
    }

    @Override
    public String getIngredientNamesConcat() {
        return this.getIngredientName();
    }

    @Override
    public boolean matches(Object object, IngredientSorption type) {
        if (object instanceof OreIngredient) {
            OreIngredient oreStack = (OreIngredient)object;
            if (oreStack.oreName.equals(this.oreName) && type.checkStackSize(this.stackSize, oreStack.stackSize)) {
                return true;
            }
        } else {
            if (object instanceof String) {
                return this.oreName.equals(object);
            }
            if (object instanceof ItemStack && type.checkStackSize(this.stackSize, ((ItemStack)object).func_190916_E())) {
                ItemStack itemstack = (ItemStack)object;
                if (itemstack.func_190926_b()) {
                    return false;
                }
                if (OreDictHelper.getOreNames(itemstack).contains(this.oreName)) {
                    return true;
                }
            } else if (object instanceof ItemIngredient) {
                if (this.matches(((ItemIngredient)object).stack, type)) {
                    return true;
                }
            } else if (object instanceof ItemArrayIngredient) {
                for (IItemIngredient ingredient : ((ItemArrayIngredient)object).ingredientList) {
                    if (this.matches(ingredient, type)) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public int getMaxStackSize() {
        return this.stackSize;
    }

    @Override
    public void setMaxStackSize(int stackSize) {
        this.stackSize = stackSize;
        for (ItemStack stack : this.cachedStackList) {
            stack.func_190920_e(stackSize);
        }
    }

    @Override
    public List<ItemStack> getInputStackList() {
        ArrayList<ItemStack> stackList = new ArrayList<ItemStack>();
        for (ItemStack item : this.cachedStackList) {
            ItemStack itemStack = item.func_77946_l();
            itemStack.func_190920_e(this.stackSize);
            stackList.add(itemStack);
        }
        return stackList;
    }

    @Override
    public List<ItemStack> getOutputStackList() {
        if (this.cachedStackList == null || this.cachedStackList.isEmpty()) {
            return new ArrayList<ItemStack>();
        }
        return Lists.newArrayList((Object[])new ItemStack[]{this.getStack()});
    }

    @Override
    public boolean isValid() {
        return this.cachedStackList != null && !this.cachedStackList.isEmpty() && this.cachedStackList.get(0) != null;
    }
}

