/*
 * Decompiled with CFR 0.152.
 */
package nc.integration.crafttweaker;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.item.IngredientOr;
import crafttweaker.api.item.IngredientStack;
import crafttweaker.api.liquid.ILiquidStack;
import crafttweaker.api.oredict.IOreDictEntry;
import java.util.ArrayList;
import nc.recipe.NCRecipes;
import nc.recipe.ingredient.EmptyFluidIngredient;
import nc.recipe.ingredient.EmptyItemIngredient;
import nc.recipe.ingredient.FluidIngredient;
import nc.recipe.ingredient.IFluidIngredient;
import nc.recipe.ingredient.IItemIngredient;
import nc.recipe.ingredient.OreIngredient;
import nc.util.ItemStackHelper;
import nc.util.RecipeHelper;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class CTMethods {
    public static ItemStack getItemStack(IItemStack item) {
        if (item == null) {
            return ItemStack.field_190927_a;
        }
        Object internal = item.getInternal();
        if (!(internal instanceof ItemStack)) {
            CraftTweakerAPI.logError((String)("Not a valid item stack: " + item));
        }
        return ((ItemStack)internal).func_77946_l();
    }

    public static FluidStack getFluidStack(ILiquidStack stack) {
        if (stack == null) {
            return null;
        }
        return (FluidStack)stack.getInternal();
    }

    public static IItemIngredient buildAdditionItemIngredient(Object ingredient, NCRecipes.Type recipeType) {
        if (ingredient == null) {
            return new EmptyItemIngredient();
        }
        if (ingredient instanceof IItemStack) {
            return recipeType.getRecipeHandler().buildItemIngredient(CTMethods.getItemStack((IItemStack)ingredient));
        }
        if (ingredient instanceof IOreDictEntry) {
            return new OreIngredient(((IOreDictEntry)ingredient).getName(), ((IOreDictEntry)ingredient).getAmount());
        }
        if (ingredient instanceof IngredientStack) {
            return CTMethods.buildOreIngredientArray((IngredientStack)ingredient, recipeType);
        }
        if (ingredient instanceof IngredientOr) {
            return CTMethods.buildItemIngredientArray((IIngredient)((IngredientOr)ingredient), recipeType);
        }
        CraftTweakerAPI.logError((String)String.format("%s: Invalid ingredient: %s, %s", recipeType.getRecipeName(), ingredient.getClass().getName(), ingredient));
        return null;
    }

    public static IFluidIngredient buildAdditionFluidIngredient(Object ingredient, NCRecipes.Type recipeType) {
        if (ingredient == null) {
            return new EmptyFluidIngredient();
        }
        if (ingredient instanceof ILiquidStack) {
            return recipeType.getRecipeHandler().buildFluidIngredient(CTMethods.getFluidStack((ILiquidStack)ingredient));
        }
        if (ingredient instanceof IngredientOr) {
            return CTMethods.buildFluidIngredientArray((IngredientOr)ingredient, recipeType);
        }
        CraftTweakerAPI.logError((String)String.format("%s: Invalid ingredient: %s, %s", recipeType.getRecipeName(), ingredient.getClass().getName(), ingredient));
        return null;
    }

    public static IItemIngredient buildRemovalItemIngredient(IIngredient ingredient, NCRecipes.Type recipeType) {
        if (ingredient == null) {
            return new EmptyItemIngredient();
        }
        if (ingredient instanceof IItemStack) {
            return recipeType.getRecipeHandler().buildItemIngredient(CTMethods.getItemStack((IItemStack)ingredient));
        }
        if (ingredient instanceof IOreDictEntry) {
            return new OreIngredient(((IOreDictEntry)ingredient).getName(), ((IOreDictEntry)ingredient).getAmount());
        }
        if (ingredient instanceof IngredientStack) {
            return CTMethods.buildItemIngredientArray((IIngredient)((IngredientStack)ingredient), recipeType);
        }
        if (ingredient instanceof IngredientOr) {
            return CTMethods.buildItemIngredientArray((IIngredient)((IngredientOr)ingredient), recipeType);
        }
        CraftTweakerAPI.logError((String)String.format("%s: Invalid ingredient: %s, %s", recipeType.getRecipeName(), ingredient.getClass().getName(), ingredient));
        return null;
    }

    public static IFluidIngredient buildRemovalFluidIngredient(IIngredient ingredient, NCRecipes.Type recipeType) {
        if (ingredient == null) {
            return new EmptyFluidIngredient();
        }
        if (ingredient instanceof ILiquidStack) {
            return new FluidIngredient(((ILiquidStack)ingredient).getName(), ((ILiquidStack)ingredient).getAmount());
        }
        if (ingredient instanceof IngredientOr) {
            return CTMethods.buildFluidIngredientArray((IngredientOr)ingredient, recipeType);
        }
        CraftTweakerAPI.logError((String)String.format("%s: Invalid ingredient: %s, %s", recipeType.getRecipeName(), ingredient.getClass().getName(), ingredient));
        return null;
    }

    public static IItemIngredient buildItemIngredientArray(IIngredient ingredient, NCRecipes.Type recipeType) {
        ArrayList stackList = new ArrayList();
        ingredient.getItems().forEach(item -> stackList.add(CTMethods.getItemStack(item)));
        return recipeType.getRecipeHandler().buildItemIngredient(stackList);
    }

    public static IItemIngredient buildOreIngredientArray(IngredientStack stack, NCRecipes.Type recipeType) {
        ArrayList<ItemStack> stackList = new ArrayList<ItemStack>();
        stack.getItems().forEach(item -> stackList.add(ItemStackHelper.changeStackSize(CTMethods.getItemStack(item), stack.getAmount())));
        OreIngredient oreStack = RecipeHelper.getOreStackFromItems(stackList, stack.getAmount());
        if (oreStack != null) {
            return oreStack;
        }
        return recipeType.getRecipeHandler().buildItemIngredient(stackList);
    }

    public static IFluidIngredient buildFluidIngredientArray(IngredientOr ingredient, NCRecipes.Type recipeType) {
        ArrayList stackList = new ArrayList();
        ingredient.getLiquids().forEach(fluid -> stackList.add(CTMethods.getFluidStack(fluid)));
        return recipeType.getRecipeHandler().buildFluidIngredient(stackList);
    }
}

