/*
 * Decompiled with CFR 0.152.
 */
package nc.capability.radiation.entity;

import nc.capability.radiation.entity.IEntityRads;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.MathHelper;

public class EntityRads
implements IEntityRads {
    private final double maxRads;
    private double totalRads = 0.0;
    private double radiationLevel = 0.0;
    private double radiationResistance = 0.0;
    private boolean radXWoreOff = false;
    private double radawayBuffer = 0.0;
    private boolean consumed = false;
    private double radawayCooldown = 0.0;
    private double radXCooldown = 0.0;
    private double radiationImmunityTime = 0.0;

    public EntityRads(double maxRads) {
        this.maxRads = maxRads;
    }

    @Override
    public NBTTagCompound writeNBT(IEntityRads instance, EnumFacing side, NBTTagCompound nbt) {
        nbt.func_74780_a("totalRads", this.getTotalRads());
        nbt.func_74780_a("radiationLevel", this.getRadiationLevel());
        nbt.func_74780_a("radiationResistance", this.getRadiationResistance());
        nbt.func_74757_a("radXWoreOff", this.getRadXWoreOff());
        nbt.func_74780_a("radawayCooldown", this.getRadawayCooldown());
        nbt.func_74780_a("radXCooldown", this.getRadXCooldown());
        nbt.func_74780_a("radiationImmunityTime", this.getRadiationImmunityTime());
        return nbt;
    }

    @Override
    public void readNBT(IEntityRads instance, EnumFacing side, NBTTagCompound nbt) {
        this.setTotalRads(nbt.func_74769_h("totalRads"), false);
        this.setRadiationLevel(nbt.func_74769_h("radiationLevel"));
        this.setRadiationResistance(nbt.func_74769_h("radiationResistance"));
        this.setRadXWoreOff(nbt.func_74767_n("radXWoreOff"));
        this.setRadawayBuffer(nbt.func_74769_h("radawayBuffer"));
        this.setRadawayCooldown(nbt.func_74769_h("radawayCooldown"));
        this.setRadXCooldown(nbt.func_74769_h("radXCooldown"));
        this.setRadiationImmunityTime(nbt.func_74769_h("radiationImmunityTime"));
    }

    @Override
    public double getTotalRads() {
        return this.totalRads;
    }

    @Override
    public void setTotalRads(double newTotalRads, boolean useImmunity) {
        if (!useImmunity || this.getRadiationImmunityTime() <= 0.0) {
            this.totalRads = MathHelper.func_151237_a((double)newTotalRads, (double)0.0, (double)this.maxRads);
        }
    }

    @Override
    public double getMaxRads() {
        return this.maxRads;
    }

    @Override
    public double getRadiationLevel() {
        return this.radiationLevel;
    }

    @Override
    public void setRadiationLevel(double newRadiationLevel) {
        this.radiationLevel = Math.max(newRadiationLevel, 0.0);
    }

    @Override
    public double getRadiationResistance() {
        return this.radiationResistance;
    }

    @Override
    public void setRadiationResistance(double newRadiationResistance) {
        this.radiationResistance = Math.max(newRadiationResistance, 0.0);
    }

    @Override
    public boolean getRadXWoreOff() {
        return this.radXWoreOff;
    }

    @Override
    public void setRadXWoreOff(boolean radXWoreOff) {
        this.radXWoreOff = radXWoreOff;
    }

    @Override
    public double getRadawayBuffer() {
        return this.radawayBuffer;
    }

    @Override
    public void setRadawayBuffer(double newBuffer) {
        this.radawayBuffer = Math.max(newBuffer, 0.0);
    }

    @Override
    public boolean getConsumedMedicine() {
        return this.consumed;
    }

    @Override
    public void setConsumedMedicine(boolean consumed) {
        this.consumed = consumed;
    }

    @Override
    public double getRadawayCooldown() {
        return this.radawayCooldown;
    }

    @Override
    public void setRadawayCooldown(double cooldown) {
        this.radawayCooldown = Math.max(cooldown, 0.0);
    }

    @Override
    public boolean canConsumeRadaway() {
        return !this.consumed && this.radawayCooldown <= 0.0;
    }

    @Override
    public double getRadXCooldown() {
        return this.radXCooldown;
    }

    @Override
    public void setRadXCooldown(double cooldown) {
        this.radXCooldown = Math.max(cooldown, 0.0);
    }

    @Override
    public boolean canConsumeRadX() {
        return !this.consumed && this.radXCooldown <= 0.0;
    }

    @Override
    public double getRadiationImmunityTime() {
        return this.radiationImmunityTime;
    }

    @Override
    public void setRadiationImmunityTime(double newRadiationImmunityTime) {
        this.radiationImmunityTime = Math.max(newRadiationImmunityTime, 0.0);
    }
}

