/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.mysticalworld.init;

import epicsquid.mysticallib.event.RegisterModRecipesEvent;
import epicsquid.mysticalworld.config.ConfigManager;
import epicsquid.mysticalworld.init.ModItems;
import epicsquid.mysticalworld.materials.Gem;
import epicsquid.mysticalworld.materials.Metal;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import net.minecraftforge.registries.IForgeRegistry;

public class ModRecipes {
    private static ResourceLocation getRL(@Nonnull String s) {
        return new ResourceLocation("mysticalworld:" + s);
    }

    private static void registerShapeless(@Nonnull IForgeRegistry<IRecipe> registry, @Nonnull String name, @Nonnull ItemStack result, Object ... ingredients) {
        registry.register(new ShapelessOreRecipe(ModRecipes.getRL(name), result, ingredients).setRegistryName(ModRecipes.getRL(name)));
    }

    private static void registerShaped(@Nonnull IForgeRegistry<IRecipe> registry, @Nonnull String name, @Nonnull ItemStack result, Object ... ingredients) {
        registry.register(new ShapedOreRecipe(ModRecipes.getRL(name), result, ingredients).setRegistryName(ModRecipes.getRL(name)));
    }

    public static void initRecipes(@Nonnull RegisterModRecipesEvent event) {
        ModRecipes.registerShapeless((IForgeRegistry<IRecipe>)event.getRegistry(), "pelt", new ItemStack(Items.field_151116_aA, 1), new ItemStack(ModItems.pelt, 1), new ItemStack(ModItems.pelt, 1));
        if (ConfigManager.metals.enableDusts && ConfigManager.metals.enableTinyDusts) {
            ModRecipes.registerCompressionRecipe((IForgeRegistry<IRecipe>)event.getRegistry(), "dustIron", "dustTinyIron", ModItems.iron_dust, ModItems.iron_dust_tiny);
            ModRecipes.registerCompressionRecipe((IForgeRegistry<IRecipe>)event.getRegistry(), "dustGold", "dustTinyGold", ModItems.gold_dust, ModItems.gold_dust_tiny);
        }
        for (Metal metal : Metal.values()) {
            if (metal.hasGrindables() && ConfigManager.metals.enableDusts && ConfigManager.metals.enableTinyDusts) {
                ModRecipes.registerCompressionRecipe((IForgeRegistry<IRecipe>)event.getRegistry(), "dust" + metal.getOredictNameSuffix(), "dustTiny" + metal.getOredictNameSuffix(), metal.getDust(), metal.getDustTiny());
                GameRegistry.addSmelting((Item)metal.getDust(), (ItemStack)new ItemStack(metal.getIngot(), 1), (float)metal.getExperience());
            }
            if (ConfigManager.metals.enableIngots && ConfigManager.metals.enableNuggets) {
                ModRecipes.registerCompressionRecipe((IForgeRegistry<IRecipe>)event.getRegistry(), "ingot" + metal.getOredictNameSuffix(), "nugget" + metal.getOredictNameSuffix(), metal.getIngot(), metal.getNugget());
                ModRecipes.registerCompressionRecipe((IForgeRegistry<IRecipe>)event.getRegistry(), "block" + metal.getOredictNameSuffix(), "ingot" + metal.getOredictNameSuffix(), metal.getBlock(), metal.getIngot());
            }
            if (!metal.hasOre() || !ConfigManager.metals.enableOres) continue;
            GameRegistry.addSmelting((Block)metal.getOre(), (ItemStack)new ItemStack(metal.getIngot(), 1), (float)metal.getExperience());
        }
        for (Enum enum_ : Gem.values()) {
            if (!ConfigManager.gems.enableBlocks || !ConfigManager.gems.enableGems) continue;
            ModRecipes.registerCompressionRecipe((IForgeRegistry<IRecipe>)event.getRegistry(), "block" + ((Gem)enum_).getOredictNameSuffix(), "gem" + ((Gem)enum_).getOredictNameSuffix(), ((Gem)enum_).getBlock(), ((Gem)enum_).getGem());
        }
        GameRegistry.addSmelting((ItemStack)new ItemStack(ModItems.venison, 1), (ItemStack)new ItemStack(ModItems.cooked_venison), (float)0.1f);
        GameRegistry.addSmelting((Item)ModItems.aubergine, (ItemStack)new ItemStack(ModItems.cooked_aubergine), (float)0.125f);
    }

    private static void registerCompressionRecipe(@Nonnull IForgeRegistry<IRecipe> registry, @Nonnull String oredictCompressed, @Nonnull String oredictDecompressed, @Nonnull Item itemCompressed, @Nonnull Item itemDecompressed) {
        ModRecipes.registerShaped(registry, oredictCompressed + "Compression", new ItemStack(itemCompressed, 1), "XXX", "XXX", "XXX", Character.valueOf('X'), oredictDecompressed);
        ModRecipes.registerShapeless(registry, oredictDecompressed + "Decompression", new ItemStack(itemDecompressed, 9), oredictCompressed);
    }

    private static void registerCompressionRecipe(@Nonnull IForgeRegistry<IRecipe> registry, @Nonnull String oredictCompressed, @Nonnull String oredictDecompressed, @Nonnull Block blockCompressed, @Nonnull Item itemDecompressed) {
        ModRecipes.registerShaped(registry, oredictCompressed + "Compression", new ItemStack(blockCompressed, 1), "XXX", "XXX", "XXX", Character.valueOf('X'), oredictDecompressed);
        ModRecipes.registerShapeless(registry, oredictDecompressed + "Decompression", new ItemStack(itemDecompressed, 9), oredictCompressed);
    }
}

