/*
 * Decompiled with CFR 0.152.
 */
package com.astro.discordsuite.integration;

import com.astro.discordsuite.integration.ClassPredicate;
import com.astro.discordsuite.integration.Image;
import com.astro.discordsuite.integration.TypePredicate;
import com.astro.discordsuite.integration.WorldIDPredicate;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.world.World;

public enum Dimension {
    OVERWORLD(Image.OVERWORLD, new WorldIDPredicate(0)),
    NETHER(Image.NETHER, new WorldIDPredicate(-1)),
    END(Image.END, new WorldIDPredicate(1)),
    TWILIGHT(Image.TWILIGHT, new WorldIDPredicate(7)),
    RFTOOLS(Image.RFT, new TypePredicate("rftools_dimension")),
    AETHER_LEG(Image.AETHER_LEG, new ClassPredicate("com.legacy.aether.world.AetherWorldProvider")),
    AETHER(Image.AETHER, new ClassPredicate("com.gildedgames.aether.common.world.aether.WorldProviderAether")),
    GLACIDUS(Image.GLACIDUS, new ClassPredicate("com.legacy.glacidus.world.WorldProviderGlacidus")),
    UNKNOWN(Image.UNKNOWN, null);

    private static List<Dimension> DIMENSIONS;
    private final Image image;
    private final Predicate<World> worldPredicate;

    private Dimension(Image image, Predicate<World> worldPredicate) {
        this.image = image;
        this.worldPredicate = worldPredicate;
    }

    @Nonnull
    public static Dimension getDimension(World world) {
        return DIMENSIONS.stream().filter(dim -> dim.getWorldPredicate().test(world)).findFirst().orElse(UNKNOWN);
    }

    public Image getImage() {
        return this.image;
    }

    public Predicate<World> getWorldPredicate() {
        return this.worldPredicate;
    }

    static {
        DIMENSIONS = Lists.newArrayList((Object[])Dimension.values());
        DIMENSIONS.removeIf(dim -> dim.getWorldPredicate() == null);
    }
}

