/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.handler.darksteel;

import com.enderio.core.api.client.gui.IAdvancedTooltipProvider;
import com.enderio.core.client.handlers.SpecialTooltipHandler;
import com.enderio.core.common.util.NNList;
import com.enderio.core.common.util.NullHelper;
import com.google.common.collect.ImmutableList;
import crazypants.enderio.api.upgrades.IDarkSteelItem;
import crazypants.enderio.api.upgrades.IDarkSteelUpgrade;
import crazypants.enderio.base.EnderIO;
import crazypants.enderio.base.handler.darksteel.UpgradeRegistry;
import crazypants.enderio.base.lang.Lang;
import crazypants.enderio.util.StringUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber(modid="enderio")
public class DarkSteelRecipeManager {
    private static boolean skipUpgradeTooltips = false;

    @SubscribeEvent
    public static void handleAnvilEvent(AnvilUpdateEvent evt) {
        if (evt.getLeft().func_190916_E() == 1 && evt.getLeft().func_77973_b() instanceof IDarkSteelItem) {
            if (DarkSteelRecipeManager.isRepair(evt, (IDarkSteelItem)evt.getLeft().func_77973_b())) {
                DarkSteelRecipeManager.handleRepair(evt, (IDarkSteelItem)evt.getLeft().func_77973_b());
            } else {
                DarkSteelRecipeManager.handleUpgrade(evt, (IDarkSteelItem)evt.getLeft().func_77973_b());
            }
        }
    }

    private static boolean isRepair(AnvilUpdateEvent evt, @Nonnull IDarkSteelItem item) {
        return item.isItemForRepair(evt.getRight());
    }

    private static void handleRepair(AnvilUpdateEvent evt, @Nonnull IDarkSteelItem item) {
        int maxDamage;
        int damage;
        double damPerc;
        int requiredIngots;
        ItemStack targetStack = evt.getLeft();
        ItemStack ingots = evt.getRight();
        int maxIngots = item.getIngotsRequiredForFullRepair();
        int ingouts = ingots.func_190916_E();
        if (ingouts > (requiredIngots = (int)Math.ceil((damPerc = (double)(damage = targetStack.func_77952_i()) / (double)(maxDamage = targetStack.func_77958_k())) * (double)maxIngots))) {
            ingouts = requiredIngots;
        }
        int damageAddedPerIngot = (int)Math.ceil((double)maxDamage / (double)maxIngots);
        int totalDamageRemoved = damageAddedPerIngot * ingouts;
        ItemStack resultStack = targetStack.func_77946_l();
        resultStack.func_77964_b(Math.max(0, damage - totalDamageRemoved));
        evt.setOutput(resultStack);
        evt.setCost(ingouts + (int)Math.ceil((double)DarkSteelRecipeManager.getEnchantmentRepairCost(resultStack.func_77946_l()) / 2.0));
        evt.setMaterialCost(ingouts);
    }

    private static void handleUpgrade(AnvilUpdateEvent evt, @Nonnull IDarkSteelItem item) {
        for (IDarkSteelUpgrade upgrade : UpgradeRegistry.getUpgrades()) {
            if (!upgrade.isUpgradeItem(evt.getRight()) || !upgrade.canAddToItem(evt.getLeft(), item)) continue;
            ItemStack res = new ItemStack(evt.getLeft().func_77973_b(), 1, evt.getLeft().func_77952_i());
            NBTTagCompound tagCompound = evt.getLeft().func_77978_p();
            if (tagCompound != null) {
                res.func_77982_d(tagCompound.func_74737_b());
            }
            upgrade.addToItem(res, item);
            evt.setOutput(res);
            evt.setCost(upgrade.getLevelCost());
            return;
        }
    }

    private static int getEnchantmentRepairCost(@Nonnull ItemStack itemStack) {
        int res = 0;
        Map map1 = EnchantmentHelper.func_82781_a((ItemStack)itemStack);
        Iterator iter = map1.keySet().iterator();
        while (iter.hasNext()) {
            Enchantment i1;
            Enchantment enchantment = i1 = (Enchantment)iter.next();
            int level = (Integer)map1.get(enchantment);
            if (!enchantment.func_92089_a(itemStack)) continue;
            if (level > enchantment.func_77325_b()) {
                level = enchantment.func_77325_b();
            }
            int costPerLevel = 0;
            switch (enchantment.func_77324_c()) {
                case VERY_RARE: {
                    costPerLevel = 8;
                    break;
                }
                case RARE: {
                    costPerLevel = 4;
                    break;
                }
                case UNCOMMON: {
                    costPerLevel = 2;
                    break;
                }
                case COMMON: {
                    costPerLevel = 1;
                }
            }
            res += costPerLevel * level;
        }
        return res;
    }

    public static void addCommonTooltipEntries(@Nonnull ItemStack itemstack, EntityPlayer entityplayer, @Nonnull List<String> list, boolean flag) {
        SpecialTooltipHandler.addCommonTooltipFromResources(list, (String)itemstack.func_77977_a());
        if (itemstack.func_77973_b() instanceof IDarkSteelItem) {
            for (IDarkSteelUpgrade upgrade : UpgradeRegistry.getUpgrades()) {
                if (!(upgrade instanceof IAdvancedTooltipProvider) || !upgrade.hasUpgrade(itemstack, (IDarkSteelItem)itemstack.func_77973_b())) continue;
                ((IAdvancedTooltipProvider)upgrade).addCommonEntries(itemstack, entityplayer, list, flag);
            }
        }
    }

    public static void addBasicTooltipEntries(@Nonnull ItemStack itemstack, EntityPlayer entityplayer, @Nonnull List<String> list, boolean flag) {
        SpecialTooltipHandler.addBasicTooltipFromResources(list, (String)itemstack.func_77977_a());
        if (itemstack.func_77973_b() instanceof IDarkSteelItem) {
            for (IDarkSteelUpgrade upgrade : UpgradeRegistry.getUpgrades()) {
                if (!(upgrade instanceof IAdvancedTooltipProvider) || !upgrade.hasUpgrade(itemstack, (IDarkSteelItem)itemstack.func_77973_b())) continue;
                ((IAdvancedTooltipProvider)upgrade).addBasicEntries(itemstack, entityplayer, list, flag);
            }
        }
    }

    public static void setSkipUpgradeTooltips(boolean skipUpgradeTooltips) {
        DarkSteelRecipeManager.skipUpgradeTooltips = skipUpgradeTooltips;
    }

    public static void addAdvancedTooltipEntries(@Nonnull ItemStack itemstack, EntityPlayer entityplayer, @Nonnull List<String> list, boolean flag) {
        SpecialTooltipHandler.addDetailedTooltipFromResources(list, (String)itemstack.func_77977_a());
        if (itemstack.func_77973_b() instanceof IDarkSteelItem && !skipUpgradeTooltips) {
            ArrayList<IDarkSteelUpgrade> applyableUpgrades = new ArrayList<IDarkSteelUpgrade>();
            for (IDarkSteelUpgrade upgrade : UpgradeRegistry.getUpgrades()) {
                if (upgrade instanceof IAdvancedTooltipProvider && upgrade.hasUpgrade(itemstack, (IDarkSteelItem)itemstack.func_77973_b())) {
                    ((IAdvancedTooltipProvider)upgrade).addDetailedEntries(itemstack, entityplayer, list, flag);
                    continue;
                }
                if (!upgrade.canAddToItem(itemstack, (IDarkSteelItem)itemstack.func_77973_b())) continue;
                applyableUpgrades.add(upgrade);
            }
            if (!applyableUpgrades.isEmpty()) {
                list.add(TextFormatting.YELLOW + EnderIO.lang.localize("tooltip.anvilupgrades") + " ");
                for (IDarkSteelUpgrade up : applyableUpgrades) {
                    list.add(Lang.DARK_STEEL_LEVELS1.get(TextFormatting.DARK_AQUA, EnderIO.lang.localizeExact(up.getUnlocalizedName() + ".name")));
                    list.add(Lang.DARK_STEEL_LEVELS2.get(TextFormatting.DARK_AQUA, TextFormatting.ITALIC, up.getUpgradeItemName(), up.getLevelCost()));
                }
            }
        }
    }

    @Nonnull
    public static Iterator<IDarkSteelUpgrade> recipeIterator() {
        return ImmutableList.copyOf(UpgradeRegistry.getUpgrades()).iterator();
    }

    @Nonnull
    public static String getUpgradesAsString(@Nonnull ItemStack stack) {
        return (String)NullHelper.first((Object[])new String[]{UpgradeRegistry.getUpgrades().stream().filter(upgrade -> upgrade.hasUpgrade(stack)).map(upgrade -> "" + UpgradeRegistry.getId(upgrade)).collect(Collectors.joining("/")), ""});
    }

    public static NNList<ItemStack> getRecipes(@Nonnull Set<UpgradePath> list, @Nonnull NNList<ItemStack> input) {
        NNList output = new NNList();
        for (ItemStack inputStack : input) {
            if (!(inputStack.func_77973_b() instanceof IDarkSteelItem)) continue;
            for (IDarkSteelUpgrade upgrade : UpgradeRegistry.getUpgrades()) {
                if (!upgrade.canAddToItem(inputStack, (IDarkSteelItem)inputStack.func_77973_b())) continue;
                ItemStack outputStack = inputStack.func_77946_l();
                upgrade.addToItem(outputStack, (IDarkSteelItem)outputStack.func_77973_b());
                UpgradePath path = new UpgradePath(upgrade, inputStack, upgrade.getUpgradeItem(), outputStack);
                if (list.contains(path)) continue;
                list.add(path);
                output.add((Object)outputStack);
            }
        }
        return output;
    }

    @Nonnull
    public static NNList<UpgradePath> getAllRecipes(@Nonnull NNList<ItemStack> validItems) {
        HashSet<UpgradePath> list = new HashSet<UpgradePath>();
        NNList<ItemStack> items = DarkSteelRecipeManager.getRecipes(list, validItems);
        while (!items.isEmpty()) {
            items = DarkSteelRecipeManager.getRecipes(list, items);
        }
        return new NNList(list);
    }

    public static class UpgradePath {
        @Nonnull
        private final ItemStack input;
        @Nonnull
        private final ItemStack upgrade;
        @Nonnull
        private final ItemStack output;
        @Nonnull
        private final IDarkSteelUpgrade dsupgrade;
        @Nonnull
        private final String id;

        UpgradePath(@Nonnull IDarkSteelUpgrade dsupgrade, @Nonnull ItemStack input, @Nonnull ItemStack upgrade, @Nonnull ItemStack output) {
            this.input = input;
            this.upgrade = upgrade;
            this.output = output;
            this.dsupgrade = dsupgrade;
            this.id = StringUtil.format("%s:%s:%s", input.func_77973_b().getRegistryName(), DarkSteelRecipeManager.getUpgradesAsString(input), DarkSteelRecipeManager.getUpgradesAsString(output));
        }

        @Nonnull
        public ItemStack getInput() {
            return this.input;
        }

        @Nonnull
        public ItemStack getUpgrade() {
            return this.upgrade;
        }

        @Nonnull
        public ItemStack getOutput() {
            return this.output;
        }

        @Nonnull
        public IDarkSteelUpgrade getDsupgrade() {
            return this.dsupgrade;
        }

        public int hashCode() {
            return this.id.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            UpgradePath other = (UpgradePath)obj;
            return this.id.equals(other.id);
        }
    }
}

