/*
 * Decompiled with CFR 0.152.
 */
package p455w0rd.ae2wtlib.client.gui;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.awt.Color;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.client.config.GuiUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.vector.Vector2f;
import p455w0rd.ae2wtlib.api.ICustomWirelessTerminalItem;
import p455w0rd.ae2wtlib.api.WTApi;
import p455w0rd.ae2wtlib.client.gui.GuiMenuButton;
import p455w0rd.ae2wtlib.items.ItemWUT;

public class GuiWUTTermSelection
extends GuiScreen {
    private final ResourceLocation[] textures;
    private int timeIn = 0;
    private int slotSelected = -1;
    private final ItemStack wut;
    final List<Pair<ItemStack, Integer>> installedTerminals;

    public GuiWUTTermSelection(ItemStack stack) {
        this.field_146297_k = Minecraft.func_71410_x();
        this.wut = stack;
        this.installedTerminals = ItemWUT.getStoredTerminalStacks(this.getTerminal());
        this.textures = WTApi.instance().getWUTUtility().getMenuIcons(stack);
    }

    private int getSegments() {
        return this.textures.length;
    }

    public ItemStack getTerminal() {
        return this.wut;
    }

    public void func_73866_w_() {
        ItemStack selectedTerminal = (ItemStack)ItemWUT.getSelectedTerminalStack(this.getTerminal()).getLeft();
        for (int i = 0; i < this.installedTerminals.size(); ++i) {
            this.func_189646_b(new GuiMenuButton((Integer)this.installedTerminals.get(i).getRight(), this, selectedTerminal.func_82833_r()));
        }
        this.updateButtons(this.getTerminal());
    }

    private void updateButtons(ItemStack tool) {
        int x = 0;
        for (int i = 0; i < this.field_146292_n.size(); ++i) {
            GuiMenuButton button = (GuiMenuButton)((Object)this.field_146292_n.get(i));
            if (!button.field_146125_m) continue;
            int len = this.field_146297_k.field_71466_p.func_78256_a(button.field_146126_j) + 6;
            x += len + 10;
            button.field_146120_f = len;
            button.field_146121_g = this.field_146297_k.field_71466_p.field_78288_b + 3;
            button.field_146129_i = this.field_146295_m / 2 - 110;
        }
        x = this.field_146294_l / 2 - (x - 10) / 2;
        for (GuiMenuButton button : this.field_146292_n) {
            if (!button.field_146125_m) continue;
            button.field_146128_h = x;
            x += button.field_146120_f + 10;
        }
    }

    public void func_73863_a(int mx, int my, float partialTicks) {
        ItemStack hoveredStack = ItemStack.field_190927_a;
        float stime = 5.0f;
        float fract = Math.min(5.0f, (float)this.timeIn + partialTicks) / 5.0f;
        int x = this.field_146294_l / 2;
        int y = this.field_146295_m / 2;
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)((1.0f - fract) * (float)x), (float)((1.0f - fract) * (float)y), (float)0.0f);
        GlStateManager.func_179152_a((float)fract, (float)fract, (float)fract);
        super.func_73863_a(mx, my, partialTicks);
        GlStateManager.func_179121_F();
        if (this.getSegments() == 0) {
            return;
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179090_x();
        int maxRadius = 80;
        float angle = GuiWUTTermSelection.mouseAngle(x, y, mx, my);
        int highlight = 5;
        GlStateManager.func_179147_l();
        GlStateManager.func_179103_j((int)7425);
        float totalDeg = 0.0f;
        float degPer = 360.0f / (float)this.getSegments();
        ArrayList<int[]> stringPositions = new ArrayList<int[]>();
        ItemStack tool = this.wut;
        if (tool.func_190926_b()) {
            return;
        }
        this.slotSelected = -1;
        float offset = 8.5f;
        double dist = new Vec3d((double)x, (double)y, 0.0).func_72438_d(new Vec3d((double)mx, (double)my, 0.0));
        boolean inRange = dist > 35.0 && dist < 81.0;
        int modeIndex = (Integer)ItemWUT.getSelectedTerminalStack(tool).getRight();
        ResourceLocation[] signs = this.textures;
        for (int seg = 0; seg < this.getSegments(); ++seg) {
            boolean mouseInSector = inRange && angle > totalDeg && angle < totalDeg + degPer;
            float radius = Math.max(0.0f, Math.min(((float)this.timeIn + partialTicks - (float)seg * 6.0f / (float)this.getSegments()) * 40.0f, 80.0f));
            GL11.glBegin((int)5);
            float gs = 0.25f;
            if (seg % 2 == 0) {
                gs += 0.1f;
            }
            float r = gs;
            float b = gs + (seg == modeIndex ? 0.85f : 0.0f);
            float g = gs + (seg == modeIndex ? 0.5f : 0.0f);
            Color c = Color.decode(((ICustomWirelessTerminalItem)((ItemStack)this.installedTerminals.get(modeIndex).getLeft()).func_77973_b()).getColor() + "");
            if (seg == modeIndex) {
                r = (float)c.getRed() / 255.0f;
                g = (float)c.getGreen() / 255.0f;
                b = (float)c.getBlue() / 255.0f;
            }
            float a = 0.4f;
            if (mouseInSector) {
                hoveredStack = (ItemStack)this.installedTerminals.get(seg).getLeft();
                if (seg != modeIndex) {
                    if (Mouse.isButtonDown((int)0)) {
                        ((GuiMenuButton)((Object)this.field_146292_n.get(seg))).click();
                    }
                    this.slotSelected = seg;
                    c = Color.decode(((ICustomWirelessTerminalItem)hoveredStack.func_77973_b()).getColor() + "");
                    r = (float)c.getRed() / 255.0f;
                    g = (float)c.getGreen() / 255.0f;
                    b = (float)c.getBlue() / 255.0f;
                }
            }
            GlStateManager.func_179131_c((float)r, (float)g, (float)b, (float)0.4f);
            for (float i = degPer; i >= 0.0f; i -= 1.0f) {
                float rad = (float)((double)((i + totalDeg) / 180.0f) * Math.PI);
                double xp = (double)x + Math.cos(rad) * (double)radius;
                double yp = (double)y + Math.sin(rad) * (double)radius;
                if ((int)i == (int)(degPer / 2.0f)) {
                    stringPositions.add(new int[]{(int)xp, (int)yp, mouseInSector ? 110 : 114});
                }
                GL11.glVertex2d((double)((double)x + Math.cos(rad) * (double)radius / (double)2.3f), (double)((double)y + Math.sin(rad) * (double)radius / (double)2.3f));
                GL11.glVertex2d((double)xp, (double)yp);
            }
            totalDeg += degPer;
            GL11.glEnd();
            if (!mouseInSector) continue;
            radius -= 5.0f;
        }
        GlStateManager.func_179103_j((int)7424);
        GlStateManager.func_179098_w();
        for (int i = 0; i < stringPositions.size(); ++i) {
            int[] pos = (int[])stringPositions.get(i);
            int xp = pos[0];
            int yp = pos[1];
            char c = (char)pos[2];
            String name = "x";
            int xsp = xp - 4;
            int ysp = yp;
            int width = this.field_146289_q.func_78256_a("x");
            double mod = 0.6;
            int xdp = (int)((double)(xp - x) * mod + (double)x);
            int ydp = (int)((double)(yp - y) * mod + (double)y);
            if (xsp < x) {
                xsp -= width - 8;
            }
            if (ysp < y) {
                ysp -= 9;
            }
            this.field_146289_q.func_175063_a("", (float)xsp, (float)ysp, i == modeIndex ? Color.GREEN.getRGB() : Color.WHITE.getRGB());
            mod = 0.7;
            xdp = (int)((double)(xp - x) * mod + (double)x) - 7;
            ydp = (int)((double)(yp - y) * mod + (double)y) - 10;
            this.field_146297_k.field_71446_o.func_110577_a(signs[i]);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GuiWUTTermSelection.func_146110_a((int)(xdp - 8), (int)(ydp - 8), (float)0.0f, (float)0.0f, (int)32, (int)32, (float)32.0f, (float)32.0f);
        }
        GlStateManager.func_179091_B();
        GlStateManager.func_179147_l();
        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
        RenderHelper.func_74520_c();
        float s = 3.0f * fract;
        GlStateManager.func_179152_a((float)s, (float)s, (float)s);
        GlStateManager.func_179109_b((float)((float)x / s - 8.5f), (float)((float)y / s - 8.0f), (float)0.0f);
        this.field_146297_k.func_175599_af().func_180450_b(tool, 0, 0);
        RenderHelper.func_74518_a();
        GlStateManager.func_179084_k();
        GlStateManager.func_179101_C();
        GlStateManager.func_179121_F();
        if (!hoveredStack.func_190926_b()) {
            this.drawHoveringText(hoveredStack.func_82833_r(), mx, my, ((ICustomWirelessTerminalItem)hoveredStack.func_77973_b()).getColor());
        }
    }

    public void drawHoveringText(String text, int mouseX, int mouseY, int color) {
        if (text != null && !text.isEmpty()) {
            int screenWidth = this.field_146294_l;
            int screenHeight = this.field_146295_m;
            int maxTextWidth = -1;
            ArrayList<String> textList = Lists.newArrayList((Object[])text.split("\n"));
            FontRenderer font = this.field_146297_k.field_71466_p;
            GlStateManager.func_179101_C();
            RenderHelper.func_74518_a();
            GlStateManager.func_179140_f();
            GlStateManager.func_179097_i();
            int tooltipTextWidth = 0;
            for (String textItem : textList) {
                int textLineWidth = font.func_78256_a(textItem);
                if (textLineWidth <= tooltipTextWidth) continue;
                tooltipTextWidth = textLineWidth;
            }
            boolean needsWrap = false;
            int titleLinesCount = 1;
            int tooltipX = mouseX + 12;
            if (tooltipX + tooltipTextWidth + 4 > screenWidth && (tooltipX = mouseX - 16 - tooltipTextWidth) < 4) {
                tooltipTextWidth = mouseX > screenWidth / 2 ? mouseX - 12 - 8 : screenWidth - 16 - mouseX;
                needsWrap = true;
            }
            if (needsWrap) {
                int wrappedTooltipWidth = 0;
                ArrayList<String> wrappedTextLines = new ArrayList<String>();
                for (int i = 0; i < textList.size(); ++i) {
                    String textLine = (String)textList.get(i);
                    List wrappedLine = font.func_78271_c(textLine, tooltipTextWidth);
                    if (i == 0) {
                        titleLinesCount = wrappedLine.size();
                    }
                    for (String line : wrappedLine) {
                        int lineWidth = font.func_78256_a(line);
                        if (lineWidth > wrappedTooltipWidth) {
                            wrappedTooltipWidth = lineWidth;
                        }
                        wrappedTextLines.add(line);
                    }
                }
                tooltipTextWidth = wrappedTooltipWidth;
                textList = wrappedTextLines;
                tooltipX = mouseX > screenWidth / 2 ? mouseX - 16 - tooltipTextWidth : mouseX + 12;
            }
            int tooltipY = mouseY - 12;
            int tooltipHeight = 8;
            if (textList.size() > 1) {
                tooltipHeight += (textList.size() - 1) * 10;
                if (textList.size() > titleLinesCount) {
                    tooltipHeight += 2;
                }
            }
            if (tooltipY < 4) {
                tooltipY = 4;
            } else if (tooltipY + tooltipHeight + 4 > screenHeight) {
                tooltipY = screenHeight - tooltipHeight - 4;
            }
            int zLevel = 300;
            int backgroundColor = -267386864;
            int borderColorStart = color;
            int borderColorEnd = (borderColorStart & 0xFEFEFE) >> 1 | borderColorStart & 0xFF000000;
            GuiUtils.drawGradientRect((int)300, (int)(tooltipX - 3), (int)(tooltipY - 4), (int)(tooltipX + tooltipTextWidth + 3), (int)(tooltipY - 3), (int)-267386864, (int)-267386864);
            GuiUtils.drawGradientRect((int)300, (int)(tooltipX - 3), (int)(tooltipY + tooltipHeight + 3), (int)(tooltipX + tooltipTextWidth + 3), (int)(tooltipY + tooltipHeight + 4), (int)-267386864, (int)-267386864);
            GuiUtils.drawGradientRect((int)300, (int)(tooltipX - 3), (int)(tooltipY - 3), (int)(tooltipX + tooltipTextWidth + 3), (int)(tooltipY + tooltipHeight + 3), (int)-267386864, (int)-267386864);
            GuiUtils.drawGradientRect((int)300, (int)(tooltipX - 4), (int)(tooltipY - 3), (int)(tooltipX - 3), (int)(tooltipY + tooltipHeight + 3), (int)-267386864, (int)-267386864);
            GuiUtils.drawGradientRect((int)300, (int)(tooltipX + tooltipTextWidth + 3), (int)(tooltipY - 3), (int)(tooltipX + tooltipTextWidth + 4), (int)(tooltipY + tooltipHeight + 3), (int)-267386864, (int)-267386864);
            GuiUtils.drawGradientRect((int)300, (int)(tooltipX - 3), (int)(tooltipY - 3 + 1), (int)(tooltipX - 3 + 1), (int)(tooltipY + tooltipHeight + 3 - 1), (int)borderColorStart, (int)borderColorEnd);
            GuiUtils.drawGradientRect((int)300, (int)(tooltipX + tooltipTextWidth + 2), (int)(tooltipY - 3 + 1), (int)(tooltipX + tooltipTextWidth + 3), (int)(tooltipY + tooltipHeight + 3 - 1), (int)borderColorStart, (int)borderColorEnd);
            GuiUtils.drawGradientRect((int)300, (int)(tooltipX - 3), (int)(tooltipY - 3), (int)(tooltipX + tooltipTextWidth + 3), (int)(tooltipY - 3 + 1), (int)borderColorStart, (int)borderColorStart);
            GuiUtils.drawGradientRect((int)300, (int)(tooltipX - 3), (int)(tooltipY + tooltipHeight + 2), (int)(tooltipX + tooltipTextWidth + 3), (int)(tooltipY + tooltipHeight + 3), (int)borderColorEnd, (int)borderColorEnd);
            int tooltipTop = tooltipY;
            for (int lineNumber = 0; lineNumber < textList.size(); ++lineNumber) {
                String line = (String)textList.get(lineNumber);
                font.func_175063_a(line, (float)tooltipX, (float)tooltipY, -1);
                if (lineNumber + 1 == titleLinesCount) {
                    tooltipY += 2;
                }
                tooltipY += 10;
            }
            GlStateManager.func_179145_e();
            GlStateManager.func_179126_j();
            RenderHelper.func_74519_b();
            GlStateManager.func_179091_B();
        }
    }

    private void changeMode() {
        if (this.slotSelected >= 0) {
            // empty if block
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        this.changeMode();
    }

    public void func_73876_c() {
        ImmutableSet set = ImmutableSet.of((Object)this.field_146297_k.field_71474_y.field_74351_w, (Object)this.field_146297_k.field_71474_y.field_74370_x, (Object)this.field_146297_k.field_71474_y.field_74368_y, (Object)this.field_146297_k.field_71474_y.field_74366_z, (Object)this.field_146297_k.field_71474_y.field_74311_E, (Object)this.field_146297_k.field_71474_y.field_151444_V, (Object[])new KeyBinding[]{this.field_146297_k.field_71474_y.field_74314_A});
        for (KeyBinding k : set) {
            KeyBinding.func_74510_a((int)k.func_151463_i(), (boolean)GameSettings.func_100015_a((KeyBinding)k));
        }
        ++this.timeIn;
        ItemStack tool = this.wut;
        boolean curent = true;
        boolean changed = false;
    }

    public boolean func_73868_f() {
        return false;
    }

    private static float mouseAngle(int x, int y, int mx, int my) {
        Vector2f baseVec = new Vector2f(1.0f, 0.0f);
        Vector2f mouseVec = new Vector2f((float)(mx - x), (float)(my - y));
        float ang = (float)(Math.acos(Vector2f.dot((Vector2f)baseVec, (Vector2f)mouseVec) / (baseVec.length() * mouseVec.length())) * 57.29577951308232);
        return my < y ? 360.0f - ang : ang;
    }
}

