/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.platforms;

import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistry;
import shetiphian.platforms.Configuration;
import shetiphian.platforms.Registry;
import shetiphian.platforms.Values;
import shetiphian.platforms.client.render.RenderRegistry;
import shetiphian.platforms.common.misc.ProxyCommon;
import shetiphian.platforms.common.network.NetworkHandler;
import shetiphian.platforms.modintegration.ModIntegration;

@Mod(modid="platforms", name="Platforms", version="1.4.6", dependencies="required-after:shetiphiancore@[v3.5.0,)", updateJSON="https://gist.githubusercontent.com/ShetiPhian/5a4332ca6221ae61ab3c6d531a989f21/raw/Platforms", acceptedMinecraftVersions="[1.12]")
@Mod.EventBusSubscriber
public class Platforms {
    @SidedProxy(clientSide="shetiphian.platforms.client.misc.ProxyClient", serverSide="shetiphian.platforms.common.misc.ProxyCommon")
    public static ProxyCommon proxy;
    @Mod.Instance(value="platforms")
    public static Platforms INSTANCE;
    public static final String MOD_ID = "platforms";

    @SubscribeEvent
    public static void registerBlocks(RegistryEvent.Register<Block> event) {
        Registry.INSTANCE.registerBlocks((IForgeRegistry<Block>)event.getRegistry());
    }

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        Registry.INSTANCE.registerItemBlocks((IForgeRegistry<Item>)event.getRegistry());
        Registry.INSTANCE.registerItems((IForgeRegistry<Item>)event.getRegistry());
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public static void registerModels(ModelRegistryEvent event) throws Exception {
        RenderRegistry.renderingPreInt();
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        Values.logPlatforms = event.getModLog();
        proxy.renderingPreInt();
    }

    @Mod.EventHandler
    public void load(FMLInitializationEvent event) {
        Registry.INSTANCE.doRegistration();
        NetworkHandler.initialise();
        proxy.renderingInt();
        proxy.registerEventHandlers();
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)this, (IGuiHandler)proxy);
        new ModIntegration().load();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        Configuration.EventHandler.process();
    }

    public static void errorPropertyNotFound(String property, String returning, String state) {
        Values.logPlatforms.error("PropertyEnum '" + property + "' not found in provided BlockState, returning '" + returning + "'. Provided BlockState: " + state);
    }

    public static ItemStack getCustomItemStack(String name, int ... amount) {
        return Values.stacks.get(name, amount);
    }
}

