/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.proxy;

import com.ldtteam.blockout.Screen;
import com.ldtteam.structures.client.BlueprintBlockInfoTransformHandler;
import com.ldtteam.structures.event.RenderEventHandler;
import com.ldtteam.structures.helpers.Settings;
import com.ldtteam.structurize.api.util.Log;
import com.ldtteam.structurize.blocks.ModBlocks;
import com.ldtteam.structurize.blocks.cactus.BlockCactusDoor;
import com.ldtteam.structurize.blocks.decorative.BlockPaperwall;
import com.ldtteam.structurize.blocks.decorative.BlockTimberFrame;
import com.ldtteam.structurize.blocks.types.PaperwallType;
import com.ldtteam.structurize.client.gui.WindowBuildTool;
import com.ldtteam.structurize.client.gui.WindowMultiBlock;
import com.ldtteam.structurize.client.gui.WindowScan;
import com.ldtteam.structurize.client.gui.WindowShapeTool;
import com.ldtteam.structurize.event.ClientEventHandler;
import com.ldtteam.structurize.items.ModItems;
import com.ldtteam.structurize.management.Manager;
import com.ldtteam.structurize.proxy.CommonProxy;
import com.ldtteam.structurize.util.BlockInfo;
import java.io.File;
import net.minecraft.block.Block;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.properties.IProperty;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.stats.RecipeBook;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Mod.EventBusSubscriber(value={Side.CLIENT})
public class ClientProxy
extends CommonProxy {
    private static final String INVENTORY = "inventory";

    @Override
    public boolean isClient() {
        return true;
    }

    @Override
    public void registerEvents() {
        super.registerEvents();
        MinecraftForge.EVENT_BUS.register((Object)new RenderEventHandler());
        MinecraftForge.EVENT_BUS.register((Object)new ClientEventHandler());
    }

    @Override
    public void openBuildToolWindow(@Nullable BlockPos pos) {
        if (pos == null && Settings.instance.getActiveStructure() == null) {
            return;
        }
        if (Minecraft.func_71410_x().field_71462_r instanceof Screen) {
            return;
        }
        WindowBuildTool window = new WindowBuildTool(pos);
        window.open();
    }

    @Override
    public void openShapeToolWindow(@Nullable BlockPos pos) {
        if (pos == null && Settings.instance.getActiveStructure() == null) {
            return;
        }
        WindowShapeTool window = new WindowShapeTool(pos);
        window.open();
    }

    @Override
    public void openScanToolWindow(@Nullable BlockPos pos1, @Nullable BlockPos pos2) {
        if (pos1 == null || pos2 == null) {
            return;
        }
        WindowScan window = new WindowScan(pos1, pos2);
        window.open();
    }

    @Override
    public void openBuildToolWindow(BlockPos pos, String structureName, int rotation) {
        if (pos == null && Settings.instance.getActiveStructure() == null) {
            return;
        }
        if (Minecraft.func_71410_x().field_71462_r instanceof Screen) {
            return;
        }
        WindowBuildTool window = new WindowBuildTool(pos, structureName, rotation, null);
        window.open();
    }

    private static void createCustomModel(Block block) {
        Item item = Item.func_150898_a((Block)block);
        if (item != null) {
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation(block.getRegistryName(), INVENTORY));
        }
    }

    private static void createCustomModel(Item item) {
        if (item != null) {
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation(item.getRegistryName(), INVENTORY));
        }
    }

    @SubscribeEvent
    public static void registerModels(@NotNull ModelRegistryEvent event) {
        ClientProxy.createCustomModel(ModBlocks.blockSubstitution);
        ClientProxy.createCustomModel(ModBlocks.blockSolidSubstitution);
        ClientProxy.createCustomModel(ModItems.buildTool);
        ClientProxy.createCustomModel(ModItems.shapeTool);
        ClientProxy.createCustomModel(ModItems.caliper);
        ClientProxy.createCustomModel(ModItems.scanTool);
        ClientProxy.createCustomModel(ModBlocks.blockCactusPlank);
        ClientProxy.createCustomModel((Block)ModBlocks.blockCactusTrapdoor);
        ClientProxy.createCustomModel((Block)ModBlocks.blockCactusStair);
        ClientProxy.createCustomModel((Block)ModBlocks.blockCactusSlabHalf);
        ClientProxy.createCustomModel((Block)ModBlocks.blockCactusSlabDouble);
        ClientProxy.createCustomModel(ModItems.itemCactusDoor);
        ClientProxy.createCustomModel((Block)ModBlocks.blockCactusFence);
        ClientProxy.createCustomModel((Block)ModBlocks.blockCactusFenceGate);
        ClientProxy.createCustomModel((Block)ModBlocks.blockShingleSlab);
        ModelLoader.setCustomStateMapper((Block)ModBlocks.blockCactusDoor, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BlockCactusDoor.field_176522_N}).func_178441_a());
        ModelLoader.setCustomStateMapper((Block)ModBlocks.blockPaperWall, (IStateMapper)new StateMap.Builder().func_178440_a(BlockPaperwall.VARIANT).func_178439_a("_blockPaperwall").func_178441_a());
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)ModBlocks.blockShingleOak), (int)0, (ModelResourceLocation)new ModelResourceLocation(new ResourceLocation("structurize", "blockshingle_" + BlockPlanks.EnumType.OAK.func_176610_l()), INVENTORY));
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)ModBlocks.blockShingleBirch), (int)0, (ModelResourceLocation)new ModelResourceLocation(new ResourceLocation("structurize", "blockshingle_" + BlockPlanks.EnumType.BIRCH.func_176610_l()), INVENTORY));
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)ModBlocks.blockShingleSpruce), (int)0, (ModelResourceLocation)new ModelResourceLocation(new ResourceLocation("structurize", "blockshingle_" + BlockPlanks.EnumType.SPRUCE.func_176610_l()), INVENTORY));
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)ModBlocks.blockShingleJungle), (int)0, (ModelResourceLocation)new ModelResourceLocation(new ResourceLocation("structurize", "blockshingle_" + BlockPlanks.EnumType.JUNGLE.func_176610_l()), INVENTORY));
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)ModBlocks.blockShingleDarkOak), (int)0, (ModelResourceLocation)new ModelResourceLocation(new ResourceLocation("structurize", "blockshingle_" + BlockPlanks.EnumType.DARK_OAK.func_176610_l()), INVENTORY));
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)ModBlocks.blockShingleAcacia), (int)0, (ModelResourceLocation)new ModelResourceLocation(new ResourceLocation("structurize", "blockshingle_" + BlockPlanks.EnumType.ACACIA.func_176610_l()), INVENTORY));
        for (PaperwallType type : PaperwallType.values()) {
            ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)ModBlocks.blockPaperWall), (int)type.getMetadata(), (ModelResourceLocation)new ModelResourceLocation(ModBlocks.blockPaperWall.getRegistryName() + "_" + type.func_176610_l(), INVENTORY));
        }
        for (BlockTimberFrame frame : ModBlocks.getTimberFrames()) {
            ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)frame), (int)0, (ModelResourceLocation)new ModelResourceLocation(frame.getRegistryName(), INVENTORY));
        }
        ClientProxy.createCustomModel(ModBlocks.multiBlock);
        BlueprintBlockInfoTransformHandler.getInstance().AddTransformHandler(b -> b.getState().func_177230_c() == ModBlocks.blockSubstitution, b -> new BlockInfo(b.getPos(), Blocks.field_150350_a.func_176223_P(), null));
        BlueprintBlockInfoTransformHandler.getInstance().AddTransformHandler(b -> b.getState().func_177230_c() == ModBlocks.blockSolidSubstitution, b -> new BlockInfo(b.getPos(), Blocks.field_150350_a.func_176223_P(), null));
    }

    @Override
    public File getSchematicsFolder() {
        if (FMLCommonHandler.instance().getMinecraftServerInstance() == null) {
            if (Manager.getServerUUID() != null) {
                return new File(Minecraft.func_71410_x().field_71412_D, "structurize/" + Manager.getServerUUID());
            }
            Log.getLogger().error("Manager.getServerUUID() => null this should not happen");
            return null;
        }
        File worldSchematicFolder = new File(FMLCommonHandler.instance().getMinecraftServerInstance().func_71238_n() + "/" + "structurize" + '/' + "schematics");
        if (!worldSchematicFolder.exists()) {
            return new File(Minecraft.func_71410_x().field_71412_D, "structurize");
        }
        return worldSchematicFolder.getParentFile();
    }

    @Override
    @Nullable
    public World getWorldFromMessage(@NotNull MessageContext context) {
        return context.getClientHandler().field_147300_g;
    }

    @Override
    @Nullable
    public World getWorld(int dimension) {
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER) {
            return super.getWorld(dimension);
        }
        return Minecraft.func_71410_x().field_71441_e;
    }

    @Override
    @NotNull
    public RecipeBook getRecipeBookFromPlayer(@NotNull EntityPlayer player) {
        if (player instanceof EntityPlayerSP) {
            return ((EntityPlayerSP)player).func_192035_E();
        }
        return super.getRecipeBookFromPlayer(player);
    }

    @Override
    public void openMultiBlockWindow(@Nullable BlockPos pos) {
        WindowMultiBlock window = new WindowMultiBlock(pos);
        window.open();
    }
}

