/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.util;

import net.minecraft.util.math.Vec3d;
import thebetweenlands.util.CatmullRomSpline;
import thebetweenlands.util.ISpline;

public class ReparameterizedSpline
implements ISpline {
    private final ISpline spline;
    private double length;
    private CatmullRomSpline reparameterizedInterpol;
    private double[] segmentLengths;
    private int segmentSubdivs;
    private double epsilon = 0.001;
    private int maxNewtonIter = 16;

    public ReparameterizedSpline(ISpline spline) {
        this.spline = spline;
    }

    public ReparameterizedSpline init(int subdivs, int segmentSubdivs, double epsilon, int maxNewtonIter) {
        this.init(subdivs, segmentSubdivs);
        this.epsilon = epsilon;
        this.maxNewtonIter = maxNewtonIter;
        return this;
    }

    public ReparameterizedSpline init(int subdivs, int segmentSubdivs) {
        this.segmentSubdivs = segmentSubdivs;
        this.segmentLengths = new double[this.spline.getNumSegments() + 1];
        this.segmentLengths[0] = 0.0;
        double segmentDelta = 1.0 / (double)this.spline.getNumSegments();
        for (int i = 1; i <= this.spline.getNumSegments(); ++i) {
            this.segmentLengths[i] = this.segmentLengths[i - 1] + this.getArcLength(segmentDelta * (double)(i - 1), segmentDelta * (double)i, subdivs);
        }
        this.length = this.segmentLengths[this.spline.getNumSegments()];
        Vec3d[] arcLengths = new Vec3d[subdivs + 2];
        double delta = this.length / (double)(subdivs - 1);
        for (int i = 0; i < subdivs; ++i) {
            arcLengths[i + 1] = new Vec3d(this.getCurveParameter(delta * (double)i), 0.0, 0.0);
        }
        Vec3d vec3d = new Vec3d(0.0, 0.0, (double)1.0E-6f);
        arcLengths[subdivs + 1] = vec3d;
        arcLengths[0] = vec3d;
        this.reparameterizedInterpol = new CatmullRomSpline(arcLengths);
        return this;
    }

    @Override
    public Vec3d interpolate(float t) {
        return this.spline.interpolate(this.getInterpolatedCurveParameter((double)t * this.length));
    }

    @Override
    public Vec3d derivative(float t) {
        return this.spline.derivative(this.getInterpolatedCurveParameter((double)t * this.length));
    }

    @Override
    public Vec3d[] getNodes() {
        return this.spline.getNodes();
    }

    @Override
    public int getNumSegments() {
        return this.spline.getNumSegments();
    }

    private float getInterpolatedCurveParameter(double s) {
        float parameter = s <= 0.0 ? 0.0f : (s >= this.length ? 1.0f : (float)this.reparameterizedInterpol.interpolate((float)((float)(s / this.length))).field_72450_a);
        return parameter;
    }

    private double getArcLength(double start, double end, int subdivs) {
        double sum = 0.0;
        double delta = (end - start) / (double)subdivs;
        Vec3d prev = null;
        for (int i = 0; i <= subdivs; ++i) {
            Vec3d interp = this.spline.interpolate((float)(start + (double)i * delta));
            if (prev != null) {
                sum += prev.func_178788_d(interp).func_72433_c();
            }
            prev = interp;
        }
        return sum;
    }

    private double speed(double t) {
        return this.spline.derivative((float)t).func_72433_c();
    }

    private double getCurveParameter(double s) {
        int segment;
        if (s <= 0.0) {
            return 0.0;
        }
        if (s >= this.length) {
            return 1.0;
        }
        for (segment = 1; segment < this.spline.getNumSegments() && !(s <= this.segmentLengths[segment]); ++segment) {
        }
        double segmentDelta = 1.0 / (double)this.spline.getNumSegments();
        double t = (s - this.segmentLengths[segment - 1]) / this.length;
        double segmentT = segmentDelta * (double)(segment - 1);
        double lower = 0.0;
        double upper = segmentDelta;
        for (int i = 0; i < this.maxNewtonIter; ++i) {
            double error = this.segmentLengths[segment - 1] + this.getArcLength(segmentT, segmentT + t, this.segmentSubdivs) - s;
            if (Math.abs(error) < this.epsilon) {
                return segmentT + t;
            }
            double tCandidate = t - error / this.speed(segmentT + t);
            if (error > 0.0) {
                upper = t;
                if (tCandidate <= lower) {
                    t = 0.5 * (upper + lower);
                    continue;
                }
                t = tCandidate;
                continue;
            }
            lower = t;
            t = tCandidate >= upper ? 0.5 * (upper + lower) : tCandidate;
        }
        return segmentT + t;
    }

    @Override
    public boolean hasArcLength() {
        return true;
    }

    @Override
    public double getArcLength() {
        return this.length;
    }
}

