/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.world.storage;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityDispatcher;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.api.event.AttachLocalStorageCapabilitiesEvent;
import thebetweenlands.api.storage.IChunkStorage;
import thebetweenlands.api.storage.ILocalStorage;
import thebetweenlands.api.storage.IWorldStorage;
import thebetweenlands.api.storage.LocalRegion;
import thebetweenlands.api.storage.LocalStorageReference;
import thebetweenlands.api.storage.StorageID;
import thebetweenlands.common.TheBetweenlands;
import thebetweenlands.common.network.clientbound.MessageAddLocalStorage;
import thebetweenlands.common.network.clientbound.MessageRemoveLocalStorage;

public abstract class LocalStorageImpl
implements ILocalStorage {
    private final IWorldStorage worldStorage;
    private final LocalRegion region;
    private final StorageID id;
    private CapabilityDispatcher capabilities;
    private boolean dirty;
    private final List<ChunkPos> linkedChunks = new ArrayList<ChunkPos>();
    private final List<LocalStorageReference> loadedReferences = new ArrayList<LocalStorageReference>();
    private final List<EntityPlayerMP> watchers = new ArrayList<EntityPlayerMP>();
    private final List<EntityPlayerMP> duplicateWatchers = new ArrayList<EntityPlayerMP>();
    private boolean loaded = false;

    public LocalStorageImpl(IWorldStorage worldStorage, StorageID id, @Nullable LocalRegion region) {
        this.worldStorage = worldStorage;
        this.id = id;
        this.region = region;
        AttachLocalStorageCapabilitiesEvent event = new AttachLocalStorageCapabilitiesEvent(this);
        MinecraftForge.EVENT_BUS.post((Event)event);
        this.capabilities = event.getCapabilities().size() > 0 ? new CapabilityDispatcher(event.getCapabilities(), null) : null;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return this.capabilities == null ? false : this.capabilities.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        return (T)(this.capabilities == null ? null : this.capabilities.getCapability(capability, facing));
    }

    @Override
    public IWorldStorage getWorldStorage() {
        return this.worldStorage;
    }

    @Override
    public StorageID getID() {
        return this.id;
    }

    @Override
    public LocalRegion getRegion() {
        return this.region;
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        if (this.capabilities != null && nbt.func_74764_b("ForgeCaps")) {
            this.capabilities.deserializeNBT(nbt.func_74775_l("ForgeCaps"));
        }
        this.readReferenceChunks(nbt);
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        NBTTagCompound caps;
        if (this.capabilities != null && (caps = this.capabilities.serializeNBT()).func_186856_d() > 0) {
            nbt.func_74782_a("ForgeCaps", (NBTBase)caps);
        }
        this.writeReferenceChunks(nbt);
        return nbt;
    }

    @Override
    public void readInitialPacket(NBTTagCompound nbt) {
        this.readReferenceChunks(nbt);
    }

    @Override
    public NBTTagCompound writeInitialPacket(NBTTagCompound nbt) {
        this.writeReferenceChunks(nbt);
        return nbt;
    }

    protected final void writeReferenceChunks(NBTTagCompound nbt) {
        NBTTagList referenceChunkList = new NBTTagList();
        for (ChunkPos referenceChunk : this.linkedChunks) {
            NBTTagCompound referenceChunkNbt = new NBTTagCompound();
            referenceChunkNbt.func_74768_a("x", referenceChunk.field_77276_a);
            referenceChunkNbt.func_74768_a("z", referenceChunk.field_77275_b);
            referenceChunkList.func_74742_a((NBTBase)referenceChunkNbt);
        }
        nbt.func_74782_a("ReferenceChunks", (NBTBase)referenceChunkList);
    }

    protected final void readReferenceChunks(NBTTagCompound nbt) {
        this.linkedChunks.clear();
        NBTTagList referenceChunkList = nbt.func_150295_c("ReferenceChunks", 10);
        for (int i = 0; i < referenceChunkList.func_74745_c(); ++i) {
            NBTTagCompound referenceChunkNbt = referenceChunkList.func_150305_b(i);
            this.linkedChunks.add(new ChunkPos(referenceChunkNbt.func_74762_e("x"), referenceChunkNbt.func_74762_e("z")));
        }
    }

    @Override
    public void markDirty() {
        this.setDirty(true);
    }

    @Override
    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    @Override
    public boolean isDirty() {
        return this.dirty;
    }

    @Override
    public List<ChunkPos> getLinkedChunks() {
        return Collections.unmodifiableList(this.linkedChunks);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void setLinkedChunks(List<ChunkPos> linkedChunks) {
        this.linkedChunks.clear();
        this.linkedChunks.addAll(linkedChunks);
    }

    @Override
    public void onLoaded() {
        this.loaded = true;
    }

    @Override
    public void onUnloaded() {
        this.loaded = false;
    }

    @Override
    public void onRemoved() {
        if (!this.getWorldStorage().getWorld().field_72995_K && !this.getWatchers().isEmpty()) {
            this.sendMessageToAllWatchers(new MessageRemoveLocalStorage(this.getID()));
        }
    }

    @Override
    public Collection<LocalStorageReference> getLoadedReferences() {
        return Collections.unmodifiableCollection(this.loadedReferences);
    }

    @Override
    public boolean loadReference(LocalStorageReference reference) {
        if (!this.loadedReferences.contains(reference)) {
            return this.loadedReferences.add(reference);
        }
        return false;
    }

    @Override
    public boolean unloadReference(LocalStorageReference reference) {
        return this.loadedReferences.remove(reference);
    }

    @Override
    public boolean addWatcher(IChunkStorage chunkStorage, EntityPlayerMP player) {
        boolean contained = this.duplicateWatchers.contains(player);
        this.duplicateWatchers.add(player);
        if (!contained) {
            this.watchers.add(player);
            this.onWatched(player);
        }
        return !contained;
    }

    protected void onWatched(EntityPlayerMP player) {
        this.sendDataToPlayer(new MessageAddLocalStorage(this), player);
    }

    @Override
    public boolean removeWatcher(IChunkStorage chunkStorage, EntityPlayerMP player) {
        boolean contained = this.duplicateWatchers.remove(player);
        if (contained && !this.duplicateWatchers.contains(player)) {
            this.watchers.remove(player);
            this.onUnwatched(player);
        }
        return contained;
    }

    protected void onUnwatched(EntityPlayerMP player) {
    }

    @Override
    public Collection<EntityPlayerMP> getWatchers() {
        return Collections.unmodifiableCollection(this.watchers);
    }

    @Override
    public boolean unlinkAllChunks() {
        boolean changed = false;
        boolean allUnlinked = true;
        ArrayList<ChunkPos> chunks = new ArrayList<ChunkPos>(this.linkedChunks.size());
        chunks.addAll(this.linkedChunks);
        Iterator it = chunks.iterator();
        ChunkPos pos = null;
        while (it.hasNext()) {
            pos = (ChunkPos)it.next();
            Chunk chunk = this.worldStorage.getWorld().func_72964_e(pos.field_77276_a, pos.field_77275_b);
            IChunkStorage chunkData = this.worldStorage.getChunkStorage(chunk);
            if (chunkData == null || !chunkData.unlinkLocalStorage(this)) {
                allUnlinked = false;
                continue;
            }
            if (chunkData == null) continue;
            changed = true;
        }
        if (changed) {
            this.setDirty(true);
        }
        this.linkedChunks.clear();
        return allUnlinked;
    }

    @Override
    public boolean linkChunk(Chunk chunk) {
        IChunkStorage chunkData;
        ChunkPos chunkPos = new ChunkPos(chunk.field_76635_g, chunk.field_76647_h);
        if (!this.linkedChunks.contains(chunkPos) && (chunkData = this.worldStorage.getChunkStorage(chunk)) != null && chunkData.linkLocalStorage(this) && this.linkedChunks.add(chunkPos)) {
            this.setDirty(true);
            return true;
        }
        return false;
    }

    @Override
    public boolean unlinkChunk(Chunk chunk) {
        IChunkStorage chunkData;
        ChunkPos chunkPos = new ChunkPos(chunk.field_76635_g, chunk.field_76647_h);
        if (this.linkedChunks.contains(chunkPos) && (chunkData = this.worldStorage.getChunkStorage(chunk)) != null) {
            chunkData.unlinkLocalStorage(this);
            if (this.linkedChunks.remove(chunkPos)) {
                this.setDirty(true);
                return true;
            }
        }
        return false;
    }

    protected void sendMessageToAllWatchers(IMessage message) {
        for (EntityPlayerMP watcher : this.getWatchers()) {
            this.sendDataToPlayer(message, watcher);
        }
    }

    protected void sendDataToPlayer(IMessage message, EntityPlayerMP player) {
        TheBetweenlands.networkWrapper.sendTo(message, player);
    }

    @Override
    public boolean isLoaded() {
        return this.loaded;
    }
}

