/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.tile;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootTable;
import thebetweenlands.api.loot.ISharedLootContainer;
import thebetweenlands.api.loot.ISharedLootPool;
import thebetweenlands.common.TheBetweenlands;
import thebetweenlands.common.tile.TileEntityBasicInventory;
import thebetweenlands.common.world.storage.location.LocationStorage;

public abstract class TileEntityLootInventory
extends TileEntityBasicInventory
implements ISharedLootContainer {
    protected ResourceLocation lootTable;
    protected long lootTableSeed;
    protected long sharedLootTableSeed;
    protected boolean isSharedLootTable;

    public TileEntityLootInventory(int invtSize, String name) {
        super(invtSize, name);
    }

    @Override
    public boolean fillInventoryWithLoot(@Nullable EntityPlayer player) {
        return TileEntityLootInventory.fillInventoryWithLoot(this, player, this.lootTableSeed);
    }

    public static boolean fillInventoryWithLoot(ISharedLootContainer inventory, @Nullable EntityPlayer player, long seed) {
        TileEntity tile;
        ResourceLocation lootTableLocation = inventory.func_184276_b();
        if (lootTableLocation != null && inventory instanceof TileEntity && (tile = (TileEntity)inventory).func_145831_w() instanceof WorldServer) {
            LootTable lootTable = null;
            if (inventory.isSharedLootTable()) {
                List<LocationStorage> locations = LocationStorage.getLocations(tile.func_145831_w(), new AxisAlignedBB(tile.func_174877_v()));
                for (LocationStorage location : locations) {
                    ISharedLootPool sharedLootPool = location.getOrCreateSharedLootPool(lootTableLocation);
                    if (sharedLootPool == null) continue;
                    lootTable = sharedLootPool.getLootTableView();
                    break;
                }
            } else {
                lootTable = tile.func_145831_w().func_184146_ak().func_186521_a(lootTableLocation);
            }
            if (lootTable != null) {
                inventory.removeLootTable();
                Random random = seed == 0L ? new Random() : new Random(seed);
                LootContext.Builder lootBuilder = new LootContext.Builder((WorldServer)tile.func_145831_w());
                if (player != null) {
                    lootBuilder.func_186469_a(player.func_184817_da());
                }
                List loot = lootTable.func_186462_a(random, lootBuilder.func_186471_a());
                TileEntityLootInventory.fillInventoryRandomly(random, loot, inventory);
                return true;
            }
        }
        return false;
    }

    public static boolean fillInventoryRandomly(Random random, List<ItemStack> loot, IInventory itemHandler) {
        ArrayList emptySlots = Lists.newArrayList();
        for (int i = 0; i < itemHandler.func_70302_i_(); ++i) {
            if (!itemHandler.func_70301_a(i).func_190926_b()) continue;
            emptySlots.add(i);
        }
        Collections.shuffle(emptySlots, random);
        ArrayList splittableStacks = Lists.newArrayList();
        Iterator<ItemStack> iterator = loot.iterator();
        while (iterator.hasNext()) {
            ItemStack itemstack = iterator.next();
            if (itemstack.func_190916_E() <= 0) {
                iterator.remove();
                continue;
            }
            if (itemstack.func_190916_E() <= 1) continue;
            splittableStacks.add(itemstack);
            iterator.remove();
        }
        int emptySlotCount = emptySlots.size();
        emptySlotCount = emptySlotCount - loot.size() - splittableStacks.size();
        while (emptySlotCount > 0 && splittableStacks.size() > 0) {
            ItemStack itemstack2 = (ItemStack)splittableStacks.remove(MathHelper.func_76136_a((Random)random, (int)0, (int)(splittableStacks.size() - 1)));
            int i = MathHelper.func_76136_a((Random)random, (int)1, (int)(itemstack2.func_190916_E() / 2));
            itemstack2.func_190918_g(i);
            ItemStack itemstack1 = itemstack2.func_77946_l();
            itemstack1.func_190920_e(i);
            if (--emptySlotCount > 0 && itemstack2.func_190916_E() > 1 && random.nextBoolean()) {
                splittableStacks.add(itemstack2);
            } else {
                loot.add(itemstack2);
            }
            if (emptySlotCount > 0 && itemstack1.func_190916_E() > 1 && random.nextBoolean()) {
                splittableStacks.add(itemstack1);
                continue;
            }
            loot.add(itemstack1);
        }
        loot.addAll(splittableStacks);
        Collections.shuffle(loot, random);
        for (ItemStack itemstack : loot) {
            if (!itemstack.func_190926_b() && emptySlots.isEmpty()) {
                TheBetweenlands.logger.info("Tried to over-fill a container");
                return false;
            }
            if (itemstack.func_190926_b()) {
                itemHandler.func_70299_a(((Integer)emptySlots.remove(emptySlots.size() - 1)).intValue(), ItemStack.field_190927_a);
                continue;
            }
            itemHandler.func_70299_a(((Integer)emptySlots.remove(emptySlots.size() - 1)).intValue(), itemstack);
        }
        return true;
    }

    public void setLootTable(@Nullable ResourceLocation lootTable, long lootTableSeed) {
        this.lootTable = lootTable;
        this.lootTableSeed = lootTableSeed;
        this.isSharedLootTable = false;
        this.func_70296_d();
    }

    public void setSharedLootTable(ResourceLocation lootTable, long lootTableSeed) {
        this.lootTable = lootTable;
        this.lootTableSeed = lootTableSeed;
        this.isSharedLootTable = true;
        this.func_70296_d();
    }

    @Override
    public void removeLootTable() {
        if (this.lootTable != null) {
            this.lootTable = null;
            this.func_70296_d();
        }
    }

    public ResourceLocation func_184276_b() {
        return this.lootTable;
    }

    @Override
    protected void writeInventoryNBT(NBTTagCompound nbt) {
        if (!this.checkLootAndWrite(nbt)) {
            super.writeInventoryNBT(nbt);
        }
    }

    @Override
    protected void readInventoryNBT(NBTTagCompound nbt) {
        if (!this.checkLootAndRead(nbt)) {
            super.readInventoryNBT(nbt);
        }
    }

    protected boolean checkLootAndRead(NBTTagCompound compound) {
        if (compound.func_150297_b("LootTable", 8)) {
            this.lootTable = new ResourceLocation(compound.func_74779_i("LootTable"));
            this.lootTableSeed = compound.func_74763_f("LootTableSeed");
            this.isSharedLootTable = compound.func_74767_n("SharedLootTable");
            return true;
        }
        return false;
    }

    protected boolean checkLootAndWrite(NBTTagCompound compound) {
        if (this.lootTable != null) {
            compound.func_74778_a("LootTable", this.lootTable.toString());
            if (this.lootTableSeed != 0L) {
                compound.func_74772_a("LootTableSeed", this.lootTableSeed);
            }
            compound.func_74757_a("SharedLootTable", this.isSharedLootTable);
            return true;
        }
        return false;
    }

    @Override
    protected void accessSlot(int slot) {
        if (TileEntityLootInventory.fillInventoryWithLoot(this, null, this.lootTableSeed)) {
            this.func_70296_d();
        }
    }

    @Override
    public void func_174888_l() {
        if (TileEntityLootInventory.fillInventoryWithLoot(this, null, this.lootTableSeed)) {
            this.func_70296_d();
        }
        super.func_174888_l();
    }

    @Override
    public boolean isSharedLootTable() {
        return this.isSharedLootTable;
    }
}

