/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.entity.mobs;

import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIPanic;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.api.entity.IEntityBL;
import thebetweenlands.client.render.particle.BLParticles;
import thebetweenlands.client.render.particle.ParticleFactory;
import thebetweenlands.common.entity.ai.EntityAIFollowTarget;
import thebetweenlands.common.entity.ai.EntityAIJumpRandomly;
import thebetweenlands.common.entity.mobs.EntitySporeling;
import thebetweenlands.common.registries.LootTableRegistry;
import thebetweenlands.common.registries.SoundRegistry;

public class EntityRootSprite
extends EntityCreature
implements IEntityBL {
    private static final byte EVENT_STEP = 40;
    private float jumpHeightOverride = -1.0f;

    public EntityRootSprite(World worldIn) {
        super(worldIn);
        this.field_70728_aV = 1;
        this.func_70105_a(0.3f, 0.55f);
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIPanic((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)this, EntityPlayer.class, 5.0f, 0.5, 1.0));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIFollowTarget((EntityLiving)this, new EntityAIFollowTarget.FollowClosest((EntityLiving)this, EntitySporeling.class, 10.0), 0.65, 0.5f, 10.0f, false));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIJumpRandomly((EntityLiving)this, 10, () -> !this.field_70170_p.func_72872_a(EntitySporeling.class, this.func_174813_aQ().func_186662_g(1.0)).isEmpty()){

            @Override
            public void func_75249_e() {
                EntityRootSprite.this.setJumpHeightOverride(0.2f);
                EntityRootSprite.this.func_70683_ar().func_75660_a();
            }
        });
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 0.6));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntitySporeling.class, 8.0f));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 10.0f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(5.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.5);
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundRegistry.ROOT_SPRITE_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return SoundRegistry.ROOT_SPRITE_DEATH;
    }

    protected SoundEvent func_184639_G() {
        return SoundRegistry.ROOT_SPRITE_LIVING;
    }

    protected float func_70599_aP() {
        return 0.5f;
    }

    public int func_70627_aG() {
        return 100;
    }

    public void setJumpHeightOverride(float jumpHeightOverride) {
        this.jumpHeightOverride = jumpHeightOverride;
    }

    protected float func_175134_bD() {
        if (this.jumpHeightOverride > 0.0f) {
            float height = this.jumpHeightOverride;
            this.jumpHeightOverride = -1.0f;
            return height;
        }
        return super.func_175134_bD();
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K && this.field_70146_Z.nextInt(20) == 0) {
            this.spawnLeafParticles();
        }
    }

    protected ResourceLocation func_184647_J() {
        return LootTableRegistry.ROOT_SPRITE;
    }

    protected void func_180429_a(BlockPos pos, Block blockIn) {
        super.func_180429_a(pos, blockIn);
        this.field_82151_R += 0.7f;
        this.field_70170_p.func_72960_a((Entity)this, (byte)40);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte id) {
        super.func_70103_a(id);
        if (id == 40) {
            this.spawnLeafParticles();
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void spawnLeafParticles() {
        for (int i = 0; i < 1 + this.field_70146_Z.nextInt(3); ++i) {
            BLParticles.WEEDWOOD_LEAF.spawn(this.field_70170_p, this.field_70165_t + this.field_70159_w, this.field_70163_u + (double)0.1f + (double)(this.field_70146_Z.nextFloat() * 0.3f), this.field_70161_v + this.field_70179_y, (ParticleFactory.ParticleArgs<?>)((ParticleFactory.ParticleArgs)ParticleFactory.ParticleArgs.get().withMotion(this.field_70159_w * 0.5 + (double)(this.field_70146_Z.nextFloat() * 0.1f) - (double)0.05f, 0.05f, this.field_70179_y * 0.5 + (double)(this.field_70146_Z.nextFloat() * 0.1f) - (double)0.05f)).withScale(0.5f));
        }
    }
}

