/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.entity.mobs;

import com.google.common.collect.ImmutableMap;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemPickaxe;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.api.entity.IEntityBL;
import thebetweenlands.api.entity.IEntityCustomBlockCollisions;
import thebetweenlands.api.entity.IEntityWithLootModifier;
import thebetweenlands.client.render.model.SpikeRenderer;
import thebetweenlands.client.render.model.entity.ModelBoulderSprite;
import thebetweenlands.common.handler.CustomEntityBlockCollisionsHandler;
import thebetweenlands.common.registries.AdvancementCriterionRegistry;
import thebetweenlands.common.registries.BlockRegistry;
import thebetweenlands.common.registries.LootTableRegistry;
import thebetweenlands.common.registries.SoundRegistry;
import thebetweenlands.common.world.gen.biome.decorator.SurfaceType;

public class EntityBoulderSprite
extends EntityMob
implements IEntityCustomBlockCollisions,
IEntityAdditionalSpawnData,
IEntityWithLootModifier,
IEntityBL {
    public static final byte EVENT_STEP = 40;
    protected static final UUID ROLLING_ATTACK_MODIFIER_ATTRIBUTE_UUID = UUID.fromString("6c403225-c522-4d69-aa2c-e7c67463a8c7");
    protected static final DataParameter<Float> ROLL_SPEED = EntityDataManager.func_187226_a(EntityBoulderSprite.class, (DataSerializer)DataSerializers.field_187193_c);
    protected EnumFacing hideoutEntrance = null;
    protected BlockPos hideout = null;
    protected boolean isAiHiding = false;
    private float prevRollAnimationInAirWeight = 0.0f;
    private float prevRollAnimation = 0.0f;
    private float prevRollAnimationWeight = 0.0f;
    private float rollAnimationInAirWeight = 0.0f;
    private float rollAnimationSpeed = 0.0f;
    private float rollAnimation = 0.0f;
    private float rollAnimationWeight = 0.0f;
    protected boolean rollSoundPlayed = false;
    protected double rollingSpeed = 0.0;
    protected int rollingTicks = 0;
    protected int rollingAccelerationTime = 0;
    protected int rollingDecelerationTime = 0;
    protected int rollingDuration = 0;
    protected Vec3d rollingDir = null;
    protected long stalactitesSeed = 0L;
    protected int numStalactites = 0;
    protected int[] stalactiteHeights;
    @Nullable
    @SideOnly(value=Side.CLIENT)
    public List<SpikeRenderer> stalactites;

    public EntityBoulderSprite(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.9f, 1.2f);
        this.setStalactitesSeed(worldIn.field_73012_v.nextLong());
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(ROLL_SPEED, (Object)Float.valueOf(0.0f));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(50.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.2);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(28.0);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(4.0);
    }

    protected void func_184651_r() {
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAINearestAttackableTarget<EntityPlayer>((EntityCreature)this, EntityPlayer.class, false){

            public double func_111175_f() {
                return 12.0;
            }
        });
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[0]){

            public void func_75249_e() {
                if (EntityBoulderSprite.this.func_70638_az() != EntityBoulderSprite.this.func_70643_av()) {
                    EntityBoulderSprite.this.setHideout(null);
                }
                super.func_75249_e();
            }
        });
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new AIRollTowardsTargetFromHideout(this, 8, 1.2));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new AIMoveToHideout(this, 1.5));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new AIHide(this, 0.8));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new AIFindRandomHideoutFlee(this, 8));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new AIRollTowardsTarget(this));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, true){

            public boolean func_75250_a() {
                return !EntityBoulderSprite.this.isHiddenOrInWall() && super.func_75250_a();
            }

            public boolean func_75253_b() {
                return !EntityBoulderSprite.this.isHiddenOrInWall() && super.func_75253_b();
            }
        });
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.9));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new AIFindRandomHideout(this, 8, 10));
    }

    protected void setStalactitesSeed(long seed) {
        this.stalactitesSeed = seed;
        Random seededRng = new Random();
        seededRng.setSeed(this.stalactitesSeed);
        this.numStalactites = seededRng.nextInt(2) == 0 ? 2 + seededRng.nextInt(5) : 0;
        this.stalactiteHeights = new int[this.numStalactites];
        for (int i = 0; i < this.numStalactites; ++i) {
            this.stalactiteHeights[i] = 1 + seededRng.nextInt(3);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void initStalactiteModels() {
        if (this.stalactites == null) {
            this.stalactites = new ArrayList<SpikeRenderer>();
            Random seededRng = new Random();
            seededRng.setSeed(this.stalactitesSeed);
            if (this.numStalactites > 0) {
                TextureMap altas = Minecraft.func_71410_x().func_147117_R();
                for (int i = 0; i < this.numStalactites; ++i) {
                    Vec3d offset = new Vec3d(-0.08 + seededRng.nextDouble() * 0.5 - 0.25, 0.5, -0.15 + seededRng.nextDouble() * 0.5 - 0.25);
                    float scale = (0.2f + seededRng.nextFloat() * 0.4f) * 0.6f;
                    SpikeRenderer renderer = new SpikeRenderer(this.stalactiteHeights[i], scale, scale, scale, seededRng.nextLong(), offset.field_72450_a, offset.field_72448_b, offset.field_72449_c).build(DefaultVertexFormats.field_181703_c, altas.func_110572_b(ModelBoulderSprite.StalactitesModelRenderer.SPRITE_BOTTOM.toString()), altas.func_110572_b(ModelBoulderSprite.StalactitesModelRenderer.SPRITE_MID.toString()));
                    this.stalactites.add(renderer);
                }
            }
        }
    }

    public void writeSpawnData(ByteBuf buffer) {
        buffer.writeLong(this.stalactitesSeed);
    }

    public void readSpawnData(ByteBuf buffer) {
        this.setStalactitesSeed(buffer.readLong());
    }

    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        if (this.hideout != null) {
            nbt.func_74772_a("hideout", this.hideout.func_177986_g());
        }
        if (this.hideoutEntrance != null) {
            nbt.func_74778_a("hideoutEntrance", this.hideoutEntrance.func_176610_l());
        }
        nbt.func_74780_a("rollingSpeed", this.rollingSpeed);
        nbt.func_74768_a("rollingTicks", this.rollingTicks);
        nbt.func_74768_a("rollingAccelerationTime", this.rollingAccelerationTime);
        nbt.func_74768_a("rollingDecelerationTime", this.rollingDecelerationTime);
        nbt.func_74768_a("rollingDuration", this.rollingDuration);
        if (this.rollingDir != null) {
            nbt.func_74780_a("rollingDirX", this.rollingDir.field_72450_a);
            nbt.func_74780_a("rollingDirY", this.rollingDir.field_72448_b);
            nbt.func_74780_a("rollingDirZ", this.rollingDir.field_72449_c);
        }
        nbt.func_74772_a("stalactitesSeed", this.stalactitesSeed);
    }

    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        if (nbt.func_150297_b("hideout", 4)) {
            this.hideout = BlockPos.func_177969_a((long)nbt.func_74763_f("hideout"));
        }
        if (nbt.func_150297_b("hideoutEntrance", 8)) {
            this.hideoutEntrance = EnumFacing.func_176739_a((String)nbt.func_74779_i("hideoutEntrance"));
        }
        this.rollingSpeed = nbt.func_74769_h("rollingSpeed");
        this.rollingTicks = nbt.func_74762_e("rollingTicks");
        this.rollingAccelerationTime = nbt.func_74762_e("rollingAccelerationTime");
        this.rollingDecelerationTime = nbt.func_74762_e("rollingDecelerationTime");
        this.rollingDuration = nbt.func_74762_e("rollingDuration");
        if (nbt.func_150297_b("rollingDirX", 6) && nbt.func_150297_b("rollingDirY", 6) && nbt.func_150297_b("rollingDirZ", 6)) {
            this.rollingDir = new Vec3d(nbt.func_74769_h("rollingDirX"), nbt.func_74769_h("rollingDirY"), nbt.func_74769_h("rollingDirZ"));
        }
        this.setStalactitesSeed(nbt.func_74763_f("stalactitesSeed"));
    }

    protected SoundEvent func_184639_G() {
        if (!this.isHiddenOrInWall()) {
            return SoundRegistry.BOULDER_SPRITE_LIVING;
        }
        return null;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundRegistry.BOULDER_SPRITE_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return SoundRegistry.BOULDER_SPRITE_DEATH;
    }

    protected void playRollSound() {
        this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, (SoundEvent)SoundRegistry.BOULDER_SPRITE_ROLL, SoundCategory.HOSTILE, this.func_70599_aP(), this.func_70647_i());
    }

    protected void func_180429_a(BlockPos pos, Block blockIn) {
        float distanceWalked = this.field_82151_R;
        if (!this.isRolling()) {
            distanceWalked = this.isHiddenOrInWall() ? this.field_82151_R + 0.9f : this.field_82151_R + 0.5f;
            this.func_184185_a(SoundEvents.field_187843_fX, 0.6f, 1.0f);
        } else {
            distanceWalked = this.field_82151_R + 0.7f;
            this.func_184185_a(SoundEvents.field_187843_fX, 0.35f, 1.0f);
            this.func_184185_a(SoundEvents.field_187581_bW, 0.08f, 1.0f);
        }
        this.field_82151_R = distanceWalked;
        this.field_70170_p.func_72960_a((Entity)this, (byte)40);
    }

    public void func_70103_a(byte id) {
        IBlockState state;
        super.func_70103_a(id);
        if (id == 40 && this.isHiddenOrInWall() && !(state = this.field_70170_p.func_180495_p(this.func_180425_c())).func_177230_c().isAir(state, (IBlockAccess)this.field_70170_p, this.func_180425_c())) {
            int stateId = Block.func_176210_f((IBlockState)state);
            for (int i = 0; i < 24; ++i) {
                double dx = this.field_70146_Z.nextDouble() - 0.5;
                double dy = this.field_70146_Z.nextDouble();
                double dz = this.field_70146_Z.nextDouble() - 0.5;
                this.field_70170_p.func_175688_a(EnumParticleTypes.BLOCK_DUST, this.field_70165_t + this.field_70159_w + dx, this.field_70163_u + this.field_70181_x + dy, this.field_70161_v + this.field_70179_y + dz, dx * 0.2, dy * 0.2, dz * 0.2, new int[]{stateId});
            }
        }
    }

    protected ResourceLocation func_184647_J() {
        return LootTableRegistry.BOULDER_SPRITE;
    }

    @Override
    public Map<String, Float> getLootModifiers(LootContext context, boolean isEntityProperty) {
        int stalactiteBlocks = this.stalactiteHeights != null ? IntStream.of(this.stalactiteHeights).sum() : 0;
        return ImmutableMap.builder().put((Object)"stalactites", (Object)Float.valueOf(this.numStalactites)).put((Object)"stalactite_blocks", (Object)Float.valueOf(stalactiteBlocks)).build();
    }

    public void func_70653_a(Entity entityIn, float strength, double xRatio, double zRatio) {
    }

    @SideOnly(value=Side.CLIENT)
    public int func_70070_b() {
        if (this.func_70094_T()) {
            AxisAlignedBB renderAABB = this.func_174813_aQ().func_72314_b(0.1, 0.1, 0.1);
            Iterable it = BlockPos.MutableBlockPos.func_177975_b((BlockPos)new BlockPos(renderAABB.field_72340_a, this.field_70163_u + (double)this.func_70047_e(), renderAABB.field_72339_c), (BlockPos)new BlockPos(renderAABB.field_72336_d, renderAABB.field_72337_e, renderAABB.field_72334_f));
            int brightestBlock = 0;
            int brightestSky = 0;
            for (BlockPos.MutableBlockPos pos : it) {
                int brightness = this.getBrightnessForRenderAt(pos);
                int brightnessBlock = brightness >> 4 & 0xFF;
                int brightnessSky = brightness >> 20 & 0xFF;
                if (brightnessBlock > brightestBlock) {
                    brightestBlock = brightnessBlock;
                }
                if (brightnessSky <= brightestSky) continue;
                brightestSky = brightnessSky;
            }
            return brightestSky << 20 | brightestBlock << 4;
        }
        return super.func_70070_b();
    }

    private int getBrightnessForRenderAt(BlockPos.MutableBlockPos pos) {
        if (this.field_70170_p.func_175667_e((BlockPos)pos)) {
            return this.field_70170_p.func_175626_b((BlockPos)pos, 0);
        }
        return 0;
    }

    public AxisAlignedBB func_70046_E() {
        return this.isRolling() || this.isHiddenOrInWall() ? null : this.func_174813_aQ();
    }

    public AxisAlignedBB func_70114_g(Entity entityIn) {
        return this.isRolling() || this.isHiddenOrInWall() ? null : this.func_174813_aQ();
    }

    @Override
    public void getCustomCollisionBoxes(AxisAlignedBB aabb, List<AxisAlignedBB> collisionBoxes) {
        collisionBoxes.clear();
        final int floor = MathHelper.func_76128_c((double)aabb.field_72338_b) + 1;
        CustomEntityBlockCollisionsHandler.getCollisionBoxes((Entity)this, aabb, CustomEntityBlockCollisionsHandler.EntityCollisionPredicate.ALL, new CustomEntityBlockCollisionsHandler.BlockCollisionPredicate(){

            @Override
            public boolean isColliding(Entity entity, AxisAlignedBB aabb, BlockPos.MutableBlockPos pos, IBlockState state) {
                return !EntityBoulderSprite.this.isHiddenOrInWall() || pos.func_177956_o() < floor || !EntityBoulderSprite.this.isValidHideoutBlock((BlockPos)pos);
            }
        }, collisionBoxes);
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        ItemStack item;
        EntityLivingBase attacker;
        EntityLivingBase entityLivingBase = attacker = source.func_76364_f() instanceof EntityLivingBase ? (EntityLivingBase)source.func_76364_f() : null;
        if (attacker != null && attacker.func_184600_cs() != null && !(item = attacker.func_184586_b(attacker.func_184600_cs())).func_190926_b() && item.func_77973_b() instanceof ItemPickaxe) {
            amount *= 3.0f;
        }
        return super.func_70097_a(source, amount);
    }

    public boolean func_70652_k(Entity entityIn) {
        if (this.isHiddenOrInWall()) {
            return false;
        }
        return super.func_70652_k(entityIn);
    }

    public boolean func_180431_b(DamageSource source) {
        return source == DamageSource.field_76368_d || super.func_180431_b(source);
    }

    public void func_70071_h_() {
        double prevMotionX = this.field_70159_w;
        double prevMotionZ = this.field_70179_y;
        if (this.func_70094_T()) {
            this.func_70105_a(this.field_70130_N, 0.95f);
        } else {
            this.func_70105_a(this.field_70130_N, 1.2f);
        }
        this.field_70138_W = this.isRolling() ? 1.1f : 0.6f;
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K) {
            if (this.getHideout() != null && !this.isValidHideoutBlock(this.getHideout())) {
                this.setHideout(null);
            }
            if (this.func_70689_ay() > 0.3f && this.field_191988_bg != 0.0f) {
                this.field_70180_af.func_187227_b(ROLL_SPEED, (Object)Float.valueOf(0.05f + (this.func_70689_ay() - 0.3f) / 3.0f));
                if (!this.rollSoundPlayed) {
                    this.playRollSound();
                }
                this.rollSoundPlayed = true;
            } else {
                this.field_70180_af.func_187227_b(ROLL_SPEED, (Object)Float.valueOf(0.0f));
                this.rollSoundPlayed = false;
            }
            IAttributeInstance attackAttribute = this.func_110148_a(SharedMonsterAttributes.field_111264_e);
            if (this.isRolling()) {
                if (this.field_70123_F) {
                    boolean pg = this.field_70122_E;
                    double pmx = this.field_70159_w;
                    double pmy = this.field_70181_x;
                    double pmz = this.field_70179_y;
                    double px = this.field_70165_t;
                    double py = this.field_70163_u;
                    double pz = this.field_70161_v;
                    this.func_70091_d(MoverType.SELF, MathHelper.func_151237_a((double)prevMotionX, (double)-4.0, (double)4.0), 0.0, 0.0);
                    boolean cx = Math.abs(this.field_70165_t - px) < Math.abs(MathHelper.func_151237_a((double)prevMotionX, (double)-4.0, (double)4.0)) / 2.0;
                    this.field_70122_E = pg;
                    this.field_70159_w = pmx;
                    this.field_70181_x = pmy;
                    this.field_70179_y = pmz;
                    this.func_70107_b(px, py, pz);
                    this.func_70091_d(MoverType.SELF, 0.0, 0.0, MathHelper.func_151237_a((double)prevMotionZ, (double)-4.0, (double)4.0));
                    boolean cz = Math.abs(this.field_70161_v - pz) < Math.abs(MathHelper.func_151237_a((double)prevMotionZ, (double)-4.0, (double)4.0)) / 2.0;
                    this.field_70122_E = pg;
                    this.field_70159_w = pmx;
                    this.field_70181_x = pmy;
                    this.field_70179_y = pmz;
                    this.func_70107_b(px, py, pz);
                    this.onRollIntoWall(cx, cz, MathHelper.func_151237_a((double)prevMotionX, (double)-4.0, (double)4.0), MathHelper.func_151237_a((double)prevMotionZ, (double)-4.0, (double)4.0));
                }
                attackAttribute.func_188479_b(ROLLING_ATTACK_MODIFIER_ATTRIBUTE_UUID);
                attackAttribute.func_111121_a(new AttributeModifier(ROLLING_ATTACK_MODIFIER_ATTRIBUTE_UUID, "Rolling attack modifier", Math.min(Math.sqrt(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y) * 20.0, 10.0), 0));
                Vec3d motionDir = new Vec3d(this.field_70159_w, 0.0, this.field_70179_y).func_72432_b();
                List collidingEntities = this.field_70170_p.func_175674_a((Entity)this, this.func_174813_aQ().func_72314_b(0.35, 0.0, 0.35), EntitySelectors.func_188442_a((Entity)this));
                for (Entity collidingEntity : collidingEntities) {
                    double dot;
                    if (collidingEntity.field_70172_ad > 0 || !((dot = motionDir.func_72430_b(collidingEntity.func_174791_d().func_178788_d(this.func_174791_d()))) >= -0.5) || !(dot <= Math.sqrt(this.field_70130_N * this.field_70130_N) * 0.5) || !this.func_70652_k(collidingEntity) || !(collidingEntity instanceof EntityLivingBase)) continue;
                    ((EntityLivingBase)collidingEntity).func_70653_a((Entity)this, (float)Math.sqrt(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y) * 3.0f, -this.field_70159_w, -this.field_70179_y);
                    if (!(collidingEntity instanceof EntityPlayerMP)) continue;
                    AdvancementCriterionRegistry.ROLLED_OVER_BY_BOULDER_SPRITE.trigger((EntityPlayerMP)collidingEntity);
                }
            } else {
                attackAttribute.func_188479_b(ROLLING_ATTACK_MODIFIER_ATTRIBUTE_UUID);
            }
            if (this.rollingTicks > 0 && this.rollingDir != null) {
                double speed = this.rollingDuration - this.rollingTicks < this.rollingAccelerationTime ? 0.5 + (this.rollingSpeed - 0.5) / (double)this.rollingAccelerationTime * (double)(this.rollingDuration - this.rollingTicks) : (this.rollingTicks < this.rollingDecelerationTime ? 0.5 + (this.rollingSpeed - 0.5) / (double)this.rollingDecelerationTime * (double)this.rollingTicks : this.rollingSpeed);
                this.func_70605_aq().func_75642_a(this.field_70165_t + this.rollingDir.field_72450_a, this.field_70163_u, this.field_70161_v + this.rollingDir.field_72449_c, speed);
                --this.rollingTicks;
            }
        } else {
            BlockPos posBelow;
            IBlockState stateBelow;
            double particleTiming;
            if (this.func_70089_S() && this.isRolling()) {
                this.setRollSpeed(((Float)this.field_70180_af.func_187225_a(ROLL_SPEED)).floatValue());
            }
            this.updateRollAnimationState();
            if (this.field_70122_E && (double)(this.prevRollAnimation % 1.0f) < (particleTiming = 0.75) && (double)(this.rollAnimation % 1.0f) >= particleTiming && !(stateBelow = this.field_70170_p.func_180495_p(posBelow = this.func_180425_c().func_177977_b())).func_177230_c().isAir(stateBelow, (IBlockAccess)this.field_70170_p, posBelow)) {
                double dz;
                double dx;
                int i;
                int stateId = Block.func_176210_f((IBlockState)stateBelow);
                int betweenstoneId = Block.func_176210_f((IBlockState)BlockRegistry.BETWEENSTONE.func_176223_P());
                for (i = 0; i < 28; ++i) {
                    dx = this.field_70146_Z.nextDouble() - 0.5;
                    dz = this.field_70146_Z.nextDouble() - 0.5;
                    this.field_70170_p.func_175688_a(EnumParticleTypes.BLOCK_DUST, this.field_70165_t + this.field_70159_w + dx, this.field_70163_u - 0.2, this.field_70161_v + this.field_70179_y + dz, dx * 0.3, 0.3, dz * 0.3, new int[]{stateId});
                }
                for (i = 0; i < 12; ++i) {
                    dx = this.field_70146_Z.nextDouble() - 0.5;
                    dz = this.field_70146_Z.nextDouble() - 0.5;
                    this.field_70170_p.func_175688_a(EnumParticleTypes.BLOCK_DUST, this.field_70165_t + this.field_70159_w + dx, this.field_70163_u - 0.2, this.field_70161_v + this.field_70179_y + dz, dx * 0.3, 0.3, dz * 0.3, new int[]{betweenstoneId});
                }
            }
        }
    }

    protected void onRollIntoWall(boolean cx, boolean cz, double mx, double mz) {
        if (this.field_70122_E) {
            if (this.field_70181_x <= 3.0) {
                this.field_70181_x += Math.min(Math.sqrt(mx * mx + mz * mz) * 3.0, (double)0.7f);
                this.field_70133_I = true;
            }
            if (cx && Math.abs(this.field_70159_w) <= 3.0) {
                this.field_70159_w -= mx * 4.0;
                this.field_70133_I = true;
            }
            if (cz && Math.abs(this.field_70179_y) <= 3.0) {
                this.field_70179_y -= mz * 4.0;
                this.field_70133_I = true;
            }
            if (cx) {
                this.bumpWall(EnumFacing.func_176737_a((float)((float)mx), (float)0.0f, (float)0.0f));
            }
            if (cz) {
                this.bumpWall(EnumFacing.func_176737_a((float)0.0f, (float)0.0f, (float)((float)mz)));
            }
        }
        this.stopRolling();
    }

    protected void bumpWall(EnumFacing dir) {
        if (ForgeEventFactory.getMobGriefingEvent((World)this.field_70170_p, (Entity)this)) {
            for (int so = -1; so <= 1; ++so) {
                for (int yo = 0; yo <= 1; ++yo) {
                    BlockPos pos = this.func_180425_c().func_177972_a(dir).func_177982_a(dir.func_82601_c() == 0 ? so : 0, yo, dir.func_82599_e() == 0 ? so : 0);
                    if (!this.field_70170_p.func_175623_d(pos.func_177972_a(dir.func_176734_d()))) continue;
                    IBlockState hitState = this.field_70170_p.func_180495_p(pos);
                    float hardness = hitState.func_185887_b(this.field_70170_p, pos);
                    if (hitState.func_177230_c().isAir(hitState, (IBlockAccess)this.field_70170_p, pos) || !(hardness >= 0.0f) || !(hardness <= 2.5f) || this.field_70146_Z.nextInt(yo + so + 2) != 0 || !hitState.func_177230_c().canEntityDestroy(hitState, (IBlockAccess)this.field_70170_p, pos, (Entity)this) || !ForgeEventFactory.onEntityDestroyBlock((EntityLivingBase)this, (BlockPos)pos, (IBlockState)hitState)) continue;
                    this.field_70170_p.func_175718_b(2001, pos, Block.func_176210_f((IBlockState)hitState));
                    this.field_70170_p.func_175698_g(pos);
                }
            }
        }
    }

    public void startRolling(int duration, int accelerationTime, int decelerationTime, Vec3d dir, double rollingSpeed) {
        this.rollingTicks = duration;
        this.rollingAccelerationTime = accelerationTime;
        this.rollingDecelerationTime = decelerationTime;
        this.rollingDuration = duration;
        this.rollingDir = dir;
        this.rollingSpeed = rollingSpeed + 1.5;
    }

    public int getRollingTicks() {
        return this.rollingTicks;
    }

    public void stopRolling() {
        this.rollingTicks = Math.min(this.rollingDecelerationTime, this.rollingTicks);
    }

    public boolean isRolling() {
        return ((Float)this.field_70180_af.func_187225_a(ROLL_SPEED)).floatValue() > 0.04f;
    }

    public void setRollSpeed(float speed) {
        this.rollAnimationSpeed = speed;
    }

    protected void updateRollAnimationState() {
        this.prevRollAnimationInAirWeight = this.rollAnimationInAirWeight;
        this.prevRollAnimation = this.rollAnimation;
        this.prevRollAnimationWeight = this.rollAnimationWeight;
        if (this.rollAnimationSpeed > 0.0f) {
            this.rollAnimationInAirWeight = !this.field_70122_E ? Math.min(1.0f, this.rollAnimationInAirWeight + 0.2f) : Math.max(0.0f, this.rollAnimationInAirWeight - 0.2f);
            if (this.rollAnimationSpeed < 0.04f) {
                double p = this.rollAnimation % 1.0f;
                double incr = Math.pow((1.0f - this.rollAnimation % 1.0f) * this.rollAnimationSpeed, 0.65);
                this.rollAnimation = (float)((double)this.rollAnimation + incr);
                this.rollAnimationWeight = (float)Math.max(0.0, (double)this.rollAnimationWeight - incr / (double)(1.0f - this.rollAnimation % 1.0f) / 4.0);
                if ((double)(this.rollAnimation % 1.0f) < p) {
                    this.rollAnimation = 0.0f;
                    this.prevRollAnimation = 0.0f;
                    this.rollAnimationWeight = 0.0f;
                    this.prevRollAnimationWeight = 0.0f;
                    this.rollAnimationSpeed = 0.0f;
                    this.rollAnimationInAirWeight = 0.0f;
                }
            } else {
                this.rollAnimation += this.rollAnimationSpeed;
                this.rollAnimationWeight = Math.min(1.0f, this.rollAnimationWeight + 0.1f);
                this.rollAnimationSpeed *= 0.5f;
            }
        }
    }

    public float getRollAnimation(float partialTicks) {
        return this.prevRollAnimation + (this.rollAnimation - this.prevRollAnimation) * partialTicks;
    }

    public float getRollAnimationWeight(float partialTicks) {
        return this.prevRollAnimationWeight + (this.rollAnimationWeight - this.prevRollAnimationWeight) * partialTicks;
    }

    public float getRollAnimationInAirWeight(float partialTicks) {
        return this.prevRollAnimationInAirWeight + (this.rollAnimationInAirWeight - this.prevRollAnimationInAirWeight) * partialTicks;
    }

    public boolean isHiddenOrInWall() {
        return this.isAiHiding || this.func_70094_T();
    }

    public void setHideout(@Nullable BlockPos pos) {
        this.hideout = pos;
    }

    @Nullable
    public BlockPos getHideout() {
        return this.hideout;
    }

    public void setHideoutEntrance(@Nullable EnumFacing entrance) {
        this.hideoutEntrance = entrance;
    }

    @Nullable
    protected EnumFacing getHideoutEntrance() {
        return this.hideoutEntrance;
    }

    protected boolean isValidHideoutBlock(BlockPos pos) {
        return SurfaceType.UNDERGROUND.matches(this.field_70170_p.func_180495_p(pos));
    }

    protected static class AIFindRandomHideoutFlee
    extends AIFindRandomHideout {
        public AIFindRandomHideoutFlee(EntityBoulderSprite entity, int range) {
            super(entity, range, 2);
            this.func_75248_a(16);
        }

        @Override
        public boolean func_75250_a() {
            return this.entity.func_70089_S() && this.entity.func_110143_aJ() <= this.entity.func_110138_aP() / 3.0f && this.entity.func_70681_au().nextInt(this.chance) == 0;
        }
    }

    protected static class AIFindRandomHideout
    extends EntityAIBase {
        protected final EntityBoulderSprite entity;
        protected int chance;
        protected int range;

        public AIFindRandomHideout(EntityBoulderSprite entity, int range, int chance) {
            this.entity = entity;
            this.range = range;
            this.chance = chance;
            this.func_75248_a(19);
        }

        public boolean func_75250_a() {
            return this.entity.func_70089_S() && this.entity.field_70122_E && this.entity.func_70681_au().nextInt(this.chance) == 0;
        }

        public void func_75249_e() {
            BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
            for (int i = 0; i < 32; ++i) {
                pos.func_189532_c(this.entity.field_70165_t + (double)this.entity.func_70681_au().nextInt(this.range * 2) - (double)this.range, this.entity.field_70163_u, this.entity.field_70161_v + (double)this.entity.func_70681_au().nextInt(this.range * 2) - (double)this.range);
                if (!this.entity.isValidHideoutBlock((BlockPos)pos) || this.entity.field_70170_p.func_175623_d(pos.func_177984_a()) && this.entity.func_70681_au().nextInt(10) != 0) continue;
                boolean hasPotentialEntrance = false;
                for (EnumFacing facing : EnumFacing.field_176754_o) {
                    if (!this.entity.field_70170_p.func_175623_d(pos.func_177972_a(facing))) continue;
                    hasPotentialEntrance = true;
                    break;
                }
                if (!hasPotentialEntrance) continue;
                this.entity.setHideout(pos.func_185334_h());
                this.entity.setHideoutEntrance(null);
                break;
            }
        }

        public boolean func_75253_b() {
            return false;
        }
    }

    protected static class AIRollTowardsTargetFromHideout
    extends EntityAIBase {
        protected final EntityBoulderSprite entity;
        protected double rollSpeed;
        protected int chance;
        protected Vec3d rollDir;
        protected boolean finished = false;

        public AIRollTowardsTargetFromHideout(EntityBoulderSprite entity, int chance, double rollSpeed) {
            this.entity = entity;
            this.rollSpeed = rollSpeed;
            this.chance = chance;
            this.func_75248_a(19);
        }

        public boolean func_75250_a() {
            return this.entity.isHiddenOrInWall() && this.entity.func_70089_S() && this.entity.func_70638_az() != null && this.entity.func_70638_az().func_70089_S() && Math.abs(this.entity.field_70163_u - this.entity.func_70638_az().field_70163_u) <= 3.0 && this.entity.func_70681_au().nextInt(this.chance) == 0;
        }

        public void func_75249_e() {
            this.finished = false;
        }

        public void func_75246_d() {
            EntityLivingBase target = this.entity.func_70638_az();
            if (target != null) {
                if (this.entity.getRollingTicks() <= 0) {
                    if (!this.func_75250_a()) {
                        this.finished = true;
                    } else {
                        this.rollDir = new Vec3d(target.field_70165_t - this.entity.field_70165_t, 0.0, target.field_70161_v - this.entity.field_70161_v).func_72432_b();
                        this.entity.startRolling(80, 10, 10, this.rollDir, this.rollSpeed);
                        this.entity.isAiHiding = false;
                        this.entity.setHideout(null);
                    }
                } else if (this.rollDir != null && target != null) {
                    double overshoot = this.rollDir.func_72430_b(new Vec3d(this.entity.field_70165_t - target.field_70165_t, 0.0, this.entity.field_70161_v - target.field_70161_v));
                    if (overshoot >= 2.0) {
                        this.entity.stopRolling();
                    }
                } else {
                    this.entity.stopRolling();
                }
            } else {
                this.entity.stopRolling();
            }
        }

        public boolean func_75253_b() {
            return !this.finished;
        }
    }

    protected static class AIHide
    extends EntityAIBase {
        protected final EntityBoulderSprite entity;
        protected double speed;
        protected BlockPos hideout;
        protected EnumFacing entrance;

        public AIHide(EntityBoulderSprite entity, double speed) {
            this.entity = entity;
            this.speed = speed;
            this.func_75248_a(19);
        }

        public boolean func_75250_a() {
            BlockPos entrance;
            if (this.entity.func_70089_S() && this.entity.getHideout() != null && this.entity.getHideoutEntrance() != null && this.entity.isValidHideoutBlock(this.entity.getHideout()) && (entrance = this.entity.getHideout().func_177972_a(this.entity.getHideoutEntrance())).func_177957_d(this.entity.field_70165_t, this.entity.field_70163_u, this.entity.field_70161_v) <= 0.33) {
                this.hideout = this.entity.getHideout();
                this.entrance = this.entity.getHideoutEntrance();
                return true;
            }
            return false;
        }

        public void func_75246_d() {
            this.entity.isAiHiding = true;
            BlockPos hideoutPos = this.hideout.func_177972_a(this.entrance.func_176734_d());
            double dstSq = hideoutPos.func_177957_d(this.entity.field_70165_t, this.entity.field_70163_u, this.entity.field_70161_v);
            if (dstSq >= 0.5) {
                this.entity.func_70605_aq().func_75642_a((double)hideoutPos.func_177958_n() + 0.5, (double)hideoutPos.func_177956_o(), (double)hideoutPos.func_177952_p() + 0.5, this.speed);
            }
        }

        public void func_75251_c() {
            this.entity.isAiHiding = false;
            this.entity.setHideout(null);
        }

        public boolean func_75253_b() {
            return this.entity.func_70089_S() && this.entity.getHideout() == this.hideout && this.hideout.func_177956_o() >= MathHelper.func_76128_c((double)this.entity.field_70163_u) && this.entity.isValidHideoutBlock(this.hideout);
        }
    }

    protected static class AIMoveToHideout
    extends EntityAIBase {
        protected final EntityBoulderSprite entity;
        protected double speed;
        protected List<EnumFacing> potentialEntrances = new ArrayList<EnumFacing>();
        protected BlockPos targetHideout;
        protected EnumFacing targetEntrance;
        protected BlockPos target;
        protected Path path;
        protected int delayCounter;
        protected int pathingFails;
        protected double approachSpeedFar;
        protected double approachSpeedNear;
        protected double lastFinalPositionDistSq;
        protected int stuckCounter;
        protected boolean finished;

        public AIMoveToHideout(EntityBoulderSprite entity, double speed) {
            this.entity = entity;
            this.approachSpeedFar = this.approachSpeedNear = speed;
            this.speed = this.approachSpeedNear;
            this.func_75248_a(19);
        }

        public boolean func_75250_a() {
            if (this.entity.func_70089_S() && this.entity.getHideout() != null && !this.entity.isHiddenOrInWall()) {
                EnumFacing entrance;
                if (this.entity.getHideoutEntrance() == null) {
                    if (this.potentialEntrances.isEmpty()) {
                        for (EnumFacing dir : EnumFacing.field_176754_o) {
                            BlockPos offset = this.entity.getHideout().func_177972_a(dir);
                            PathNodeType node = this.entity.func_70661_as().func_189566_q().func_186330_a((IBlockAccess)this.entity.field_70170_p, offset.func_177958_n(), offset.func_177956_o(), offset.func_177952_p());
                            if (node != PathNodeType.OPEN && node != PathNodeType.WALKABLE) continue;
                            this.potentialEntrances.add(dir);
                        }
                        if (this.potentialEntrances.isEmpty()) {
                            return false;
                        }
                        Collections.sort(this.potentialEntrances, (f1, f2) -> Double.compare(this.entity.getHideout().func_177972_a(f2).func_177954_c(this.entity.field_70165_t, this.entity.field_70163_u, this.entity.field_70161_v), this.entity.getHideout().func_177972_a(f1).func_177954_c(this.entity.field_70165_t, this.entity.field_70163_u, this.entity.field_70161_v)));
                    }
                    entrance = this.potentialEntrances.remove(this.potentialEntrances.size() - 1);
                } else {
                    entrance = this.entity.getHideoutEntrance();
                }
                BlockPos entrancePos = this.entity.getHideout().func_177972_a(entrance);
                this.path = this.entity.func_70661_as().func_179680_a(entrancePos);
                if (this.path != null && this.path.func_75870_c().field_75839_a == entrancePos.func_177958_n() && this.path.func_75870_c().field_75837_b == entrancePos.func_177956_o() && this.path.func_75870_c().field_75838_c == entrancePos.func_177952_p()) {
                    this.entity.setHideoutEntrance(entrance);
                    this.target = entrancePos;
                    this.targetEntrance = entrance;
                    this.targetHideout = this.entity.getHideout();
                    return true;
                }
            }
            return false;
        }

        public void func_75249_e() {
            this.entity.func_70661_as().func_75484_a(this.path, this.speed);
            this.approachSpeedFar = this.approachSpeedNear = (double)this.entity.func_70689_ay();
        }

        public void func_75246_d() {
            if (this.delayCounter-- <= 0) {
                double dist = this.entity.func_70092_e((double)this.target.func_177958_n() + 0.5, (double)this.target.func_177956_o() + 0.5, (double)this.target.func_177952_p() + 0.5);
                this.delayCounter = 4 + this.entity.func_70681_au().nextInt(7);
                if (dist > 1024.0) {
                    this.delayCounter += 10;
                } else if (dist > 256.0) {
                    this.delayCounter += 5;
                }
                if (!this.entity.func_70661_as().func_75492_a((double)this.target.func_177958_n(), (double)this.target.func_177956_o(), (double)this.target.func_177952_p(), this.speed)) {
                    this.delayCounter += 15;
                    ++this.pathingFails;
                }
            }
            double dstSq = this.entity.func_70092_e((double)this.target.func_177958_n() + 0.5, this.target.func_177956_o(), (double)this.target.func_177952_p() + 0.5);
            if (this.entity.func_70661_as().func_75500_f()) {
                if (this.path.func_75879_b()) {
                    this.entity.func_70605_aq().func_75642_a((double)this.target.func_177958_n() + 0.5, (double)this.target.func_177956_o(), (double)this.target.func_177952_p() + 0.5, this.approachSpeedNear / this.entity.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e());
                    this.entity.func_70671_ap().func_75650_a((double)(this.target.func_177958_n() - this.targetEntrance.func_82601_c()) + 0.5, (double)((float)this.target.func_177956_o() + this.entity.func_70047_e()), (double)(this.target.func_177952_p() - this.targetEntrance.func_82599_e()) + 0.5, 30.0f, 30.0f);
                    this.approachSpeedNear = this.approachSpeedNear * 0.9 + Math.min((dstSq + 0.2) / 4.0, 0.1) * 0.1;
                    if (this.lastFinalPositionDistSq == 0.0) {
                        this.lastFinalPositionDistSq = dstSq;
                    } else {
                        if (dstSq > this.lastFinalPositionDistSq - 0.05) {
                            this.stuckCounter += this.entity.func_70681_au().nextInt(3) + 1;
                        } else {
                            this.lastFinalPositionDistSq = dstSq;
                        }
                        if (this.stuckCounter >= 80) {
                            this.finished = true;
                        }
                    }
                    if (this.entity.func_70092_e((double)this.target.func_177958_n() + 0.5, this.target.func_177956_o(), (double)this.target.func_177952_p() + 0.5) < 0.015 && (double)this.entity.func_70689_ay() <= 0.1) {
                        this.finished = true;
                    }
                } else {
                    this.finished = true;
                }
            } else {
                if (dstSq <= (double)(this.entity.func_70689_ay() * 5.0f * 5.0f)) {
                    double decay = ((double)(this.entity.func_70689_ay() * 5.0f * 5.0f) - dstSq) / (double)(this.entity.func_70689_ay() * 5.0f * 5.0f) * 0.33;
                    this.approachSpeedNear = this.approachSpeedFar = this.approachSpeedFar * (1.0 - decay) + Math.min(0.15, this.speed / 4.0) * decay;
                    this.entity.func_70661_as().func_75489_a(this.approachSpeedFar / this.entity.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e());
                } else {
                    this.approachSpeedFar = this.approachSpeedNear = (double)this.entity.func_70689_ay();
                }
                if (this.entity.func_70661_as().func_75505_d() != this.path) {
                    this.finished = true;
                }
            }
        }

        public void func_75251_c() {
            this.potentialEntrances.clear();
            this.path = null;
            this.entity.func_70661_as().func_75499_g();
            this.pathingFails = 0;
            this.finished = false;
            this.lastFinalPositionDistSq = 0.0;
            this.target = null;
            this.targetEntrance = null;
            this.stuckCounter = 0;
        }

        public boolean func_75253_b() {
            return this.entity.func_70089_S() && this.entity.getHideout() != null && this.targetHideout != null && this.targetHideout.equals((Object)this.entity.getHideout()) && this.pathingFails < 3 && !this.finished;
        }
    }

    protected static class AIRollTowardsTarget
    extends EntityAIBase {
        protected final EntityBoulderSprite entity;
        protected int cooldown = 18;
        protected Vec3d rollDir;

        public AIRollTowardsTarget(EntityBoulderSprite entity) {
            this.entity = entity;
            this.func_75248_a(3);
        }

        public boolean func_75250_a() {
            if (this.cooldown-- <= 0) {
                return this.entity.func_70089_S() && this.entity.func_70638_az() != null && this.entity.getRollingTicks() <= 0 && this.entity.field_70122_E && this.entity.func_70638_az().func_70089_S() && this.entity.func_70635_at().func_75522_a((Entity)this.entity.func_70638_az());
            }
            return false;
        }

        public void func_75249_e() {
            EntityLivingBase target = this.entity.func_70638_az();
            if (target != null) {
                this.rollDir = new Vec3d(target.field_70165_t - this.entity.field_70165_t, 0.0, target.field_70161_v - this.entity.field_70161_v).func_72432_b();
                this.entity.startRolling(160, 35, 15, this.rollDir, 1.8);
            }
        }

        public void func_75251_c() {
            this.cooldown = 20 + this.entity.func_70681_au().nextInt(26);
        }

        public boolean func_75253_b() {
            if (this.entity.getRollingTicks() > 0) {
                double overshoot;
                EntityLivingBase target = this.entity.func_70638_az();
                if (target != null && (overshoot = this.rollDir.func_72430_b(new Vec3d(this.entity.field_70165_t - target.field_70165_t, 0.0, this.entity.field_70161_v - target.field_70161_v))) >= 2.0) {
                    this.entity.stopRolling();
                }
                return true;
            }
            return false;
        }
    }
}

