/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.capability.base;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import thebetweenlands.api.capability.ISerializableCapability;
import thebetweenlands.common.TheBetweenlands;
import thebetweenlands.common.capability.base.AbstractCapability;
import thebetweenlands.common.capability.base.EntityCapabilityTracker;
import thebetweenlands.common.network.clientbound.MessageSyncEntityCapabilities;

public abstract class EntityCapability<F extends EntityCapability<F, T, E>, T, E extends Entity>
extends AbstractCapability<F, T, E> {
    private E entity;
    private List<EntityCapabilityTracker> trackers = new ArrayList<EntityCapabilityTracker>();

    protected EntityCapability() {
        Preconditions.checkState((boolean)this.getCapabilityClass().isAssignableFrom(this.getClass()), (String)"Entity capability %s must implement %s", (Object)this.getClass().getName(), (Object)this.getCapabilityClass().getName());
    }

    void setEntity(Entity entity) {
        this.entity = entity;
    }

    protected void init() {
    }

    public final void addTracker(EntityCapabilityTracker tracker) {
        this.trackers.add(tracker);
    }

    public final void removeTracker(EntityCapabilityTracker tracker) {
        this.trackers.remove(tracker);
    }

    public final E getEntity() {
        return this.entity;
    }

    public boolean isApplicable(Entity entity) {
        return false;
    }

    public final EntityCapability<?, ?, E> getEntityCapability(E entity) {
        if (entity.hasCapability(this.getCapability(), null)) {
            return (EntityCapability)entity.getCapability(this.getCapability(), null);
        }
        return null;
    }

    public void writeTrackingDataToNBT(NBTTagCompound nbt) {
    }

    public void readTrackingDataFromNBT(NBTTagCompound nbt) {
    }

    public void markDirty() {
        for (EntityCapabilityTracker tracker : this.trackers) {
            tracker.markDirty();
        }
    }

    public int getTrackingTime() {
        return -1;
    }

    public boolean isPersistent(EntityPlayer oldPlayer, EntityPlayer newPlayer, boolean wasDead) {
        return !wasDead;
    }

    public void clonePersistentData(EntityPlayer oldPlayer, EntityPlayer newPlayer, boolean wasDead, ISerializableCapability newCapability) {
        if (this instanceof ISerializableCapability) {
            NBTTagCompound nbt = new NBTTagCompound();
            ((ISerializableCapability)((Object)this)).writeToNBT(nbt);
            newCapability.readFromNBT(nbt);
        }
    }

    public void sendPacket(EntityPlayerMP player) {
        MessageSyncEntityCapabilities message = new MessageSyncEntityCapabilities(this);
        TheBetweenlands.networkWrapper.sendTo((IMessage)message, player);
    }
}

