/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.client.render.shader;

import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.util.math.MathHelper;
import org.lwjgl.opengl.ContextCapabilities;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GLContext;
import thebetweenlands.api.capability.IPortalCapability;
import thebetweenlands.client.render.shader.ResizableFramebuffer;
import thebetweenlands.client.render.shader.postprocessing.Tonemapper;
import thebetweenlands.client.render.shader.postprocessing.WorldShader;
import thebetweenlands.common.config.BetweenlandsConfig;
import thebetweenlands.common.registries.CapabilityRegistry;
import thebetweenlands.util.FramebufferStack;

public class ShaderHelper
implements IResourceManagerReloadListener {
    public static final ShaderHelper INSTANCE = new ShaderHelper();
    private boolean checked = false;
    private boolean shadersSupported = false;
    private boolean floatBufferSupported = false;
    private boolean arbFloatBufferSupported = false;
    private Exception shaderError = null;
    private WorldShader worldShader = null;
    private Tonemapper toneMappingShader = null;
    private ResizableFramebuffer blitBuffer = null;
    private boolean shadersUpdated = false;
    private boolean required = false;
    public static final int MIN_REQUIRED_TEX_UNITS = 6;

    private ShaderHelper() {
    }

    public WorldShader getWorldShader() {
        return this.worldShader;
    }

    public boolean canUseShaders() {
        if (this.isShaderSupported()) {
            boolean canUseInWorld = true;
            if (BetweenlandsConfig.RENDERING.dimensionShaderOnly) {
                canUseInWorld = Minecraft.func_71410_x().field_71441_e != null && Minecraft.func_71410_x().field_71441_e.field_73011_w.getDimension() == BetweenlandsConfig.WORLD_AND_DIMENSION.dimensionId;
            }
            return this.shaderError == null && OpenGlHelper.func_148822_b() && BetweenlandsConfig.RENDERING.useShader && canUseInWorld;
        }
        BetweenlandsConfig.RENDERING.useShader = false;
        return false;
    }

    public boolean isWorldShaderActive() {
        return this.canUseShaders() && this.worldShader != null;
    }

    public boolean isShaderSupported() {
        this.checkCapabilities();
        return this.shadersSupported;
    }

    public boolean isHDRActive() {
        return false;
    }

    public boolean isHDRSupported() {
        return this.floatBufferSupported && this.arbFloatBufferSupported;
    }

    public boolean isFloatBufferSupported() {
        this.checkCapabilities();
        return this.floatBufferSupported;
    }

    public boolean isARBFloatBufferSupported() {
        this.checkCapabilities();
        return this.arbFloatBufferSupported;
    }

    private void checkCapabilities() {
        if (!this.checked) {
            boolean arbMultitexture;
            this.checked = true;
            ContextCapabilities contextCapabilities = GLContext.getCapabilities();
            boolean supported = contextCapabilities.OpenGL21 || contextCapabilities.GL_ARB_vertex_shader && contextCapabilities.GL_ARB_fragment_shader && contextCapabilities.GL_ARB_shader_objects;
            boolean bl = arbMultitexture = contextCapabilities.GL_ARB_multitexture && !contextCapabilities.OpenGL13;
            int maxTextureUnits = arbMultitexture ? GL11.glGetInteger((int)34018) : (!contextCapabilities.OpenGL20 ? GL11.glGetInteger((int)34018) : GL11.glGetInteger((int)34930));
            boolean textureUnitsSupported = maxTextureUnits >= 6;
            this.shadersSupported = OpenGlHelper.func_153193_b() && supported && OpenGlHelper.field_148823_f && textureUnitsSupported;
            this.floatBufferSupported = contextCapabilities.OpenGL30;
            this.arbFloatBufferSupported = contextCapabilities.GL_ARB_texture_float;
        }
    }

    public void initShaders() {
        if (this.canUseShaders()) {
            try {
                if (this.worldShader == null) {
                    this.worldShader = (WorldShader)new WorldShader().init();
                }
                if (this.blitBuffer == null) {
                    this.blitBuffer = new ResizableFramebuffer(false);
                }
                if (this.toneMappingShader == null && this.isHDRActive()) {
                    this.toneMappingShader = (Tonemapper)new Tonemapper().init();
                }
            }
            catch (Exception ex) {
                this.shaderError = ex;
                ex.printStackTrace();
            }
        }
    }

    public void updateShaders(float partialTicks) {
        if (this.canUseShaders()) {
            try {
                if (this.isRequired()) {
                    this.worldShader.updateDepthBuffer();
                    this.worldShader.updateMatrices();
                    this.worldShader.updateTextures(partialTicks);
                    this.shadersUpdated = true;
                }
            }
            catch (Exception ex) {
                this.shaderError = ex;
                ex.printStackTrace();
            }
        }
    }

    public void renderShaders(float partialTicks) {
        if (this.shadersUpdated && this.worldShader != null && this.isRequired() && this.canUseShaders()) {
            Framebuffer targetFramebuffer1;
            Framebuffer blitFramebuffer;
            Framebuffer mainFramebuffer = Minecraft.func_71410_x().func_147110_a();
            try (FramebufferStack.State state = FramebufferStack.push();){
                blitFramebuffer = this.blitBuffer.getFramebuffer(mainFramebuffer.field_147621_c, mainFramebuffer.field_147618_d);
                targetFramebuffer1 = mainFramebuffer;
                Framebuffer targetFramebuffer2 = blitFramebuffer;
                int renderPasses = MathHelper.func_76141_d((float)(this.worldShader.getLightSourcesAmount() / 32)) + 1;
                renderPasses = 1;
                Minecraft.func_71410_x().field_71460_t.func_78478_c();
                targetFramebuffer2.func_147614_f();
                GlStateManager.func_179118_c();
                for (int i = 0; i < renderPasses; ++i) {
                    this.worldShader.setRenderPass(i);
                    this.worldShader.create(targetFramebuffer2).setSource(targetFramebuffer1.field_147617_g).setRestoreGlState(true).setMirrorY(false).setClearDepth(true).setClearColor(false).render(partialTicks);
                    Framebuffer previous = targetFramebuffer2;
                    targetFramebuffer2 = targetFramebuffer1;
                    targetFramebuffer1 = previous;
                }
                GlStateManager.func_179138_g((int)OpenGlHelper.field_77478_a);
            }
            if (targetFramebuffer1 != mainFramebuffer) {
                float renderWidth = targetFramebuffer1.field_147622_a;
                float renderHeight = targetFramebuffer1.field_147620_b;
                GlStateManager.func_179083_b((int)0, (int)0, (int)((int)renderWidth), (int)((int)renderHeight));
                GlStateManager.func_179128_n((int)5889);
                GlStateManager.func_179096_D();
                GlStateManager.func_179130_a((double)0.0, (double)renderWidth, (double)renderHeight, (double)0.0, (double)1000.0, (double)3000.0);
                GlStateManager.func_179128_n((int)5888);
                GlStateManager.func_179096_D();
                GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-2000.0f);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GlStateManager.func_179098_w();
                targetFramebuffer1.func_147612_c();
                GlStateManager.func_179132_a((boolean)false);
                GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)true);
                Tessellator tessellator = Tessellator.func_178181_a();
                BufferBuilder vb = tessellator.func_178180_c();
                vb.func_181668_a(7, DefaultVertexFormats.field_181707_g);
                vb.func_181662_b(0.0, (double)targetFramebuffer1.field_147620_b, 500.0).func_187315_a(0.0, 0.0).func_181675_d();
                vb.func_181662_b((double)targetFramebuffer1.field_147622_a, (double)targetFramebuffer1.field_147620_b, 500.0).func_187315_a(1.0, 0.0).func_181675_d();
                vb.func_181662_b((double)targetFramebuffer1.field_147622_a, 0.0, 500.0).func_187315_a(1.0, 1.0).func_181675_d();
                vb.func_181662_b(0.0, 0.0, 500.0).func_187315_a(0.0, 1.0).func_181675_d();
                tessellator.func_78381_a();
                GlStateManager.func_179132_a((boolean)true);
                GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)true);
            }
            this.worldShader.setRenderPass(0);
            this.worldShader.renderPostEffects(partialTicks);
            if (!this.isHDRActive() && this.toneMappingShader != null) {
                this.toneMappingShader.delete();
                this.toneMappingShader = null;
            }
            if (this.toneMappingShader != null) {
                this.toneMappingShader.setExposure(1.0f);
                this.toneMappingShader.setGamma(1.0f);
                this.toneMappingShader.create(mainFramebuffer).setSource(mainFramebuffer.field_147617_g).setBlitFramebuffer(blitFramebuffer).setRestoreGlState(true).setMirrorY(false).setClearDepth(false).setClearColor(false).render(partialTicks);
            }
            GlStateManager.func_179141_d();
            this.shadersUpdated = false;
            this.required = false;
        }
    }

    public void deleteShaders() {
        this.shaderError = null;
        if (this.worldShader != null) {
            this.worldShader.delete();
        }
        this.worldShader = null;
        if (this.blitBuffer != null) {
            this.blitBuffer.delete();
        }
        this.blitBuffer = null;
        if (this.toneMappingShader != null) {
            this.toneMappingShader.delete();
        }
        this.toneMappingShader = null;
    }

    public void require() {
        this.required = true;
    }

    private boolean isRequired() {
        IPortalCapability cap;
        if (this.required) {
            return true;
        }
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71439_g != null && (cap = (IPortalCapability)mc.field_71439_g.getCapability(CapabilityRegistry.CAPABILITY_PORTAL, null)) != null && cap.isInPortal()) {
            return true;
        }
        return mc.field_71441_e != null && mc.field_71441_e.field_73011_w.getDimension() == BetweenlandsConfig.WORLD_AND_DIMENSION.dimensionId;
    }

    public void func_110549_a(IResourceManager resourceManager) {
        this.deleteShaders();
    }
}

