/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.client.render.model.baked;

import com.google.common.collect.ImmutableList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.vecmath.Matrix4f;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverride;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.model.PerspectiveMapWrapper;
import net.minecraftforge.common.model.IModelState;
import org.apache.commons.lang3.tuple.Pair;

public class BakedModelItemWrapper
implements IBakedModel {
    private final IBakedModel transformsModel;
    private final IBakedModel quadModel;
    private boolean shouldInheritOverrides = true;
    private boolean shouldCacheOverrideModels = true;
    private ItemOverrideList wrappedOverrideList;

    public BakedModelItemWrapper(IBakedModel transformsModel, IBakedModel quadModel) {
        this.transformsModel = transformsModel;
        this.quadModel = quadModel;
    }

    public BakedModelItemWrapper setInheritOverrides(boolean inherit) {
        this.shouldInheritOverrides = inherit;
        return this;
    }

    public BakedModelItemWrapper setCacheOverrideModels(boolean cached) {
        this.shouldCacheOverrideModels = cached;
        return this;
    }

    public List<BakedQuad> func_188616_a(IBlockState state, EnumFacing side, long rand) {
        return this.quadModel.func_188616_a(state, side, rand);
    }

    public boolean func_177555_b() {
        return this.quadModel.func_177555_b();
    }

    public boolean func_177556_c() {
        return this.quadModel.func_177556_c();
    }

    public boolean func_188618_c() {
        return false;
    }

    public TextureAtlasSprite func_177554_e() {
        return this.quadModel.func_177554_e();
    }

    public ItemCameraTransforms func_177552_f() {
        return this.transformsModel.func_177552_f();
    }

    public ItemOverrideList func_188617_f() {
        if (this.shouldInheritOverrides) {
            return this.transformsModel.func_188617_f();
        }
        if (this.wrappedOverrideList == null) {
            this.wrappedOverrideList = new WrappedItemOverrideList(this.quadModel.func_188617_f());
        }
        return this.wrappedOverrideList;
    }

    public Pair<? extends IBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType cameraTransformType) {
        Pair result = this.transformsModel != null ? this.transformsModel.handlePerspective(cameraTransformType) : PerspectiveMapWrapper.handlePerspective((IBakedModel)this, (IModelState)this.func_177552_f().func_181688_b(cameraTransformType), (ItemCameraTransforms.TransformType)cameraTransformType);
        return Pair.of((Object)this, (Object)result.getValue());
    }

    private static final class WrappedItemOverrideList
    extends ItemOverrideList {
        private final Map<IBakedModel, IBakedModel> cachedModels = new HashMap<IBakedModel, IBakedModel>();
        private final ItemOverrideList parent;

        protected WrappedItemOverrideList(ItemOverrideList parent) {
            super((List)ImmutableList.of());
            this.parent = parent;
        }

        public ResourceLocation func_188021_a(ItemStack stack, @Nullable World worldIn, @Nullable EntityLivingBase entityIn) {
            return this.parent.func_188021_a(stack, worldIn, entityIn);
        }

        public ImmutableList<ItemOverride> getOverrides() {
            return this.parent.getOverrides();
        }

        public IBakedModel handleItemState(IBakedModel originalModel, ItemStack stack, World world, EntityLivingBase entity) {
            BakedModelItemWrapper wrapper = (BakedModelItemWrapper)originalModel;
            IBakedModel quadModel = wrapper.quadModel;
            IBakedModel newModel = this.parent.handleItemState(quadModel, stack, world, entity);
            if (!(newModel instanceof BakedModelItemWrapper)) {
                if (wrapper.shouldCacheOverrideModels) {
                    IBakedModel cachedModel = this.cachedModels.get(newModel);
                    if (cachedModel == null) {
                        cachedModel = new BakedModelItemWrapper(wrapper.transformsModel, newModel).setInheritOverrides(wrapper.shouldInheritOverrides);
                        this.cachedModels.put(newModel, cachedModel);
                    }
                    return cachedModel;
                }
                return new BakedModelItemWrapper(wrapper.transformsModel, newModel).setInheritOverrides(wrapper.shouldInheritOverrides);
            }
            return newModel;
        }
    }
}

