/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.portality.block;

import com.buuz135.portality.block.BlockTileHorizontal;
import com.buuz135.portality.data.PortalDataManager;
import com.buuz135.portality.data.PortalInformation;
import com.buuz135.portality.item.CreativeCreatorItem;
import com.buuz135.portality.proxy.CommonProxy;
import com.buuz135.portality.proxy.client.render.TESRPortal;
import com.buuz135.portality.tile.TileController;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockController
extends BlockTileHorizontal<TileController> {
    public BlockController() {
        super("controller", TileController.class, Material.field_151576_e, 0);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerRender() {
        super.registerRender();
        ClientRegistry.bindTileEntitySpecialRenderer(TileController.class, (TileEntitySpecialRenderer)new TESRPortal());
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        PortalInformation information = new PortalInformation(UUID.randomUUID(), placer.func_110124_au(), false, false, worldIn.field_73011_w.getDimension(), pos, "Dim: " + worldIn.field_73011_w.getDimension() + " X: " + pos.func_177958_n() + " Y: " + pos.func_177956_o() + " Z: " + pos.func_177952_p(), new ItemStack((Block)CommonProxy.BLOCK_FRAME), false);
        PortalDataManager.addInformation(worldIn, information);
        super.func_180633_a(worldIn, pos, state, placer, stack);
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        super.func_176213_c(worldIn, pos, state);
        TileEntity entity = worldIn.func_175625_s(pos);
        if (entity instanceof TileController) {
            ((TileController)entity).clear();
        }
    }

    public void func_176206_d(World worldIn, BlockPos pos, IBlockState state) {
        super.func_176206_d(worldIn, pos, state);
        PortalDataManager.removeInformation(worldIn, pos);
    }

    public void func_180652_a(World worldIn, BlockPos pos, Explosion explosionIn) {
        super.func_180652_a(worldIn, pos, explosionIn);
        PortalDataManager.removeInformation(worldIn, pos);
    }

    @Override
    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        TileEntity tile = worldIn.func_175625_s(pos);
        if (worldIn.field_72995_K) {
            return true;
        }
        if (tile instanceof TileController) {
            TileController controller = (TileController)tile;
            if (controller.isCreative() && !playerIn.func_189808_dh()) {
                return super.func_180639_a(worldIn, pos, state, playerIn, hand, facing, hitX, hitY, hitZ);
            }
            if (!controller.isFormed()) {
                playerIn.func_146105_b((ITextComponent)new TextComponentString(TextFormatting.RED + new TextComponentTranslation("portality.controller.error.size", new Object[0]).func_150254_d()), true);
                return true;
            }
            if (controller.isPrivate() && !controller.getOwner().equals(playerIn.func_110124_au())) {
                playerIn.func_146105_b((ITextComponent)new TextComponentString(TextFormatting.RED + new TextComponentTranslation("portality.controller.error.privacy", new Object[0]).func_150254_d()), true);
                return true;
            }
            ItemStack stack = playerIn.func_184586_b(hand);
            if (!stack.func_190926_b() && stack.func_77973_b().equals((Object)CreativeCreatorItem.INSTANCE)) {
                controller.setCreative(true);
                return true;
            }
            if (playerIn.func_70093_af() && controller.getOwner().equals(playerIn.func_110124_au()) && !stack.func_190926_b() && !stack.func_77969_a(controller.getDisplay())) {
                playerIn.func_146105_b((ITextComponent)new TextComponentString(TextFormatting.GREEN + new TextComponentTranslation("portility.controller.info.icon_changed", new Object[0]).func_150254_d()), true);
                controller.setDisplayNameEnabled(playerIn.func_184586_b(hand));
                return true;
            }
        }
        return super.func_180639_a(worldIn, pos, state, playerIn, hand, facing, hitX, hitY, hitZ);
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        TileEntity entity = worldIn.func_175625_s(pos);
        if (entity instanceof TileController) {
            ((TileController)entity).breakController();
        }
        super.func_180663_b(worldIn, pos, state);
    }
}

