/*
 * Decompiled with CFR 0.152.
 */
package erogenousbeef.bigreactors.common.multiblock;

import com.google.common.collect.Maps;
import erogenousbeef.bigreactors.common.multiblock.RotorShaftState;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;

public enum RotorBladeState implements IStringSerializable
{
    HIDDEN,
    Y_X_POS,
    Y_X_NEG,
    Y_Z_POS,
    Y_Z_NEG,
    X_Y_POS,
    X_Y_NEG,
    X_Z_POS,
    X_Z_NEG,
    Z_Y_POS,
    Z_Y_NEG,
    Z_X_POS,
    Z_X_NEG;

    private final String _name = this.name().toLowerCase();
    private static final Map<String, RotorBladeState> NAME_LOOKUP;

    public String toString() {
        return this._name;
    }

    public String func_176610_l() {
        return this._name;
    }

    @Nullable
    public static RotorBladeState from(String name) {
        return name == null ? null : NAME_LOOKUP.get(name.toLowerCase());
    }

    @Nullable
    public static RotorBladeState from(RotorShaftState shaftState, EnumFacing bladeFacing) {
        String name;
        switch (shaftState) {
            case X_YZ: {
                name = "x_" + bladeFacing.func_176740_k().func_176610_l() + (bladeFacing.func_176743_c() == EnumFacing.AxisDirection.POSITIVE ? "_neg" : "_pos");
                break;
            }
            case Y_XZ: {
                name = "y_" + bladeFacing.func_176740_k().func_176610_l() + (bladeFacing.func_176743_c() == EnumFacing.AxisDirection.POSITIVE ? "_neg" : "_pos");
                break;
            }
            case Z_XY: {
                name = "z_" + bladeFacing.func_176740_k().func_176610_l() + (bladeFacing.func_176743_c() == EnumFacing.AxisDirection.POSITIVE ? "_neg" : "_pos");
                break;
            }
            default: {
                name = shaftState.func_176610_l() + (bladeFacing.func_176734_d().func_176743_c() == EnumFacing.AxisDirection.POSITIVE ? "_pos" : "_neg");
            }
        }
        return RotorBladeState.from(name);
    }

    static {
        NAME_LOOKUP = Maps.newHashMap();
        for (RotorBladeState state : RotorBladeState.values()) {
            NAME_LOOKUP.put(state.func_176610_l(), state);
        }
    }
}

