/*
 * Decompiled with CFR 0.152.
 */
package com.cjm721.overloaded.item.functional;

import com.cjm721.overloaded.Overloaded;
import com.cjm721.overloaded.OverloadedCreativeTabs;
import com.cjm721.overloaded.client.render.dynamic.ImageUtil;
import com.cjm721.overloaded.client.render.item.RenderMultiToolAssist;
import com.cjm721.overloaded.item.functional.PowerModItem;
import com.cjm721.overloaded.network.packets.LeftClickBlockMessage;
import com.cjm721.overloaded.network.packets.RightClickBlockMessage;
import com.cjm721.overloaded.util.BlockBreakResult;
import com.cjm721.overloaded.util.BlockPlaceResult;
import com.cjm721.overloaded.util.PlayerInteractionUtil;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Enchantments;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.ItemHandlerHelper;

public class ItemMultiTool
extends PowerModItem {
    private static final Set<String> toolClasses = ImmutableSet.of((Object)"pickaxe", (Object)"shovel", (Object)"axe");

    public ItemMultiTool() {
        this.setRegistryName("multi_tool");
        this.func_77655_b("multi_tool");
        this.func_77637_a(OverloadedCreativeTabs.TECH);
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return enchantment != null && enchantment.field_77351_y == EnumEnchantmentType.DIGGER;
    }

    public int getItemEnchantability(ItemStack stack) {
        return 15;
    }

    public boolean func_77616_k(@Nonnull ItemStack stack) {
        return this.getItemStackLimit(stack) == 1;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModel() {
        ModelResourceLocation location = new ModelResourceLocation(new ResourceLocation("overloaded", "multi_tool"), null);
        ModelLoader.setCustomModelResourceLocation((Item)this, (int)0, (ModelResourceLocation)location);
        ImageUtil.registerDynamicTexture(new ResourceLocation("overloaded", "textures/items/ntool.png"), Overloaded.cachedConfig.textureResolutions.itemResolution);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        tooltip.add("Assist Mode: " + RenderMultiToolAssist.getAssistMode().getName());
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
    }

    public boolean func_179218_a(ItemStack stack, World worldIn, IBlockState state, BlockPos pos, EntityLivingBase entityLiving) {
        IEnergyStorage storage = (IEnergyStorage)stack.getCapability(CapabilityEnergy.ENERGY, null);
        if (storage != null) {
            int efficiency = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185305_q, (ItemStack)stack);
            int unbreaking = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185307_s, (ItemStack)stack);
            float breakCost = this.getBreakCost(worldIn.func_180495_p(pos).func_185887_b(worldIn, pos), efficiency, unbreaking, entityLiving == null ? 10.0 : this.getDistance(entityLiving, pos));
            storage.extractEnergy((int)Math.min(2.1474836E9f, breakCost), false);
        }
        return super.func_179218_a(stack, worldIn, state, pos, entityLiving);
    }

    private double getDistance(@Nonnull EntityLivingBase entityLiving, @Nonnull BlockPos pos) {
        return entityLiving.func_70011_f((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
    }

    public boolean func_150897_b(IBlockState blockIn) {
        return false;
    }

    public boolean canDestroyBlockInCreative(World world, BlockPos pos, ItemStack stack, EntityPlayer player) {
        return player == null || super.canDestroyBlockInCreative(world, pos, stack, player) && !player.func_70093_af();
    }

    public float func_150893_a(ItemStack stack, IBlockState state) {
        return 0.0f;
    }

    @Nonnull
    @SideOnly(value=Side.CLIENT)
    public ActionResult<ItemStack> func_77659_a(@Nonnull World worldIn, @Nonnull EntityPlayer player, @Nonnull EnumHand hand) {
        RayTraceResult result;
        if (worldIn.field_72995_K && (result = PlayerInteractionUtil.getBlockPlayerLookingAtClient(player, Minecraft.func_71410_x().func_184121_ak())) != null) {
            Overloaded.proxy.networkWrapper.sendToServer((IMessage)new RightClickBlockMessage(result.func_178782_a(), result.field_178784_b, (float)result.field_72307_f.field_72450_a - (float)result.func_178782_a().func_177958_n(), (float)result.field_72307_f.field_72448_b - (float)result.func_178782_a().func_177956_o(), (float)result.field_72307_f.field_72449_c - (float)result.func_178782_a().func_177952_p()));
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)player.func_184586_b(hand));
    }

    private float getBreakCost(float hardness, int efficiency, int unbreaking, double distance) {
        return (float)((double)(hardness * (float)Overloaded.cachedConfig.multiToolConfig.breakCostMultiplier / (float)(efficiency + 1) + (float)(Overloaded.cachedConfig.multiToolConfig.breakBaseCost / (unbreaking + 1))) + distance);
    }

    @Nonnull
    private BlockBreakResult breakAndUseEnergy(@Nonnull World worldIn, @Nonnull BlockPos blockPos, @Nonnull IEnergyStorage energy, @Nonnull EntityPlayerMP player, int efficiency, int unbreaking) {
        IBlockState state = worldIn.func_180495_p(blockPos);
        if (!player.field_71075_bZ.field_75098_d) {
            float hardness = state.func_185887_b(worldIn, blockPos);
            if (hardness < 0.0f) {
                return BlockBreakResult.FAIL_UNBREAKABLE;
            }
            float floatBreakCost = this.getBreakCost(hardness, efficiency, unbreaking, this.getDistance((EntityLivingBase)player, blockPos));
            if (Float.isInfinite(floatBreakCost) || Float.isNaN(floatBreakCost)) {
                return BlockBreakResult.FAIL_ENERGY;
            }
            int breakCost = Math.round(floatBreakCost);
            if (breakCost < 0 || energy.getEnergyStored() < breakCost) {
                return BlockBreakResult.FAIL_ENERGY;
            }
        }
        if (player.func_174818_b(blockPos) > (double)(Overloaded.cachedConfig.multiToolConfig.reach * Overloaded.cachedConfig.multiToolConfig.reach)) {
            return BlockBreakResult.FAIL_RANGE;
        }
        if (!state.func_177230_c().canEntityDestroy(state, (IBlockAccess)worldIn, blockPos, (Entity)player)) {
            return BlockBreakResult.FAIL_REMOVE;
        }
        BlockEvent.BreakEvent event = new BlockEvent.BreakEvent(worldIn, blockPos, state, (EntityPlayer)player);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (event.isCanceled()) {
            return BlockBreakResult.FAIL_REMOVE;
        }
        boolean result = PlayerInteractionUtil.tryHarvestBlock(player, worldIn, blockPos);
        return result ? BlockBreakResult.SUCCESS : BlockBreakResult.FAIL_REMOVE;
    }

    public void drawParticleStreamTo(@Nonnull EntityPlayer source, @Nonnull Vec3d endingLocation, @Nonnull EnumParticleTypes type) {
        double xOffset = 0.0;
        double yOffset = -0.25;
        double zOffset = 0.0;
        Vec3d startingLocation = source.func_174824_e(1.0f).func_72441_c(xOffset, yOffset, zOffset);
        startingLocation = startingLocation.func_178787_e(source.func_70040_Z().func_178785_b(-1.5707964f).func_186678_a(0.5));
        Vec3d direction = endingLocation.func_178788_d(startingLocation).func_72432_b();
        startingLocation = startingLocation.func_178787_e(direction);
        World world = source.func_130014_f_();
        double distanceToEnd = endingLocation.func_72438_d(startingLocation);
        while (distanceToEnd > 0.3 && distanceToEnd < (double)(Overloaded.cachedConfig.multiToolConfig.reach * 2)) {
            world.func_175688_a(type, startingLocation.field_72450_a, startingLocation.field_72448_b, startingLocation.field_72449_c, 0.0, 0.0, 0.0, new int[0]);
            startingLocation = startingLocation.func_178787_e(direction.func_186678_a(0.25));
            distanceToEnd = endingLocation.func_72438_d(startingLocation);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    @SideOnly(value=Side.CLIENT)
    public void leftClickBlock(@Nonnull PlayerInteractEvent.LeftClickBlock event) {
        if (event.getSide() == Side.SERVER || event.getEntityPlayer() != Minecraft.func_71410_x().field_71439_g) {
            return;
        }
        ItemStack stack = event.getItemStack();
        if (stack.func_77973_b().equals(this)) {
            this.leftClickOnBlockClient(event.getPos(), event.getHitVec());
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    @SideOnly(value=Side.CLIENT)
    public void leftClickEmpty(@Nonnull PlayerInteractEvent.LeftClickEmpty event) {
        EntityPlayer entityLiving;
        RayTraceResult result;
        if (event.getSide() == Side.SERVER || event.getEntityPlayer() != Minecraft.func_71410_x().field_71439_g) {
            return;
        }
        ItemStack stack = event.getItemStack();
        if (stack.func_77973_b().equals(this) && (result = PlayerInteractionUtil.getBlockPlayerLookingAtClient(entityLiving = event.getEntityPlayer(), Minecraft.func_71410_x().func_184121_ak())) != null) {
            this.leftClickOnBlockClient(result.func_178782_a(), result.field_72307_f);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void teleportDrops(@Nonnull BlockEvent.HarvestDropsEvent event) {
        EntityPlayer player = event.getHarvester();
        if (player == null || event.getHarvester().func_184614_ca().func_77973_b() != this || event.getDrops() instanceof ImmutableList) {
            return;
        }
        World world = event.getWorld();
        float chance = event.getDropChance();
        for (ItemStack stack : event.getDrops()) {
            if (!(world.field_73012_v.nextFloat() <= chance)) continue;
            ItemHandlerHelper.giveItemToPlayer((EntityPlayer)player, (ItemStack)stack);
        }
        event.getDrops().clear();
    }

    @SideOnly(value=Side.CLIENT)
    private void leftClickOnBlockClient(BlockPos pos, Vec3d hitVec) {
        LeftClickBlockMessage message = new LeftClickBlockMessage(pos);
        Overloaded.proxy.networkWrapper.sendToServer((IMessage)message);
    }

    public void leftClickOnBlockServer(@Nonnull EntityPlayerMP player, LeftClickBlockMessage message) {
        BlockPos pos = message.getPos();
        WorldServer world = player.func_71121_q();
        ItemStack itemStack = player.func_184586_b(EnumHand.MAIN_HAND);
        if (itemStack.func_77973_b() != this || world.func_175623_d(pos)) {
            return;
        }
        player.func_184598_c(EnumHand.MAIN_HAND);
        if (player.func_70093_af()) {
            NBTTagCompound tag = itemStack.func_77978_p();
            if (tag == null) {
                tag = new NBTTagCompound();
            }
            IBlockState state = world.func_180495_p(pos);
            Item item = Item.func_150898_a((Block)state.func_177230_c());
            ItemStack stackToPlace = new ItemStack(item, 1, state.func_177230_c().func_180651_a(state));
            NBTTagCompound blockTag = new NBTTagCompound();
            stackToPlace.func_77955_b(blockTag);
            tag.func_74782_a("Item", (NBTBase)blockTag);
            itemStack.func_77982_d(tag);
            ITextComponent component = stackToPlace.func_151000_E();
            player.func_146105_b(new TextComponentString("Bound tool to ").func_150257_a(component), true);
        } else {
            IEnergyStorage energy = (IEnergyStorage)itemStack.getCapability(CapabilityEnergy.ENERGY, null);
            int efficiency = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185305_q, (ItemStack)itemStack);
            int unbreaking = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185307_s, (ItemStack)itemStack);
            switch (this.breakAndUseEnergy((World)world, pos, energy, player, efficiency, unbreaking)) {
                case FAIL_REMOVE: {
                    player.func_146105_b((ITextComponent)new TextComponentString("Unable to break block, reason unknown"), true);
                    break;
                }
                case FAIL_ENERGY: {
                    player.func_146105_b((ITextComponent)new TextComponentString("Unable to break block, not enough energy"), true);
                    break;
                }
                case FAIL_UNBREAKABLE: {
                    player.func_146105_b((ITextComponent)new TextComponentString("Block is unbreakable"), true);
                    break;
                }
                case FAIL_RANGE: {
                    player.func_146105_b((ITextComponent)new TextComponentString("Block is out of range."), true);
                    break;
                }
            }
        }
    }

    public void rightClickWithItem(@Nonnull EntityPlayerMP player, RightClickBlockMessage message) {
        BlockPos pos = message.getPos();
        EnumFacing sideHit = message.getHitSide();
        float hitX = message.getHitX();
        float hitY = message.getHitY();
        float hitZ = message.getHitZ();
        WorldServer worldIn = player.func_71121_q();
        ItemStack multiTool = player.func_184614_ca();
        if (multiTool.func_77973_b() != this) {
            return;
        }
        ItemStack blockStack = this.getSelectedBlockItemStack(multiTool);
        if (blockStack.func_190926_b()) {
            player.func_146105_b((ITextComponent)new TextComponentString("No block type selected to place."), true);
            return;
        }
        if (!(blockStack.func_77973_b() instanceof ItemBlock)) {
            player.func_146105_b((ITextComponent)new TextComponentString("No valid block type selected to place."), true);
            return;
        }
        IEnergyStorage energy = (IEnergyStorage)multiTool.getCapability(CapabilityEnergy.ENERGY, null);
        Vec3i sideVector = sideHit.func_176730_m();
        BlockPos.MutableBlockPos newPosition = new BlockPos.MutableBlockPos(pos.func_177971_a(sideVector));
        switch (PlayerInteractionUtil.placeBlock(blockStack, player, (World)worldIn, (BlockPos)newPosition, sideHit, energy, hitX, hitY, hitZ)) {
            case FAIL_PREREQUISITE: {
                player.func_146105_b((ITextComponent)new TextComponentString("Do not have the required items"), true);
                return;
            }
            case FAIL_DENY: {
                player.func_146105_b((ITextComponent)new TextComponentString("Unable to place blocks"), true);
                return;
            }
            case FAIL_RANGE: {
                player.func_146105_b((ITextComponent)new TextComponentString("To far away"), true);
                return;
            }
            case FAIL_ENERGY: {
                player.func_146105_b((ITextComponent)new TextComponentString("Not enough energy"), true);
                return;
            }
        }
        if (player.func_70093_af()) {
            BlockPos playerPos = player.func_180425_c();
            block6 : switch (sideHit) {
                case UP: {
                    while (newPosition.func_177956_o() < playerPos.func_177956_o()) {
                        newPosition.func_189536_c(sideHit);
                        if (PlayerInteractionUtil.placeBlock(blockStack, player, (World)worldIn, (BlockPos)newPosition, sideHit, energy, hitX, hitY, hitZ) == BlockPlaceResult.SUCCESS) continue;
                        break block6;
                    }
                    break;
                }
                case DOWN: {
                    while (newPosition.func_177956_o() > playerPos.func_177956_o()) {
                        newPosition.func_189536_c(sideHit);
                        if (PlayerInteractionUtil.placeBlock(blockStack, player, (World)worldIn, (BlockPos)newPosition, sideHit, energy, hitX, hitY, hitZ) == BlockPlaceResult.SUCCESS) continue;
                        break block6;
                    }
                    break;
                }
                case NORTH: {
                    while (newPosition.func_177952_p() > playerPos.func_177952_p()) {
                        newPosition.func_189536_c(sideHit);
                        if (PlayerInteractionUtil.placeBlock(blockStack, player, (World)worldIn, (BlockPos)newPosition, sideHit, energy, hitX, hitY, hitZ) == BlockPlaceResult.SUCCESS) continue;
                        break block6;
                    }
                    break;
                }
                case SOUTH: {
                    while (newPosition.func_177952_p() < playerPos.func_177952_p()) {
                        newPosition.func_189536_c(sideHit);
                        if (PlayerInteractionUtil.placeBlock(blockStack, player, (World)worldIn, (BlockPos)newPosition, sideHit, energy, hitX, hitY, hitZ) == BlockPlaceResult.SUCCESS) continue;
                        break block6;
                    }
                    break;
                }
                case EAST: {
                    while (newPosition.func_177958_n() < playerPos.func_177958_n()) {
                        newPosition.func_189536_c(sideHit);
                        if (PlayerInteractionUtil.placeBlock(blockStack, player, (World)worldIn, (BlockPos)newPosition, sideHit, energy, hitX, hitY, hitZ) == BlockPlaceResult.SUCCESS) continue;
                        break block6;
                    }
                    break;
                }
                case WEST: {
                    while (newPosition.func_177958_n() > playerPos.func_177958_n()) {
                        newPosition.func_189536_c(sideHit);
                        if (PlayerInteractionUtil.placeBlock(blockStack, player, (World)worldIn, (BlockPos)newPosition, sideHit, energy, hitX, hitY, hitZ) == BlockPlaceResult.SUCCESS) continue;
                        break block6;
                    }
                    break;
                }
            }
        }
    }

    @Nonnull
    public ItemStack getSelectedBlockItemStack(ItemStack multiTool) {
        NBTTagCompound tagCompound = multiTool.func_77978_p();
        if (tagCompound == null || !tagCompound.func_74764_b("Item")) {
            return ItemStack.field_190927_a;
        }
        NBTTagCompound itemTag = tagCompound.func_74775_l("Item");
        return new ItemStack(itemTag);
    }

    @Nonnull
    public Set<String> getToolClasses(ItemStack stack) {
        return toolClasses;
    }

    public boolean canHarvestBlock(@Nonnull IBlockState state, ItemStack stack) {
        return true;
    }

    @Nonnull
    public String func_77653_i(@Nonnull ItemStack stack) {
        return TextFormatting.GOLD + super.func_77653_i(stack);
    }
}

