/*
 * Decompiled with CFR 0.152.
 */
package com.whammich.sstow;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import com.whammich.sstow.SoulShardsTOW;
import com.whammich.sstow.item.ItemSoulShard;
import com.whammich.sstow.util.PosWithStack;
import com.whammich.sstow.util.TierHandler;
import com.whammich.sstow.util.serialization.SerializerBlockPos;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.util.math.BlockPos;

public class JsonConfigHandler {
    public static Gson gson = new GsonBuilder().setPrettyPrinting().serializeNulls().disableHtmlEscaping().registerTypeAdapter(BlockPos.class, (Object)new SerializerBlockPos()).create();

    public static void initShard(File jsonConfig) {
        try {
            if (!jsonConfig.exists() && jsonConfig.createNewFile()) {
                Map<Integer, TierHandler.Tier> defaultMap = JsonConfigHandler.handleShardDefaults();
                String json = gson.toJson(defaultMap, new TypeToken<Map<Integer, TierHandler.Tier>>(){}.getType());
                FileWriter writer = new FileWriter(jsonConfig);
                writer.write(json);
                writer.close();
            }
            Map tempMap = (Map)gson.fromJson((Reader)new FileReader(jsonConfig), new TypeToken<Map<Integer, TierHandler.Tier>>(){}.getType());
            for (Map.Entry tierEntry : tempMap.entrySet()) {
                TierHandler.tiers.put((Integer)tierEntry.getKey(), (TierHandler.Tier)tierEntry.getValue());
                if ((Integer)tierEntry.getKey() <= TierHandler.maxTier) continue;
                TierHandler.maxTier = (Integer)tierEntry.getKey();
            }
        }
        catch (IOException e) {
            SoulShardsTOW.LOGGER.error("Failed to create a default Tier configuration file.");
            e.printStackTrace();
        }
    }

    public static void initMultiblock(File jsonConfig) {
        ItemSoulShard.buildMultiblock();
    }

    private static Map<Integer, TierHandler.Tier> handleShardDefaults() {
        HashMap<Integer, TierHandler.Tier> ret = new HashMap<Integer, TierHandler.Tier>();
        ret.put(0, new TierHandler.Tier(0, 63, true, false, false, 0, 0));
        ret.put(1, new TierHandler.Tier(64, 127, true, true, false, 2, 20));
        ret.put(2, new TierHandler.Tier(128, 255, true, true, false, 4, 10));
        ret.put(3, new TierHandler.Tier(256, 511, false, true, false, 4, 5));
        ret.put(4, new TierHandler.Tier(512, 1023, false, true, false, 4, 5));
        ret.put(5, new TierHandler.Tier(1024, 1024, false, false, true, 6, 2));
        return ret;
    }

    private static ArrayList<PosWithStack> handleMultiblockDefaults() {
        ArrayList<PosWithStack> ret = new ArrayList<PosWithStack>();
        return ret;
    }
}

