/*
 * Decompiled with CFR 0.152.
 */
package com.mordenkainen.bedpatch;

import com.mordenkainen.bedpatch.BedPatch;
import com.mordenkainen.bedpatch.asmhelper.ASMHelper;
import com.mordenkainen.bedpatch.asmhelper.ObfHelper;
import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public class BedPatchASM
implements IClassTransformer {
    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        if ("net.minecraft.world.chunk.Chunk".equals(transformedName)) {
            BedPatch.logger.info("Patching Chunk");
            ClassNode classNode = ASMHelper.readClassFromBytes(basicClass);
            MethodNode method = ASMHelper.findMethodNodeOfClass(classNode, "func_76623_d", "onChunkUnload", "()V");
            InsnList insnList = new InsnList();
            insnList.add((AbstractInsnNode)new VarInsnNode(25, 0));
            insnList.add((AbstractInsnNode)new FieldInsnNode(180, "net/minecraft/world/chunk/Chunk", ObfHelper.isObfuscated() ? "field_76637_e" : "world", "Lnet/minecraft/world/World;"));
            insnList.add((AbstractInsnNode)new VarInsnNode(25, 0));
            insnList.add((AbstractInsnNode)new FieldInsnNode(180, "net/minecraft/world/chunk/Chunk", ObfHelper.isObfuscated() ? "field_76645_j" : "entityLists", "[Lnet/minecraft/util/ClassInheritanceMultiMap;"));
            insnList.add((AbstractInsnNode)new MethodInsnNode(184, "com/mordenkainen/bedpatch/BedPatchFunc", "onChunkUnload", "(Lnet/minecraft/world/World;[Lnet/minecraft/util/ClassInheritanceMultiMap;)V", false));
            AbstractInsnNode insert = ASMHelper.findFirstInstruction(method);
            method.instructions.insertBefore(insert, insnList);
            return ASMHelper.writeClassToBytes(classNode, 2);
        }
        return basicClass;
    }
}

