/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.multipart;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import mcjty.lib.multipart.PartSlot;
import mcjty.lib.tileentity.GenericTileEntity;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class MultipartTE
extends TileEntity {
    private Map<PartSlot, Part> parts = new HashMap<PartSlot, Part>();
    private int version = 0;

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        return oldState.func_177230_c() != newSate.func_177230_c();
    }

    private void dumpParts(String prefix) {
        if (this.field_145850_b.field_72995_K) {
            System.out.println("====== CLIENT(" + prefix + ") " + this.field_174879_c.toString() + " ======");
        } else {
            System.out.println("====== SERVER(" + prefix + ") " + this.field_174879_c.toString() + " ======");
        }
        for (Map.Entry<PartSlot, Part> entry : this.parts.entrySet()) {
            IBlockState state = entry.getValue().state;
            System.out.println("    SLOT: " + entry.getKey().name() + "    " + state.func_177230_c().getRegistryName().toString());
            for (Map.Entry e : state.func_177228_b().entrySet()) {
                System.out.println("        PROP: " + e.getKey() + " = " + e.getValue());
            }
        }
    }

    public void addPart(PartSlot slot, IBlockState state, TileEntity te) {
        this.parts.put(slot, new Part(state, te));
        if (te instanceof GenericTileEntity) {
            ((GenericTileEntity)te).onPartAdded(slot, state, this);
        }
        if (!this.field_145850_b.field_72995_K) {
            ++this.version;
            this.markDirtyClient();
        }
    }

    public void removePart(IBlockState partState) {
        for (Map.Entry<PartSlot, Part> entry : this.parts.entrySet()) {
            if (entry.getValue().getState() != partState) continue;
            this.parts.remove((Object)entry.getKey());
            if (!this.field_145850_b.field_72995_K) {
                ++this.version;
                this.markDirtyClient();
            }
            return;
        }
    }

    public Map<PartSlot, Part> getParts() {
        return this.parts;
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        int oldVersion = this.version;
        this.func_145839_a(packet.func_148857_g());
        if (this.field_145850_b.field_72995_K && this.version != oldVersion) {
            this.field_145850_b.func_175704_b(this.field_174879_c, this.field_174879_c);
        }
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound updateTag = super.func_189517_E_();
        this.func_189515_b(updateTag);
        return updateTag;
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound nbtTag = new NBTTagCompound();
        this.func_189515_b(nbtTag);
        return new SPacketUpdateTileEntity(this.field_174879_c, 1, nbtTag);
    }

    public void markDirtyClient() {
        this.func_70296_d();
        if (this.field_145850_b != null) {
            IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 3);
        }
    }

    private boolean partExists(PartSlot slot, IBlockState state) {
        if (this.parts.containsKey((Object)slot)) {
            return this.parts.get((Object)slot).getState().equals(state);
        }
        return false;
    }

    public void markDirtyQuick() {
        if (this.field_145850_b != null) {
            this.field_145850_b.func_175646_b(this.field_174879_c, (TileEntity)this);
        }
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        HashMap<PartSlot, Part> newparts = new HashMap<PartSlot, Part>();
        this.version = compound.func_74762_e("version");
        NBTTagList list = compound.func_150295_c("parts", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound tc;
            NBTTagCompound tag = list.func_150305_b(i);
            PartSlot slot = PartSlot.byName(tag.func_74779_i("slot"));
            if (slot == null) continue;
            IBlockState state = NBTUtil.func_190008_d((NBTTagCompound)tag);
            if (this.partExists(slot, state)) {
                Part part = this.parts.get((Object)slot);
                if (tag.func_74764_b("te")) {
                    tc = tag.func_74775_l("te");
                    TileEntity te = part.tileEntity;
                    if (te == null) {
                        te = state.func_177230_c().createTileEntity(this.field_145850_b, state);
                        if (te != null) {
                            te.func_145834_a(this.field_145850_b);
                            te.func_145839_a(tc);
                            te.func_174878_a(this.field_174879_c);
                        }
                    } else {
                        te.func_145839_a(tc);
                        te.func_174878_a(this.field_174879_c);
                    }
                }
                newparts.put(slot, part);
                continue;
            }
            TileEntity te = null;
            if (tag.func_74764_b("te")) {
                tc = tag.func_74775_l("te");
                te = state.func_177230_c().createTileEntity(this.field_145850_b, state);
                if (te != null) {
                    te.func_145834_a(this.field_145850_b);
                    te.func_145839_a(tc);
                    te.func_174878_a(this.field_174879_c);
                }
            }
            Part part = new Part(state, te);
            newparts.put(slot, part);
        }
        this.parts = newparts;
    }

    protected void func_190201_b(World worldIn) {
        this.func_145834_a(worldIn);
    }

    public void func_145834_a(World worldIn) {
        super.func_145834_a(worldIn);
        for (Map.Entry<PartSlot, Part> entry : this.parts.entrySet()) {
            if (entry.getValue().getTileEntity() == null) continue;
            entry.getValue().getTileEntity().func_145834_a(this.field_145850_b);
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        NBTTagList list = new NBTTagList();
        for (Map.Entry<PartSlot, Part> entry : this.parts.entrySet()) {
            NBTTagCompound tag = new NBTTagCompound();
            PartSlot slot = entry.getKey();
            Part part = entry.getValue();
            tag.func_74778_a("slot", slot.name());
            IBlockState state = part.getState();
            NBTUtil.func_190009_a((NBTTagCompound)tag, (IBlockState)state);
            TileEntity te = part.getTileEntity();
            if (te != null) {
                NBTTagCompound tc = new NBTTagCompound();
                tc = te.func_189515_b(tc);
                tag.func_74782_a("te", (NBTBase)tc);
            }
            list.func_74742_a((NBTBase)tag);
        }
        compound.func_74782_a("parts", (NBTBase)list);
        compound.func_74768_a("version", this.version);
        return super.func_189515_b(compound);
    }

    public boolean testIntersect(IBlockState blockState) {
        AxisAlignedBB box = blockState.func_185900_c((IBlockAccess)this.field_145850_b, this.field_174879_c);
        for (Map.Entry<PartSlot, Part> entry : this.getParts().entrySet()) {
            Part part = entry.getValue();
            AxisAlignedBB partBox = part.getState().func_185900_c((IBlockAccess)this.field_145850_b, this.field_174879_c);
            if (!box.func_72326_a(partBox)) continue;
            return true;
        }
        return false;
    }

    public static class Part {
        private final IBlockState state;
        private final TileEntity tileEntity;

        public Part(IBlockState state, TileEntity tileEntity) {
            this.state = state;
            this.tileEntity = tileEntity;
        }

        public IBlockState getState() {
            return this.state;
        }

        public TileEntity getTileEntity() {
            return this.tileEntity;
        }
    }
}

