/*
 * Decompiled with CFR 0.152.
 */
package techreborn.items;

import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.templates.FluidHandlerItemStackSimple;

public class ItemTRFluidContainer
extends FluidHandlerItemStackSimple.Consumable {
    public ItemTRFluidContainer(ItemStack container) {
        super(container, 1000);
    }

    private boolean contentsAllowed(FluidStack fluidStack) {
        Fluid fluid = fluidStack.getFluid();
        return fluid != null;
    }

    public int fill(FluidStack resource, boolean doFill) {
        int fillAmount;
        if (resource == null || resource.amount <= 0 || !this.canFillFluidType(resource)) {
            return 0;
        }
        FluidStack contained = this.getFluid();
        if (contained == null && (fillAmount = Math.min(this.capacity, resource.amount)) == this.capacity) {
            if (doFill) {
                FluidStack filled = resource.copy();
                filled.amount = fillAmount;
                this.setFluid(filled);
            }
            return fillAmount;
        }
        return 0;
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        if (maxDrain <= 0) {
            return null;
        }
        FluidStack contained = this.getFluid();
        if (contained == null || contained.amount <= 0 || !this.canDrainFluidType(contained)) {
            return null;
        }
        int drainAmount = Math.min(contained.amount, maxDrain);
        if (drainAmount == this.capacity) {
            FluidStack drained = contained.copy();
            if (doDrain) {
                this.setContainerToEmpty();
            }
            return drained;
        }
        return null;
    }

    public boolean canFillFluidType(FluidStack fluid) {
        return this.contentsAllowed(fluid);
    }

    public boolean canDrainFluidType(FluidStack fluid) {
        return this.contentsAllowed(fluid);
    }

    protected void setFluid(FluidStack fluid) {
        super.setFluid(fluid);
    }

    protected void setContainerToEmpty() {
        assert (this.container.func_77978_p() != null);
        this.container.func_77982_d(null);
    }
}

