/*
 * Decompiled with CFR 0.152.
 */
package org.magicwerk.brownies.collections.primitive;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import org.magicwerk.brownies.collections.GapList;
import org.magicwerk.brownies.collections.IList;
import org.magicwerk.brownies.collections.helper.NaturalComparator;
import org.magicwerk.brownies.collections.primitive.DoubleGapList;

public class DoubleObjGapList
extends IList<Double> {
    DoubleGapList list;

    static Double[] toWrapper(double[] elems) {
        Double[] e = new Double[elems.length];
        for (int i = 0; i < e.length; ++i) {
            e[i] = elems[i];
        }
        return e;
    }

    static double[] toPrimitive(Double[] elems) {
        double[] e = new double[elems.length];
        for (int i = 0; i < e.length; ++i) {
            e[i] = elems[i];
        }
        return e;
    }

    static double[] toPrimitive(GapList<? extends Double> list2) {
        double[] e = new double[list2.size()];
        for (int i = 0; i < e.length; ++i) {
            e[i] = list2.get(i);
        }
        return e;
    }

    static double[] toPrimitive(Collection<? extends Double> list2) {
        double[] e = new double[list2.size()];
        Iterator<? extends Double> iter = list2.iterator();
        for (int i = 0; i < e.length; ++i) {
            e[i] = iter.next();
        }
        return e;
    }

    public static DoubleObjGapList create() {
        return new DoubleObjGapList();
    }

    public static DoubleObjGapList create(Double ... elems) {
        DoubleObjGapList list2 = new DoubleObjGapList();
        list2.init(elems);
        return list2;
    }

    public static DoubleObjGapList create(Collection<? extends Double> elems) {
        return new DoubleObjGapList(elems);
    }

    public DoubleObjGapList() {
        this.init();
    }

    public void init() {
        this.list = new DoubleGapList();
    }

    public DoubleObjGapList(int capacity) {
        this.list = new DoubleGapList(capacity);
    }

    public void init(Double ... elems) {
        this.list = DoubleGapList.create(DoubleObjGapList.toPrimitive(elems));
    }

    public DoubleObjGapList(Collection<? extends Double> elems) {
        this.init(elems);
    }

    public void init(Collection<? extends Double> elems) {
        this.list = DoubleGapList.create(DoubleObjGapList.toPrimitive(elems));
    }

    @Override
    protected void doClone(IList<Double> that) {
        this.list = (DoubleGapList)((DoubleObjGapList)that).list.clone();
    }

    @Override
    protected void doAssign(IList<Double> that) {
        DoubleObjGapList list2 = (DoubleObjGapList)that;
        this.list = list2.list;
    }

    public DoubleObjGapList copy() {
        return (DoubleObjGapList)this.clone();
    }

    @Override
    public Double getDefaultElem() {
        return this.list.getDefaultElem();
    }

    @Override
    public IList<Double> doCreate(int capacity) {
        if (capacity == -1) {
            capacity = 10;
        }
        return new DoubleObjGapList(capacity);
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public int capacity() {
        return this.list.capacity();
    }

    @Override
    public Double get(int index) {
        return this.list.get(index);
    }

    @Override
    protected Double doGet(int index) {
        return this.list.doGet(index);
    }

    @Override
    protected void doGetAll(Object[] elems, int index, int len2) {
        for (int i = 0; i < len2; ++i) {
            elems[i] = this.list.doGet(index + i);
        }
    }

    @Override
    protected boolean doAdd(int index, Double elem) {
        return this.list.doAdd(index, elem);
    }

    @Override
    protected Double doSet(int index, Double elem) {
        return this.list.doSet(index, elem);
    }

    @Override
    protected Double doRemove(int index) {
        return this.list.doRemove(index);
    }

    @Override
    protected void doRemoveAll(int index, int len2) {
        this.list.doRemoveAll(index, len2);
    }

    @Override
    protected Double doReSet(int index, Double elem) {
        return this.list.doReSet(index, elem);
    }

    @Override
    public void move(int srcIndex, int dstIndex, int len2) {
        this.list.move(srcIndex, dstIndex, len2);
    }

    @Override
    protected void doEnsureCapacity(int minCapacity) {
        this.list.doEnsureCapacity(minCapacity);
    }

    @Override
    public void trimToSize() {
        this.list.trimToSize();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj != null && this.getClass() == obj.getClass()) {
            return this.list.equals(obj);
        }
        return super.equals(obj);
    }

    @Override
    public int hashCode() {
        return this.list.hashCode();
    }

    @Override
    public String toString() {
        return this.list.toString();
    }

    @Override
    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    @Override
    public int indexOf(Object elem) {
        if (elem == null || elem.getClass() != Double.class) {
            return -1;
        }
        return this.list.indexOf((Double)elem);
    }

    @Override
    public int lastIndexOf(Object elem) {
        if (elem == null || elem.getClass() != Double.class) {
            return -1;
        }
        return this.list.lastIndexOf((Double)elem);
    }

    @Override
    public boolean remove(Object elem) {
        if (elem == null || elem.getClass() != Double.class) {
            return false;
        }
        int index = this.list.indexOf((Double)elem);
        if (index == -1) {
            return false;
        }
        this.list.remove(index);
        return true;
    }

    @Override
    public boolean contains(Object elem) {
        if (elem == null || elem.getClass() != Double.class) {
            return false;
        }
        return this.list.contains((Double)elem);
    }

    @Override
    public boolean containsAny(Collection<?> coll) {
        return this.list.containsAny(coll);
    }

    @Override
    public boolean containsAll(Collection<?> coll) {
        return this.list.containsAll(coll);
    }

    @Override
    public boolean removeAll(Collection<?> coll) {
        return this.list.removeAll(coll);
    }

    @Override
    public boolean removeAll(IList<?> coll) {
        return this.list.removeAll(coll);
    }

    @Override
    public boolean retainAll(Collection<?> coll) {
        return this.list.retainAll(coll);
    }

    @Override
    public boolean retainAll(IList<?> coll) {
        return this.list.retainAll(coll);
    }

    @Override
    public Object[] toArray() {
        return this.toArray(0, this.size());
    }

    @Override
    public Object[] toArray(int index, int len2) {
        Object[] elems = new Object[len2];
        for (int i = 0; i < len2; ++i) {
            elems[i] = this.list.get(i);
        }
        return elems;
    }

    @Override
    public <T> T[] toArray(T[] array) {
        int size2 = this.list.size();
        if (array.length < size2) {
            array = (Object[])Array.newInstance(array.getClass().getComponentType(), size2);
        }
        for (int i = 0; i < size2; ++i) {
            array[i] = this.list.get(i);
        }
        if (array.length > size2) {
            array[size2] = null;
        }
        return array;
    }

    @Override
    public boolean addAll(Collection<? extends Double> coll) {
        return this.list.addAll(coll);
    }

    @Override
    public boolean addAll(int index, Collection<? extends Double> coll) {
        return this.list.addAll(index, coll);
    }

    public boolean addArray(Double ... elems) {
        double[] e = DoubleObjGapList.toPrimitive(elems);
        return this.list.addArray(e);
    }

    public boolean addArray(int index, Double ... elems) {
        double[] e = DoubleObjGapList.toPrimitive(elems);
        return this.list.addArray(index, e);
    }

    @Override
    public boolean addAll(IList<? extends Double> list2) {
        double[] e = DoubleObjGapList.toPrimitive(list2);
        return this.list.addArray(e);
    }

    @Override
    public boolean addAll(int index, IList<? extends Double> list2) {
        double[] e = DoubleObjGapList.toPrimitive(list2);
        return this.list.addArray(index, e);
    }

    @Override
    public boolean removeFirstOccurrence(Object elem) {
        if (elem == null || elem.getClass() != Double.class) {
            return false;
        }
        return this.list.removeFirstOccurrence((Double)elem);
    }

    @Override
    public boolean removeLastOccurrence(Object elem) {
        if (elem == null || elem.getClass() != Double.class) {
            return false;
        }
        return this.list.removeLastOccurrence((Double)elem);
    }

    @Override
    public GapList<Double> getAll(int index, int len2) {
        double[] elems = this.list.getArray(index, len2);
        return GapList.create(DoubleObjGapList.toWrapper(elems));
    }

    public Double[] getArray(int index, int len2) {
        double[] elems = this.list.getArray(index, len2);
        return DoubleObjGapList.toWrapper(elems);
    }

    @Override
    public void setAll(int index, IList<? extends Double> list2) {
        double[] e = DoubleObjGapList.toPrimitive(list2);
        this.list.setArray(index, e);
    }

    @Override
    public void setAll(int index, Collection<? extends Double> coll) {
        double[] e = DoubleObjGapList.toPrimitive(coll);
        this.list.setArray(index, e);
    }

    public void setArray(int index, Double ... elems) {
        double[] e = DoubleObjGapList.toPrimitive(elems);
        this.list.setArray(index, e);
    }

    @Override
    public void sort(int index, int len2, Comparator comparator) {
        if (comparator != null && comparator != NaturalComparator.INSTANCE()) {
            throw new IllegalArgumentException("Only natural comparator (null) allowed");
        }
        this.list.sort(index, len2);
    }

    @Override
    public <K> int binarySearch(int index, int len2, K key, Comparator<? super K> comparator) {
        if (comparator != null && comparator != NaturalComparator.INSTANCE()) {
            throw new IllegalArgumentException("Only natural comparator (null) allowed");
        }
        return this.list.binarySearch(index, len2, (Double)key);
    }

    public DoubleObjGapList unmodifiableList() {
        return new ImmutableDoubleObjGapList(this);
    }

    protected static class ImmutableDoubleObjGapList
    extends DoubleObjGapList {
        private static final long serialVersionUID = -1352274047348922584L;

        protected ImmutableDoubleObjGapList(DoubleObjGapList that) {
            super(that);
        }

        @Override
        protected boolean doAdd(int index, Double elem) {
            this.error();
            return false;
        }

        @Override
        protected Double doSet(int index, Double elem) {
            this.error();
            return null;
        }

        @Override
        protected Double doReSet(int index, Double elem) {
            this.error();
            return null;
        }

        @Override
        protected Double doRemove(int index) {
            this.error();
            return null;
        }

        @Override
        protected void doRemoveAll(int index, int len2) {
            this.error();
        }

        @Override
        protected void doModify() {
            this.error();
        }

        private void error() {
            throw new UnsupportedOperationException("list is immutable");
        }
    }
}

