/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.librarianlib.features.structure;

import com.teamwizardry.librarianlib.features.structure.Structure;
import com.teamwizardry.librarianlib.features.structure.TemplateBlockAccess;
import com.teamwizardry.librarianlib.features.utilities.client.BlockRenderUtils;
import java.awt.Color;
import java.nio.IntBuffer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.gen.structure.template.Template;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;

@SideOnly(value=Side.CLIENT)
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/teamwizardry/librarianlib/features/structure/StructureRenderUtil;", "", "()V", "blockBuf", "Lnet/minecraft/client/renderer/BufferBuilder;", "render", "", "structure", "Lcom/teamwizardry/librarianlib/features/structure/Structure;", "color", "Ljava/awt/Color;", "brightness", "", "librarianlib-1.12.2"})
public final class StructureRenderUtil {
    private static final BufferBuilder blockBuf;
    public static final StructureRenderUtil INSTANCE;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final int[] render(@NotNull Structure structure, @NotNull Color color2, float brightness) {
        IBlockState state;
        Intrinsics.checkParameterIsNotNull((Object)structure, (String)"structure");
        Intrinsics.checkParameterIsNotNull((Object)color2, (String)"color");
        TemplateBlockAccess access = structure.getBlockAccess();
        blockBuf.func_178965_a();
        blockBuf.func_181668_a(7, DefaultVertexFormats.field_176599_b);
        for (Template.BlockInfo info : structure.blockInfos()) {
            BlockPos blockPos = info.field_186242_a;
            Intrinsics.checkExpressionValueIsNotNull((Object)blockPos, (String)"info.pos");
            state = access.func_180495_p(blockPos);
            if (state.func_185901_i() == EnumBlockRenderType.INVISIBLE) continue;
            Block block = state.func_177230_c();
            Intrinsics.checkExpressionValueIsNotNull((Object)block, (String)"state.block");
            if (block.func_180664_k() != BlockRenderLayer.SOLID) continue;
            IBlockAccess iBlockAccess = access;
            BlockPos blockPos2 = info.field_186242_a;
            Intrinsics.checkExpressionValueIsNotNull((Object)blockPos2, (String)"info.pos");
            BlockPos blockPos3 = info.field_186242_a.func_177973_b((Vec3i)structure.getOrigin());
            Intrinsics.checkExpressionValueIsNotNull((Object)blockPos3, (String)"info.pos.subtract(structure.origin)");
            BlockRenderUtils.renderBlockToVB(state, iBlockAccess, blockPos2, blockPos3, blockBuf, (float)color2.getRed() / 255.0f, (float)color2.getGreen() / 255.0f, (float)color2.getBlue() / 255.0f, brightness, (float)color2.getAlpha() / 255.0f);
        }
        for (Template.BlockInfo info : structure.blockInfos()) {
            BlockPos blockPos = info.field_186242_a;
            Intrinsics.checkExpressionValueIsNotNull((Object)blockPos, (String)"info.pos");
            state = access.func_180495_p(blockPos);
            if (state.func_185901_i() == EnumBlockRenderType.INVISIBLE) continue;
            Block block = state.func_177230_c();
            Intrinsics.checkExpressionValueIsNotNull((Object)block, (String)"state.block");
            if (block.func_180664_k() != BlockRenderLayer.CUTOUT) {
                Block block2 = state.func_177230_c();
                Intrinsics.checkExpressionValueIsNotNull((Object)block2, (String)"state.block");
                if (block2.func_180664_k() != BlockRenderLayer.CUTOUT_MIPPED) continue;
            }
            IBlockAccess iBlockAccess = access;
            BlockPos blockPos4 = info.field_186242_a;
            Intrinsics.checkExpressionValueIsNotNull((Object)blockPos4, (String)"info.pos");
            BlockPos blockPos5 = info.field_186242_a.func_177973_b((Vec3i)structure.getOrigin());
            Intrinsics.checkExpressionValueIsNotNull((Object)blockPos5, (String)"info.pos.subtract(structure.origin)");
            BlockRenderUtils.renderBlockToVB(state, iBlockAccess, blockPos4, blockPos5, blockBuf, (float)color2.getRed() / 255.0f, (float)color2.getGreen() / 255.0f, (float)color2.getBlue() / 255.0f, brightness, (float)color2.getAlpha() / 255.0f);
        }
        for (Template.BlockInfo info : structure.blockInfos()) {
            BlockPos blockPos = info.field_186242_a;
            Intrinsics.checkExpressionValueIsNotNull((Object)blockPos, (String)"info.pos");
            state = access.func_180495_p(blockPos);
            if (state.func_185901_i() == EnumBlockRenderType.INVISIBLE) continue;
            Block block = state.func_177230_c();
            Intrinsics.checkExpressionValueIsNotNull((Object)block, (String)"state.block");
            if (block.func_180664_k() != BlockRenderLayer.TRANSLUCENT) continue;
            IBlockAccess iBlockAccess = access;
            BlockPos blockPos6 = info.field_186242_a;
            Intrinsics.checkExpressionValueIsNotNull((Object)blockPos6, (String)"info.pos");
            BlockPos blockPos7 = info.field_186242_a.func_177973_b((Vec3i)structure.getOrigin());
            Intrinsics.checkExpressionValueIsNotNull((Object)blockPos7, (String)"info.pos.subtract(structure.origin)");
            BlockRenderUtils.renderBlockToVB(state, iBlockAccess, blockPos6, blockPos7, blockBuf, (float)color2.getRed() / 255.0f, (float)color2.getGreen() / 255.0f, (float)color2.getBlue() / 255.0f, brightness, (float)color2.getAlpha() / 255.0f);
        }
        blockBuf.func_178977_d();
        IntBuffer intBuf = blockBuf.func_178966_f().asIntBuffer();
        int[] bufferInts = new int[intBuf.limit()];
        int state2 = 0;
        int n = bufferInts.length;
        while (state2 < n) {
            void i;
            bufferInts[i] = intBuf.get((int)i);
            ++i;
        }
        return bufferInts;
    }

    private StructureRenderUtil() {
    }

    static {
        StructureRenderUtil structureRenderUtil;
        INSTANCE = structureRenderUtil = new StructureRenderUtil();
        blockBuf = new BufferBuilder(50000);
    }
}

