/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.tile.storage;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class StorageKey {
    @Nonnull
    private final Item item;
    private final int metadata;

    public StorageKey(@Nonnull ItemStack stack) {
        this.item = stack.func_77973_b();
        this.metadata = this.item.func_77645_m() ? 0 : stack.func_77960_j();
    }

    private StorageKey(@Nonnull Item item, int metadata) {
        this.item = item;
        this.metadata = metadata;
    }

    public static StorageKey from(ItemStack stack) {
        return new StorageKey(stack);
    }

    public static StorageKey from(@Nonnull Item item, int meta) {
        return new StorageKey(item, meta);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StorageKey that = (StorageKey)o;
        return (this.item.func_77614_k() || this.metadata == that.metadata) && this.item.getRegistryName().equals((Object)that.item.getRegistryName());
    }

    public int hashCode() {
        int result = this.item.getRegistryName().hashCode();
        if (this.item.func_77614_k()) {
            result = 31 * result + this.metadata;
        }
        return result;
    }

    @Nonnull
    public NBTTagCompound serialize() {
        NBTTagCompound keyTag = new NBTTagCompound();
        keyTag.func_74778_a("name", this.item.getRegistryName().toString());
        keyTag.func_74768_a("meta", this.metadata);
        return keyTag;
    }

    @Nullable
    public static StorageKey deserialize(NBTTagCompound nbt) {
        ResourceLocation rl = new ResourceLocation(nbt.func_74779_i("name"));
        Item i = (Item)ForgeRegistries.ITEMS.getValue(rl);
        if (i == null || i == Items.field_190931_a) {
            return null;
        }
        int meta = nbt.func_74762_e("meta");
        return new StorageKey(i, meta);
    }
}

