/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.crafting.helper;

import hellfirepvp.astralsorcery.common.crafting.helper.AbstractRecipeData;
import hellfirepvp.astralsorcery.common.util.ItemUtils;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.util.ResourceLocation;

public class SmeltingRecipe
extends AbstractRecipeData {
    private final ItemStack input;
    private final float exp;

    private SmeltingRecipe(ItemStack input, ItemStack output, float exp) {
        super(output);
        this.input = input;
        this.exp = exp;
        FurnaceRecipes.func_77602_a().func_151394_a(this.input, this.getOutput(), this.exp);
    }

    public ItemStack getInput() {
        return this.input;
    }

    public float getExp() {
        return this.exp;
    }

    public static class Builder {
        private boolean registered = false;
        private final ResourceLocation entry;
        private final ItemStack output;
        private ItemStack input = ItemStack.field_190927_a;
        private float exp = 1.0f;

        private Builder(String name, @Nonnull ItemStack output) {
            this.entry = new ResourceLocation("astralsorcery", "smelting/" + name);
            this.output = ItemUtils.copyStackWithSize(output, output.func_190916_E());
        }

        public static Builder newSmelting(String name, Block output) {
            return Builder.newSmelting(name, new ItemStack(output));
        }

        public static Builder newSmelting(String name, Item output) {
            return Builder.newSmelting(name, new ItemStack(output));
        }

        public static Builder newSmelting(String name, ItemStack output) {
            return new Builder(name, output);
        }

        public Builder setInput(Block block) {
            return this.setInput(new ItemStack(block));
        }

        public Builder setInput(Item item) {
            return this.setInput(new ItemStack(item));
        }

        public Builder setInput(ItemStack stack) {
            this.input = stack;
            return this;
        }

        public Builder setExp(float exp) {
            this.exp = exp;
            return this;
        }

        public SmeltingRecipe buildAndRegister() {
            if (this.registered) {
                throw new IllegalArgumentException("Tried to register previously built recipe twice!");
            }
            this.registered = true;
            return new SmeltingRecipe(this.input, this.output, this.exp);
        }
    }
}

