/*
 * Decompiled with CFR 0.152.
 */
package code.elix_x.excore.utils.client.render.vao;

import code.elix_x.excore.utils.client.render.vao.VertexBuffer;
import code.elix_x.excore.utils.client.render.vbo.VBO;
import java.nio.ByteBuffer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.renderer.vertex.VertexFormatElement;
import org.lwjgl.opengl.GL20;

public class VertexBufferSeparate
extends VertexBuffer {
    private final VBO[] vbos;
    private final int[] indexMap;

    private static VertexFormat removePaddings(VertexFormat format) {
        VertexFormat nf = new VertexFormat();
        for (VertexFormatElement element : format.func_177343_g()) {
            if (element.func_177375_c() == VertexFormatElement.EnumUsage.PADDING) continue;
            nf.func_181721_a(element);
        }
        return nf;
    }

    private VertexBufferSeparate(VertexFormat format, int drawMode, int vertexCount) {
        super(VertexBufferSeparate.removePaddings(format), drawMode, vertexCount);
        int i;
        this.vbos = new VBO[this.format.func_177345_h()];
        for (i = 0; i < this.vbos.length; ++i) {
            this.vbos[i] = new VBO();
        }
        this.indexMap = new int[this.vbos.length];
        for (i = 0; i < this.indexMap.length; ++i) {
            this.indexMap[i] = i;
        }
    }

    public VertexBufferSeparate(BufferBuilder vertexBuffer) {
        this(vertexBuffer.func_178973_g(), vertexBuffer.func_178979_i(), vertexBuffer.func_178989_h());
        ByteBuffer bytebuf = vertexBuffer.func_178966_f();
        ByteBuffer[] byteBuffers = new ByteBuffer[this.vbos.length];
        for (int e = 0; e < byteBuffers.length; ++e) {
            byteBuffers[e] = VertexBufferSeparate.createByteBuffer(this.vertexCount, this.format.func_177348_c(e));
        }
        for (int v = 0; v < this.vertexCount; ++v) {
            int ee = 0;
            for (int e = 0; e < vertexBuffer.func_178973_g().func_177345_h(); ++e) {
                if (vertexBuffer.func_178973_g().func_177348_c(e).func_177375_c() == VertexFormatElement.EnumUsage.PADDING) {
                    bytebuf.get(new byte[vertexBuffer.func_178973_g().func_177348_c(e).func_177368_f()]);
                    continue;
                }
                ByteBuffer buffer = byteBuffers[ee];
                VertexFormatElement element = this.format.func_177348_c(ee);
                byte[] bytes = new byte[element.func_177368_f()];
                bytebuf.get(bytes);
                buffer.put(bytes);
                ++ee;
            }
        }
        this.vao.bind();
        for (int b = 0; b < this.vbos.length; ++b) {
            VBO vbo = this.vbos[b];
            ByteBuffer buffer = byteBuffers[b];
            VertexFormatElement formatElement = this.format.func_177348_c(b);
            buffer.flip();
            vbo.bind();
            vbo.data(buffer, 35044);
            this.vao.vboSeparate(vbo, this.indexMap[b], formatElement);
            vbo.unbind();
        }
        this.vao.unbind();
    }

    @Override
    protected void renderPre() {
        super.renderPre();
        for (int i : this.indexMap) {
            GL20.glEnableVertexAttribArray((int)i);
        }
    }

    @Override
    protected void renderPost() {
        for (int i : this.indexMap) {
            GL20.glDisableVertexAttribArray((int)i);
        }
        super.renderPost();
    }

    @Override
    public void cleanUp() {
        for (VBO vbo : this.vbos) {
            vbo.cleanUp();
        }
        super.cleanUp();
    }
}

