/*
 * Decompiled with CFR 0.152.
 */
package code.elix_x.excore.utils.client.render.model.vertex;

import code.elix_x.excomms.color.RGBA;
import code.elix_x.excore.utils.client.render.model.vertex.PackedVertex;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.renderer.vertex.VertexFormatElement;
import net.minecraft.util.math.Vec3i;
import org.lwjgl.util.vector.Vector2f;
import org.lwjgl.util.vector.Vector3f;

public class DefaultUnpackedVertex {
    private Vector3f pos;
    private RGBA color;
    private Vector2f texture;
    private Vec3i lightmap;
    private Vec3i normal;
    private Map<VertexFormatElement, float[]> unknown = new HashMap<VertexFormatElement, float[]>();

    public DefaultUnpackedVertex(Vector3f pos, RGBA color, Vector2f texture, Vec3i lightmap, Vec3i normal) {
        this.pos = pos;
        this.color = color;
        this.texture = texture;
        this.lightmap = lightmap;
        this.normal = normal;
    }

    /*
     * Enabled aggressive block sorting
     */
    public DefaultUnpackedVertex(VertexFormat format, float[][] data) {
        int i = 0;
        while (true) {
            block11: {
                if (i >= data.length) {
                    return;
                }
                VertexFormatElement element = format.func_177348_c(i);
                float[] edata = data[i];
                switch (element.func_177375_c()) {
                    case POSITION: {
                        if (element.func_177367_b() != VertexFormatElement.EnumType.FLOAT || element.func_177370_d() != 3) break;
                        this.pos = new Vector3f(edata[0], edata[1], edata[2]);
                        break block11;
                    }
                    case COLOR: {
                        if (element.func_177367_b() != VertexFormatElement.EnumType.UBYTE || element.func_177370_d() != 4) break;
                        this.color = new RGBA(edata[0], edata[1], edata[2], edata[3]);
                        break block11;
                    }
                    case UV: {
                        if (element.func_177367_b() == VertexFormatElement.EnumType.FLOAT && element.func_177370_d() == 2) {
                            this.texture = new Vector2f(edata[0], edata[1]);
                            break block11;
                        } else {
                            if (element.func_177367_b() != VertexFormatElement.EnumType.SHORT || element.func_177370_d() != 2) break;
                            this.lightmap = new Vec3i((int)((short)edata[0]), (int)((short)edata[1]), 0);
                        }
                        break block11;
                    }
                    case NORMAL: {
                        if (element.func_177367_b() != VertexFormatElement.EnumType.BYTE || element.func_177370_d() != 3) break;
                        this.normal = new Vec3i((int)((byte)edata[0]), (int)((byte)edata[1]), (int)((byte)edata[2]));
                        break block11;
                    }
                    case PADDING: {
                        break block11;
                    }
                }
                this.unknown.put(element, edata);
            }
            ++i;
        }
    }

    public Vector3f getPos() {
        return this.pos;
    }

    public DefaultUnpackedVertex setPos(Vector3f pos) {
        this.pos = pos;
        return this;
    }

    public RGBA getColor() {
        return this.color;
    }

    public DefaultUnpackedVertex setColor(RGBA color) {
        this.color = color;
        return this;
    }

    public Vector2f getTexture() {
        return this.texture;
    }

    public DefaultUnpackedVertex setTexture(Vector2f texture) {
        this.texture = texture;
        return this;
    }

    public Vec3i getLightmap() {
        return this.lightmap;
    }

    public DefaultUnpackedVertex setLightmap(Vec3i lightmap) {
        this.lightmap = lightmap;
        return this;
    }

    public Vec3i getNormal() {
        return this.normal;
    }

    public DefaultUnpackedVertex setNormal(Vec3i normal) {
        this.normal = normal;
        return this;
    }

    public Map<VertexFormatElement, float[]> getUnknown() {
        return this.unknown;
    }

    public DefaultUnpackedVertex setUnknown(Map<VertexFormatElement, float[]> unknown) {
        this.unknown = unknown;
        return this;
    }

    public float[] getUnknown(VertexFormatElement element) {
        return this.unknown.get(element);
    }

    public DefaultUnpackedVertex setUnknown(VertexFormatElement element, float[] data) {
        this.unknown.put(element, data);
        return this;
    }

    /*
     * Enabled aggressive block sorting
     */
    public PackedVertex pack(VertexFormat format) {
        float[][] data = new float[format.func_177345_h()][];
        int i = 0;
        while (true) {
            block12: {
                if (i >= data.length) {
                    return new PackedVertex(format, data);
                }
                VertexFormatElement element = format.func_177348_c(i);
                data[i] = new float[element.func_177370_d()];
                float[] edata = data[i];
                switch (element.func_177375_c()) {
                    case POSITION: {
                        if (element.func_177367_b() != VertexFormatElement.EnumType.FLOAT || element.func_177370_d() != 3) break;
                        edata[0] = this.pos.x;
                        edata[1] = this.pos.y;
                        edata[2] = this.pos.z;
                        break block12;
                    }
                    case COLOR: {
                        if (element.func_177367_b() != VertexFormatElement.EnumType.UBYTE || element.func_177370_d() != 4) break;
                        edata[0] = this.color.getRF();
                        edata[1] = this.color.getGF();
                        edata[2] = this.color.getBF();
                        edata[3] = this.color.getAF();
                        break block12;
                    }
                    case UV: {
                        if (element.func_177367_b() == VertexFormatElement.EnumType.FLOAT && element.func_177370_d() == 2) {
                            edata[0] = this.texture.x;
                            edata[1] = this.texture.y;
                            break block12;
                        } else {
                            if (element.func_177367_b() != VertexFormatElement.EnumType.SHORT || element.func_177370_d() != 2) break;
                            edata[0] = (short)this.lightmap.func_177958_n();
                            edata[1] = (short)this.lightmap.func_177956_o();
                        }
                        break block12;
                    }
                    case NORMAL: {
                        if (element.func_177367_b() != VertexFormatElement.EnumType.BYTE || element.func_177370_d() != 3) break;
                        edata[0] = (byte)this.normal.func_177958_n();
                        edata[1] = (byte)this.normal.func_177956_o();
                        edata[2] = (byte)this.normal.func_177952_p();
                        break block12;
                    }
                    case PADDING: {
                        break block12;
                    }
                }
                if (this.unknown.containsKey(element)) {
                    System.arraycopy(this.unknown.get(element), 0, edata, 0, edata.length);
                }
            }
            ++i;
        }
    }
}

