/*
 * Decompiled with CFR 0.152.
 */
package code.elix_x.excore.utils.client.render.model;

import code.elix_x.excore.utils.client.render.model.UnpackedBakedQuad;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimaps;
import java.util.List;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.block.model.SimpleBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.EnumFacing;

public class UnpackedSimpleBakedModel {
    private List<UnpackedBakedQuad> generalQuads;
    private ListMultimap<EnumFacing, UnpackedBakedQuad> faceQuads;
    private boolean ambientOcclusion;
    private boolean gui3d;
    private TextureAtlasSprite texture;
    private ItemCameraTransforms cameraTransforms;
    private ItemOverrideList itemOverrideList;

    public UnpackedSimpleBakedModel(List<UnpackedBakedQuad> generalQuads, ListMultimap<EnumFacing, UnpackedBakedQuad> faceQuads, boolean ambientOcclusion, boolean gui3d, TextureAtlasSprite texture, ItemCameraTransforms cameraTransforms, ItemOverrideList itemOverrideList) {
        this.generalQuads = generalQuads;
        this.faceQuads = faceQuads;
        this.ambientOcclusion = ambientOcclusion;
        this.gui3d = gui3d;
        this.texture = texture;
        this.cameraTransforms = cameraTransforms;
        this.itemOverrideList = itemOverrideList;
    }

    public List<UnpackedBakedQuad> getGeneralQuads() {
        return this.generalQuads;
    }

    public void setGeneralQuads(List<UnpackedBakedQuad> generalQuads) {
        this.generalQuads = generalQuads;
    }

    public List<UnpackedBakedQuad> getFaceQuads(EnumFacing facing) {
        return this.faceQuads.get((Object)facing);
    }

    public void setFaceQuads(EnumFacing facing, List<UnpackedBakedQuad> faceQuads) {
        this.faceQuads.removeAll((Object)facing);
        this.faceQuads.putAll((Object)facing, faceQuads);
    }

    public ListMultimap<EnumFacing, UnpackedBakedQuad> getFaceQuads() {
        return this.faceQuads;
    }

    public void setFaceQuads(ListMultimap<EnumFacing, UnpackedBakedQuad> faceQuads) {
        this.faceQuads = faceQuads;
    }

    public boolean isAmbientOcclusion() {
        return this.ambientOcclusion;
    }

    public void setAmbientOcclusion(boolean ambientOcclusion) {
        this.ambientOcclusion = ambientOcclusion;
    }

    public boolean isGui3d() {
        return this.gui3d;
    }

    public void setGui3d(boolean gui3d) {
        this.gui3d = gui3d;
    }

    public TextureAtlasSprite getTexture() {
        return this.texture;
    }

    public void setTexture(TextureAtlasSprite texture) {
        this.texture = texture;
    }

    public ItemCameraTransforms getCameraTransforms() {
        return this.cameraTransforms;
    }

    public void setCameraTransforms(ItemCameraTransforms cameraTransforms) {
        this.cameraTransforms = cameraTransforms;
    }

    public ItemOverrideList getItemOverrideList() {
        return this.itemOverrideList;
    }

    public void setItemOverrideList(ItemOverrideList itemOverrideList) {
        this.itemOverrideList = itemOverrideList;
    }

    public SimpleBakedModel pack(VertexFormat format) {
        return new SimpleBakedModel(Lists.transform(this.generalQuads, quad -> quad.pack(format)), Multimaps.asMap((ListMultimap)Multimaps.transformValues(this.faceQuads, quad -> quad.pack(format))), this.ambientOcclusion, this.gui3d, this.texture, this.cameraTransforms, this.itemOverrideList);
    }

    public static UnpackedSimpleBakedModel unpack(SimpleBakedModel model) {
        ArrayListMultimap faceQuads = ArrayListMultimap.create();
        for (EnumFacing facing : EnumFacing.values()) {
            faceQuads.putAll((Object)facing, (Iterable)Lists.transform((List)model.func_188616_a(null, facing, 0L), quad -> UnpackedBakedQuad.unpack(quad)));
        }
        return new UnpackedSimpleBakedModel(Lists.transform((List)model.func_188616_a(null, null, 0L), quad -> UnpackedBakedQuad.unpack(quad)), (ListMultimap<EnumFacing, UnpackedBakedQuad>)faceQuads, model.func_177555_b(), model.func_177556_c(), model.func_177554_e(), model.func_177552_f(), model.func_188617_f());
    }
}

