/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.tileentities;

import com.minecolonies.api.colony.permissions.Action;
import com.minecolonies.api.util.InventoryFunctions;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.LanguageHandler;
import com.minecolonies.api.util.Log;
import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.ColonyManager;
import com.minecolonies.coremod.colony.ColonyView;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingContainer;
import com.minecolonies.coremod.colony.buildings.views.AbstractBuildingView;
import com.minecolonies.coremod.inventory.api.CombinedItemHandler;
import com.minecolonies.coremod.tileentities.TileEntityRack;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TileEntityColonyBuilding
extends TileEntityChest {
    private static final String TAG_COLONY = "colony";
    private static final String TAG_MIRROR = "mirror";
    private static final String TAG_STYLE = "style";
    private int colonyId = 0;
    private Colony colony;
    private AbstractBuildingContainer building;
    private boolean mirror;
    private String style = "";
    private CombinedItemHandler combinedInv;

    public int getColonyId() {
        return this.colonyId;
    }

    public Colony getColony() {
        if (this.colony == null) {
            this.updateColonyReferences();
        }
        return this.colony;
    }

    private void updateColonyReferences() {
        if (this.colony == null && this.func_145831_w() != null) {
            this.colony = this.colonyId == 0 ? ColonyManager.getColonyByPosFromWorld(this.func_145831_w(), this.func_174877_v()) : ColonyManager.getColonyByWorld(this.colonyId, this.func_145831_w());
            if (this.colony == null && !this.func_145831_w().field_72995_K) {
                Log.getLogger().warn(String.format("TileEntityColonyBuilding at %s:[%d,%d,%d] had colony.", this.func_145831_w().func_72912_H().func_76065_j(), this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p()));
            }
        }
        if (this.building == null && this.colony != null) {
            this.building = this.colony.getBuildingManager().getBuilding(this.getPosition());
            if (!(this.building == null || this.func_145831_w() != null && this.func_145831_w().field_72995_K)) {
                this.building.setTileEntity(this);
            }
        }
    }

    public BlockPos getPosition() {
        return this.field_174879_c;
    }

    @Nullable
    public BlockPos getPositionOfChestWithItemStack(@NotNull Predicate<ItemStack> itemStackSelectionPredicate) {
        Predicate<ItemStack> notEmptyPredicate = itemStackSelectionPredicate.and(ItemStackUtils.NOT_EMPTY_PREDICATE);
        AbstractBuildingContainer theBuilding = this.getBuilding();
        if (theBuilding != null) {
            if (TileEntityColonyBuilding.isInTileEntity(theBuilding.getTileEntity(), notEmptyPredicate)) {
                return theBuilding.getLocation();
            }
            for (BlockPos pos : theBuilding.getAdditionalCountainers()) {
                TileEntity entity = this.func_145831_w().func_175625_s(pos);
                if ((!(entity instanceof TileEntityRack) || !((TileEntityRack)entity).hasItemStack(notEmptyPredicate)) && (!(entity instanceof TileEntityChest) || !TileEntityColonyBuilding.isInTileEntity((TileEntityChest)entity, notEmptyPredicate))) continue;
                return pos;
            }
        }
        return null;
    }

    public static boolean isInTileEntity(TileEntityChest entity, @NotNull Predicate<ItemStack> itemStackSelectionPredicate) {
        return InventoryFunctions.matchFirstInProvider((ICapabilityProvider)entity, itemStackSelectionPredicate);
    }

    public void setColony(Colony c) {
        this.colony = c;
        this.colonyId = c.getID();
        this.func_70296_d();
    }

    public void func_70296_d() {
        super.func_70296_d();
        if (this.building != null) {
            this.building.markDirty();
        }
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74768_a(TAG_COLONY, this.colonyId);
        return new SPacketUpdateTileEntity(this.getPosition(), 0, compound);
    }

    @NotNull
    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        NBTTagCompound compound = packet.func_148857_g();
        this.colonyId = compound.func_74762_e(TAG_COLONY);
    }

    public void onChunkUnload() {
        if (this.building != null) {
            this.building.setTileEntity(null);
        }
    }

    public AbstractBuildingContainer getBuilding() {
        if (this.building == null) {
            this.updateColonyReferences();
        }
        return this.building;
    }

    public void setBuilding(AbstractBuildingContainer b) {
        this.building = b;
    }

    public ITextComponent func_145748_c_() {
        if (this.field_145854_h == null) {
            return super.func_145748_c_();
        }
        return new TextComponentString(LanguageHandler.format(this.field_145854_h.func_149739_a() + ".name", new Object[0]));
    }

    public AbstractBuildingView getBuildingView() {
        ColonyView c = ColonyManager.getColonyView(this.colonyId, this.field_145850_b.field_73011_w.getDimension());
        return c == null ? null : c.getBuilding(this.getPosition());
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        if (compound.func_74764_b(TAG_COLONY)) {
            this.colonyId = compound.func_74762_e(TAG_COLONY);
        }
        this.updateColonyReferences();
        this.mirror = compound.func_74767_n(TAG_MIRROR);
        this.style = compound.func_74779_i(TAG_STYLE);
    }

    @NotNull
    public NBTTagCompound func_189515_b(@NotNull NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74768_a(TAG_COLONY, this.colonyId);
        compound.func_74757_a(TAG_MIRROR, this.mirror);
        compound.func_74778_a(TAG_STYLE, this.style);
        return compound;
    }

    public void func_73660_a() {
        Colony tempColony;
        super.func_73660_a();
        if (!this.func_145831_w().field_72995_K && this.colonyId == 0 && (tempColony = ColonyManager.getColonyByPosFromWorld(this.func_145831_w(), this.getPosition())) != null) {
            this.colonyId = tempColony.getID();
        }
        this.combinedInv = null;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return super.func_70300_a(player) && this.hasAccessPermission(player);
    }

    public boolean hasAccessPermission(EntityPlayer player) {
        return this.building == null || this.building.getColony().getPermissions().hasPermission(player, Action.ACCESS_HUTS);
    }

    public void setMirror(boolean mirror) {
        this.mirror = mirror;
    }

    public boolean isMirrored() {
        return this.mirror;
    }

    public String getStyle() {
        return this.style;
    }

    public void setStyle(String style) {
        this.style = style;
    }

    public boolean hasCapability(@NotNull Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(@NotNull Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && this.getBuilding() != null) {
            if (this.combinedInv == null) {
                HashSet<ICapabilityProvider> providers = new HashSet<ICapabilityProvider>();
                World world = this.colony.getWorld();
                if (world != null) {
                    providers.addAll(this.building.getAdditionalCountainers().stream().map(arg_0 -> ((World)world).func_175625_s(arg_0)).collect(Collectors.toSet()));
                    providers.removeIf(Objects::isNull);
                }
                List handlers = providers.stream().flatMap(provider -> InventoryUtils.getItemHandlersFromProvider(provider).stream()).collect(Collectors.toList());
                Object cap = super.getCapability(capability, facing);
                if (cap instanceof IItemHandler) {
                    handlers.add((IItemHandler)cap);
                }
                this.combinedInv = new CombinedItemHandler(this.building.getSchematicName(), (IItemHandlerModifiable[])handlers.stream().map(handler -> (IItemHandlerModifiable)handler).distinct().filter(handler -> handler instanceof IItemHandlerModifiable && handler.getSlots() >= 5).toArray(IItemHandlerModifiable[]::new));
            }
            return (T)this.combinedInv;
        }
        return (T)super.getCapability(capability, facing);
    }
}

