/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.network.messages;

import com.minecolonies.api.colony.IColonyTagCapability;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.network.messages.AbstractMessage;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import org.jetbrains.annotations.NotNull;

public class UpdateChunkRangeCapabilityMessage
extends AbstractMessage<UpdateChunkRangeCapabilityMessage, IMessage> {
    private final List<Tuple<Tuple<Integer, Integer>, Integer>> colonies = new ArrayList<Tuple<Tuple<Integer, Integer>, Integer>>();

    public UpdateChunkRangeCapabilityMessage() {
    }

    public UpdateChunkRangeCapabilityMessage(@NotNull World world, int xC, int zC, int range) {
        for (int x = -range; x <= range; ++x) {
            for (int z = -range; z <= range; ++z) {
                Chunk chunk;
                IColonyTagCapability cap;
                int chunkX = xC + x;
                int chunkZ = zC + z;
                if (!world.func_175667_e(new BlockPos(chunkX * 16, 0, chunkZ * 16)) || (cap = (IColonyTagCapability)(chunk = world.func_72964_e(chunkX, chunkZ)).getCapability(MineColonies.CLOSE_COLONY_CAP, null)) == null) continue;
                this.colonies.add((Tuple<Tuple<Integer, Integer>, Integer>)new Tuple((Object)new Tuple((Object)chunkX, (Object)chunkZ), (Object)cap.getOwningColony()));
            }
        }
    }

    public void fromBytes(@NotNull ByteBuf buf) {
        int size = buf.readInt();
        for (int i = 0; i < size; ++i) {
            this.colonies.add((Tuple<Tuple<Integer, Integer>, Integer>)new Tuple((Object)new Tuple((Object)buf.readInt(), (Object)buf.readInt()), (Object)buf.readInt()));
        }
    }

    public void toBytes(@NotNull ByteBuf buf) {
        buf.writeInt(this.colonies.size());
        for (Tuple<Tuple<Integer, Integer>, Integer> c : this.colonies) {
            buf.writeInt(((Integer)((Tuple)c.func_76341_a()).func_76341_a()).intValue());
            buf.writeInt(((Integer)((Tuple)c.func_76341_a()).func_76340_b()).intValue());
            buf.writeInt(((Integer)c.func_76340_b()).intValue());
        }
    }

    @Override
    protected void messageOnClientThread(UpdateChunkRangeCapabilityMessage message, MessageContext ctx) {
        if (ctx.getClientHandler().field_147300_g != null) {
            for (Tuple<Tuple<Integer, Integer>, Integer> c : message.colonies) {
                Chunk chunk = ctx.getClientHandler().field_147300_g.func_72964_e(((Integer)((Tuple)c.func_76341_a()).func_76341_a()).intValue(), ((Integer)((Tuple)c.func_76341_a()).func_76340_b()).intValue());
                IColonyTagCapability cap = (IColonyTagCapability)chunk.getCapability(MineColonies.CLOSE_COLONY_CAP, null);
                if (cap == null) continue;
                cap.setOwningColony((Integer)c.func_76340_b());
                cap.addColony((Integer)c.func_76340_b());
            }
        }
    }
}

