/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.network.messages;

import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.ColonyManager;
import com.minecolonies.coremod.network.messages.AbstractMessage;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import org.jetbrains.annotations.NotNull;

public class ColonyViewRemoveBuildingMessage
extends AbstractMessage<ColonyViewRemoveBuildingMessage, IMessage> {
    private int colonyId;
    private BlockPos buildingId;

    public ColonyViewRemoveBuildingMessage() {
    }

    public ColonyViewRemoveBuildingMessage(@NotNull Colony colony, BlockPos building) {
        this.colonyId = colony.getID();
        this.buildingId = building;
    }

    public void fromBytes(@NotNull ByteBuf buf) {
        this.colonyId = buf.readInt();
        this.buildingId = BlockPosUtil.readFromByteBuf(buf);
    }

    public void toBytes(@NotNull ByteBuf buf) {
        buf.writeInt(this.colonyId);
        BlockPosUtil.writeToByteBuf(buf, this.buildingId);
    }

    @Override
    protected void messageOnClientThread(ColonyViewRemoveBuildingMessage message, MessageContext ctx) {
        ColonyManager.handleColonyViewRemoveBuildingMessage(message.colonyId, message.buildingId, Minecraft.func_71410_x().field_71441_e.field_73011_w.getDimension());
    }
}

