/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.network.messages;

import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.ColonyManager;
import com.minecolonies.coremod.network.messages.AbstractMessage;
import io.netty.buffer.ByteBuf;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import org.jetbrains.annotations.NotNull;

public class ColonyViewMessage
extends AbstractMessage<ColonyViewMessage, IMessage> {
    private int colonyId;
    private boolean isNewSubscription;
    private ByteBuf colonyBuffer;
    private int dim;

    public ColonyViewMessage() {
    }

    public ColonyViewMessage(@NotNull Colony colony, ByteBuf buf, boolean isNewSubscription) {
        this.colonyId = colony.getID();
        this.isNewSubscription = isNewSubscription;
        this.dim = colony.getDimension();
        this.colonyBuffer = buf.copy();
    }

    public void fromBytes(@NotNull ByteBuf buf) {
        ByteBuf newBuf = buf.retain();
        this.colonyId = newBuf.readInt();
        this.isNewSubscription = newBuf.readBoolean();
        this.dim = newBuf.readInt();
        this.colonyBuffer = newBuf;
    }

    public void toBytes(@NotNull ByteBuf buf) {
        buf.writeInt(this.colonyId);
        buf.writeBoolean(this.isNewSubscription);
        buf.writeInt(this.dim);
        buf.writeBytes(this.colonyBuffer);
    }

    @Override
    protected void messageOnClientThread(ColonyViewMessage message, MessageContext ctx) {
        if (MineColonies.proxy.getWorldFromMessage(ctx) != null) {
            ColonyManager.handleColonyViewMessage(message.colonyId, message.colonyBuffer, MineColonies.proxy.getWorldFromMessage(ctx), message.isNewSubscription, message.dim);
        }
    }
}

