/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.network.messages;

import com.ldtteam.structures.helpers.Structure;
import com.ldtteam.structurize.management.StructureName;
import com.ldtteam.structurize.management.Structures;
import com.ldtteam.structurize.util.PlacementSettings;
import com.minecolonies.api.colony.permissions.Action;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.CompatibilityUtils;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.LanguageHandler;
import com.minecolonies.api.util.Log;
import com.minecolonies.coremod.blocks.AbstractBlockHut;
import com.minecolonies.coremod.blocks.huts.BlockHutTownHall;
import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.ColonyManager;
import com.minecolonies.coremod.colony.buildings.AbstractBuilding;
import com.minecolonies.coremod.colony.buildings.workerbuildings.PostBox;
import com.minecolonies.coremod.colony.workorders.WorkOrderBuildBuilding;
import com.minecolonies.coremod.colony.workorders.WorkOrderBuildDecoration;
import com.minecolonies.coremod.entity.ai.citizen.builder.ConstructionTapeHelper;
import com.minecolonies.coremod.event.EventHandler;
import com.minecolonies.coremod.network.messages.AbstractMessage;
import com.minecolonies.coremod.util.ColonyUtils;
import com.minecolonies.coremod.util.InstantStructurePlacer;
import io.netty.buffer.ByteBuf;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.Mirror;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.NotNull;

public class BuildToolPlaceMessage
extends AbstractMessage<BuildToolPlaceMessage, IMessage> {
    private static final String NO_HUT_IN_INVENTORY = "com.minecolonies.coremod.gui.buildtool.nohutininventory";
    private IBlockState state;
    private String structureName;
    private String workOrderName;
    private int rotation;
    private BlockPos pos;
    private boolean isHut;
    private boolean mirror;

    public BuildToolPlaceMessage() {
    }

    public BuildToolPlaceMessage(String structureName, String workOrderName, BlockPos pos, int rotation, boolean isHut, Mirror mirror, IBlockState state) {
        this.structureName = structureName;
        this.workOrderName = workOrderName;
        this.pos = pos;
        this.rotation = rotation;
        this.isHut = isHut;
        this.mirror = mirror == Mirror.FRONT_BACK;
        this.state = state;
    }

    public void fromBytes(@NotNull ByteBuf buf) {
        this.structureName = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.workOrderName = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.pos = new BlockPos(buf.readInt(), buf.readInt(), buf.readInt());
        this.rotation = buf.readInt();
        this.isHut = buf.readBoolean();
        this.mirror = buf.readBoolean();
        this.state = NBTUtil.func_190008_d((NBTTagCompound)ByteBufUtils.readTag((ByteBuf)buf));
    }

    public void toBytes(@NotNull ByteBuf buf) {
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.structureName);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.workOrderName);
        buf.writeInt(this.pos.func_177958_n());
        buf.writeInt(this.pos.func_177956_o());
        buf.writeInt(this.pos.func_177952_p());
        buf.writeInt(this.rotation);
        buf.writeBoolean(this.isHut);
        buf.writeBoolean(this.mirror);
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)NBTUtil.func_190009_a((NBTTagCompound)new NBTTagCompound(), (IBlockState)this.state));
    }

    @Override
    public void messageOnServerThread(BuildToolPlaceMessage message, EntityPlayerMP player) {
        StructureName sn = new StructureName(message.structureName);
        if (!Structures.hasMD5((StructureName)sn)) {
            player.func_145747_a((ITextComponent)new TextComponentString("Can not build " + message.workOrderName + ": schematic missing!"));
            return;
        }
        if (message.isHut) {
            BuildToolPlaceMessage.handleHut(CompatibilityUtils.getWorld((Entity)player), (EntityPlayer)player, sn, message.rotation, message.pos, message.mirror, message.state);
        } else {
            BuildToolPlaceMessage.handleDecoration(CompatibilityUtils.getWorld((Entity)player), (EntityPlayer)player, sn, message.workOrderName, message.rotation, message.pos, message.mirror);
        }
    }

    private static void handleHut(@NotNull World world, @NotNull EntityPlayer player, StructureName sn, int rotation, @NotNull BlockPos buildPos, boolean mirror, IBlockState state) {
        String hut = sn.getSection();
        Block block = Block.func_149684_b((String)("minecolonies:blockHut" + hut));
        Colony tempColony = ColonyManager.getClosestColony(world, buildPos);
        if (!(tempColony == null || tempColony.getPermissions().hasPermission(player, Action.MANAGE_HUTS) || block instanceof BlockHutTownHall && !ColonyManager.isTooCloseToColony(world, buildPos))) {
            return;
        }
        if (block != null && player.field_71071_by.func_70431_c(new ItemStack(block))) {
            if (EventHandler.onBlockHutPlaced(world, player, block, buildPos)) {
                world.func_175655_b(buildPos, true);
                world.func_175656_a(buildPos, state.func_185907_a(BlockPosUtil.getRotationFromRotations(rotation)));
                ((AbstractBlockHut)block).onBlockPlacedByBuildTool(world, buildPos, world.func_180495_p(buildPos), (EntityLivingBase)player, null, mirror, sn.getStyle());
                boolean complete = false;
                int level = 0;
                int slot = InventoryUtils.findFirstSlotInItemHandlerWith((IItemHandler)new InvWrapper((IInventory)player.field_71071_by), itemStack -> itemStack.func_77969_a(new ItemStack(Item.func_150898_a((Block)block), 1)));
                if (slot != -1) {
                    ItemStack stack = player.field_71071_by.func_70301_a(slot);
                    NBTTagCompound compound = stack.func_77978_p();
                    if (compound != null) {
                        if (compound.func_74764_b("otherLevel")) {
                            level = compound.func_74762_e("otherLevel");
                        }
                        if (compound.func_74764_b("isPasteable")) {
                            String schematic = sn.toString();
                            schematic = schematic.substring(0, schematic.length() - 1);
                            schematic = schematic + level;
                            InstantStructurePlacer.loadAndPlaceStructureWithRotation(player.field_70170_p, schematic, buildPos, rotation, mirror ? Mirror.FRONT_BACK : Mirror.NONE, false);
                            complete = true;
                        }
                    }
                    player.field_71071_by.func_174925_a(Item.func_150898_a((Block)block), -1, 1, null);
                }
                BuildToolPlaceMessage.setupBuilding(world, player, sn, rotation, buildPos, mirror, level, complete);
            }
        } else {
            LanguageHandler.sendPlayerMessage(player, NO_HUT_IN_INVENTORY, new Object[0]);
        }
    }

    private static void handleDecoration(@NotNull World world, @NotNull EntityPlayer player, StructureName sn, String workOrderName, int rotation, @NotNull BlockPos buildPos, boolean mirror) {
        Colony colony = ColonyManager.getColonyByPosFromWorld(world, buildPos);
        if (colony != null && colony.getPermissions().hasPermission(player, Action.PLACE_HUTS)) {
            String schem = sn.toString();
            String woName = workOrderName;
            if (schem.matches("^.*[a-zA-Z_-]\\d$")) {
                schem = schem.replaceAll("\\d$", "");
                schem = schem + '1';
            }
            if (woName.matches("^.*[a-zA-Z_-]\\d$")) {
                woName = woName.replaceAll("\\d$", "");
                woName = woName + '1';
            }
            colony.getWorkManager().addWorkOrder(new WorkOrderBuildDecoration(schem, woName, rotation, buildPos, mirror), false);
        } else {
            Log.getLogger().error("handleDecoration: Could not build " + sn);
        }
    }

    private static void setupBuilding(@NotNull World world, @NotNull EntityPlayer player, StructureName sn, int rotation, @NotNull BlockPos buildPos, boolean mirror, int level, boolean complete) {
        AbstractBuilding building = ColonyManager.getBuilding(world, buildPos);
        if (building == null) {
            Log.getLogger().error("BuildTool: building is null!");
        } else {
            if (building.getTileEntity() != null) {
                Colony colony = ColonyManager.getColonyByPosFromWorld(world, buildPos);
                if (colony == null) {
                    Log.getLogger().info("No colony for " + player.func_70005_c_());
                } else {
                    building.getTileEntity().setColony(colony);
                }
            }
            building.setStyle(sn.getStyle());
            building.setRotation(rotation);
            building.setBuildingLevel(level);
            if (!(building instanceof PostBox)) {
                ConstructionTapeHelper.removeConstructionTape(building.getCorners(), world);
                WorkOrderBuildBuilding workOrder = new WorkOrderBuildBuilding(building, 1);
                Structure wrapper = new Structure(world, workOrder.getStructureName(), new PlacementSettings());
                Tuple<Tuple<Integer, Integer>, Tuple<Integer, Integer>> corners = ColonyUtils.calculateCorners(building.getLocation(), world, wrapper, workOrder.getRotation(world), workOrder.isMirrored());
                building.setCorners((Integer)((Tuple)corners.func_76341_a()).func_76341_a(), (Integer)((Tuple)corners.func_76341_a()).func_76340_b(), (Integer)((Tuple)corners.func_76340_b()).func_76341_a(), (Integer)((Tuple)corners.func_76340_b()).func_76340_b());
                building.setHeight(wrapper.getHeight());
                ConstructionTapeHelper.placeConstructionTape(building.getLocation(), corners, world);
            }
            if (mirror) {
                building.invertMirror();
            }
            if (complete) {
                building.onUpgradeComplete(building.getBuildingLevel());
            }
        }
    }
}

