/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.inventory;

import com.minecolonies.api.colony.permissions.Action;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.coremod.colony.CitizenData;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ReportedException;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import org.jetbrains.annotations.NotNull;

public class InventoryCitizen
implements IInventory {
    private static final int NO_SLOT = -1;
    private static final int HOTBAR_SIZE = 0;
    private final NonNullList<ItemStack> mainInventory = NonNullList.func_191197_a((int)36, (Object)ItemStackUtils.EMPTY);
    private final NonNullList<ItemStack> armorInventory = NonNullList.func_191197_a((int)4, (Object)ItemStackUtils.EMPTY);
    private final NonNullList<ItemStack> offHandInventory = NonNullList.func_191197_a((int)1, (Object)ItemStackUtils.EMPTY);
    private final List<NonNullList<ItemStack>> allInventories;
    private int mainItem;
    private int offhandItem;
    private ItemStack itemStack = ItemStackUtils.EMPTY;
    private String customName;
    private boolean inventoryChanged = false;
    private CitizenData citizen;

    public InventoryCitizen(String title, boolean localeEnabled, CitizenData citizen) {
        this.citizen = citizen;
        if (localeEnabled) {
            this.customName = title;
        }
        this.allInventories = new ArrayList<NonNullList<ItemStack>>();
        this.allInventories.add(this.mainInventory);
        this.allInventories.add(this.armorInventory);
        this.allInventories.add(this.offHandInventory);
        this.itemStack = ItemStackUtils.EMPTY;
    }

    public InventoryCitizen(String title, boolean localeEnabled) {
        if (localeEnabled) {
            this.customName = title;
        }
        this.allInventories = new ArrayList<NonNullList<ItemStack>>();
        this.allInventories.add(this.mainInventory);
        this.allInventories.add(this.armorInventory);
        this.allInventories.add(this.offHandInventory);
        this.itemStack = ItemStackUtils.EMPTY;
    }

    public int getHotbarSize() {
        return 0;
    }

    public void setCustomName(String customName) {
        this.customName = customName;
    }

    public boolean hasInventoryChanged() {
        if (this.inventoryChanged) {
            this.inventoryChanged = false;
            return true;
        }
        return false;
    }

    public ItemStack getHeldItem(EnumHand hand) {
        if (hand.equals((Object)EnumHand.MAIN_HAND)) {
            return this.func_70301_a(this.mainItem);
        }
        return this.func_70301_a(this.offhandItem);
    }

    public void setHeldItem(EnumHand hand, int slot) {
        if (hand.equals((Object)EnumHand.MAIN_HAND)) {
            this.mainItem = slot;
        }
        this.offhandItem = slot;
    }

    public int getHeldItemSlot(EnumHand hand) {
        if (hand.equals((Object)EnumHand.MAIN_HAND)) {
            return this.mainItem;
        }
        return this.offhandItem;
    }

    public int func_70302_i_() {
        return this.mainInventory.size();
    }

    @NotNull
    public String func_70005_c_() {
        return this.func_145818_k_() ? this.customName : "citizen.inventory";
    }

    public boolean func_191420_l() {
        for (ItemStack itemstack : this.mainInventory) {
            if (itemstack.func_190926_b()) continue;
            return false;
        }
        for (ItemStack itemstack1 : this.armorInventory) {
            if (itemstack1.func_190926_b()) continue;
            return false;
        }
        for (ItemStack itemstack2 : this.offHandInventory) {
            if (itemstack2.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public boolean func_145818_k_() {
        return this.customName != null;
    }

    public ItemStack func_70301_a(int index) {
        NonNullList<ItemStack> list = null;
        int tempIndex = index;
        for (NonNullList<ItemStack> nonnulllist : this.allInventories) {
            if (tempIndex < nonnulllist.size()) {
                list = nonnulllist;
                break;
            }
            tempIndex -= nonnulllist.size();
        }
        return list == null ? ItemStackUtils.EMPTY : (ItemStack)list.get(tempIndex);
    }

    public ItemStack func_70298_a(int index, int count) {
        NonNullList<ItemStack> list = null;
        int tempIndex = index;
        for (NonNullList<ItemStack> nonnulllist : this.allInventories) {
            if (tempIndex < nonnulllist.size()) {
                list = nonnulllist;
                break;
            }
            tempIndex -= nonnulllist.size();
        }
        return list != null && ItemStackUtils.isEmpty((ItemStack)list.get(tempIndex)) == false ? ItemStackHelper.func_188382_a(list, (int)tempIndex, (int)count) : ItemStackUtils.EMPTY;
    }

    public ItemStack func_70304_b(int index) {
        NonNullList<ItemStack> nonnulllist = null;
        int tempIndex = index;
        for (NonNullList<ItemStack> nonnulllist1 : this.allInventories) {
            if (tempIndex < nonnulllist1.size()) {
                nonnulllist = nonnulllist1;
                break;
            }
            tempIndex -= nonnulllist1.size();
        }
        if (nonnulllist != null && !ItemStackUtils.isEmpty((ItemStack)nonnulllist.get(tempIndex)).booleanValue()) {
            ItemStack itemstack = (ItemStack)nonnulllist.get(tempIndex);
            nonnulllist.set(tempIndex, (Object)ItemStackUtils.EMPTY);
            return itemstack;
        }
        return ItemStackUtils.EMPTY;
    }

    public void func_70299_a(int index, ItemStack stack) {
        NonNullList<ItemStack> nonnulllist = null;
        int tempIndex = index;
        for (NonNullList<ItemStack> nonnulllist1 : this.allInventories) {
            if (tempIndex < nonnulllist1.size()) {
                nonnulllist = nonnulllist1;
                break;
            }
            tempIndex -= nonnulllist1.size();
        }
        if (nonnulllist != null) {
            nonnulllist.set(tempIndex, (Object)stack);
        }
    }

    public int func_70297_j_() {
        return 64;
    }

    public void func_70296_d() {
        this.inventoryChanged = true;
        if (this.citizen != null) {
            this.citizen.markDirty();
        }
    }

    public boolean func_70300_a(@NotNull EntityPlayer player) {
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
            return true;
        }
        if (this.citizen == null) {
            return false;
        }
        return this.citizen.getColony().getPermissions().hasPermission(player, Action.ACCESS_HUTS);
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    @NotNull
    public ITextComponent func_145748_c_() {
        return this.func_145818_k_() ? new TextComponentString(this.func_70005_c_()) : new TextComponentTranslation(this.func_70005_c_(), new Object[0]);
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return true;
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
        for (List list : this.allInventories) {
            list.clear();
        }
    }

    public boolean addItemStackToInventory(ItemStack itemStackIn) {
        if (itemStackIn.func_190926_b()) {
            return false;
        }
        try {
            int i;
            if (itemStackIn.func_77951_h()) {
                int j = this.getFirstEmptyStack();
                if (j >= 0) {
                    this.mainInventory.set(j, (Object)itemStackIn.func_77946_l());
                    ((ItemStack)this.mainInventory.get(j)).func_190915_d(5);
                    ItemStackUtils.setSize(itemStackIn, 0);
                    return true;
                }
                return false;
            }
            do {
                i = ItemStackUtils.getSize(itemStackIn);
                ItemStackUtils.setSize(itemStackIn, this.storePartialItemStack(itemStackIn));
            } while (ItemStackUtils.getSize(itemStackIn) < i);
            return ItemStackUtils.getSize(itemStackIn) < i;
        }
        catch (RuntimeException exception) {
            CrashReport crashreport = CrashReport.func_85055_a((Throwable)exception, (String)"Adding item to inventory");
            CrashReportCategory crashreportcategory = crashreport.func_85058_a("Item being added");
            crashreportcategory.func_71507_a("Item ID", (Object)Item.func_150891_b((Item)itemStackIn.func_77973_b()));
            crashreportcategory.func_71507_a("Item data", (Object)itemStackIn.func_77960_j());
            crashreportcategory.func_189529_a("Item name", () -> ((ItemStack)itemStackIn).func_82833_r());
            throw new ReportedException(crashreport);
        }
    }

    public int getFirstEmptyStack() {
        for (int i = 0; i < this.mainInventory.size(); ++i) {
            if (!((ItemStack)this.mainInventory.get(i)).func_190926_b()) continue;
            return i;
        }
        return -1;
    }

    private int storePartialItemStack(ItemStack itemStackIn) {
        int i = ItemStackUtils.getSize(itemStackIn);
        int j = this.storeItemStack(itemStackIn);
        if (j == -1) {
            j = this.getFirstEmptyStack();
        }
        if (j == -1) {
            return i;
        }
        ItemStack itemstack = this.func_70301_a(j);
        if (itemstack.func_190926_b()) {
            itemstack = itemStackIn.func_77946_l();
            ItemStackUtils.setSize(itemstack, 0);
            if (itemStackIn.func_77942_o()) {
                itemstack.func_77982_d(itemStackIn.func_77978_p().func_74737_b());
            }
            this.func_70299_a(j, itemstack);
        }
        int k = i;
        if (i > itemstack.func_77976_d() - ItemStackUtils.getSize(itemstack)) {
            k = itemstack.func_77976_d() - ItemStackUtils.getSize(itemstack);
        }
        if (k > this.func_70297_j_() - ItemStackUtils.getSize(itemstack)) {
            k = this.func_70297_j_() - ItemStackUtils.getSize(itemstack);
        }
        if (k == 0) {
            return i;
        }
        itemstack.func_190917_f(k);
        itemstack.func_190915_d(5);
        return i -= k;
    }

    private int storeItemStack(ItemStack itemStackIn) {
        if (this.canMergeStacks(this.func_70301_a(this.mainItem), itemStackIn)) {
            return this.mainItem;
        }
        if (this.canMergeStacks(this.func_70301_a(this.offhandItem), itemStackIn)) {
            return this.offhandItem;
        }
        if (this.canMergeStacks(this.func_70301_a(40), itemStackIn)) {
            return 40;
        }
        for (int i = 0; i < this.mainInventory.size(); ++i) {
            if (!this.canMergeStacks((ItemStack)this.mainInventory.get(i), itemStackIn)) continue;
            return i;
        }
        return -1;
    }

    private boolean canMergeStacks(ItemStack stack1, ItemStack stack2) {
        return ItemStackUtils.isEmpty(stack1) == false && ItemStack.func_77989_b((ItemStack)stack1, (ItemStack)stack2) && stack1.func_77985_e() && ItemStackUtils.getSize(stack1) < stack1.func_77976_d() && ItemStackUtils.getSize(stack1) < this.func_70297_j_();
    }

    public void deleteStack(ItemStack stack) {
        block0: for (NonNullList<ItemStack> nonnulllist : this.allInventories) {
            for (int i = 0; i < nonnulllist.size(); ++i) {
                if (nonnulllist.get(i) != stack) continue;
                nonnulllist.set(i, (Object)ItemStackUtils.EMPTY);
                continue block0;
            }
        }
    }

    public float getStrVsBlock(EnumHand hand, IBlockState state) {
        float f = 1.0f;
        if (hand.equals((Object)EnumHand.MAIN_HAND)) {
            if (!((ItemStack)this.mainInventory.get(this.mainItem)).func_190926_b()) {
                f *= ((ItemStack)this.mainInventory.get(this.mainItem)).func_150997_a(state);
            }
        } else if (hand.equals((Object)EnumHand.OFF_HAND) && !((ItemStack)this.mainInventory.get(this.offhandItem)).func_190926_b()) {
            f *= ((ItemStack)this.mainInventory.get(this.offhandItem)).func_150997_a(state);
        }
        return f;
    }

    public NBTTagList writeToNBT(NBTTagList nbtTagListIn) {
        for (int i = 0; i < this.mainInventory.size(); ++i) {
            if (((ItemStack)this.mainInventory.get(i)).func_190926_b()) continue;
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            nbttagcompound.func_74774_a("Slot", (byte)i);
            ((ItemStack)this.mainInventory.get(i)).func_77955_b(nbttagcompound);
            nbtTagListIn.func_74742_a((NBTBase)nbttagcompound);
        }
        for (int j = 0; j < this.armorInventory.size(); ++j) {
            if (((ItemStack)this.armorInventory.get(j)).func_190926_b()) continue;
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            nbttagcompound1.func_74774_a("Slot", (byte)(j + 100));
            ((ItemStack)this.armorInventory.get(j)).func_77955_b(nbttagcompound1);
            nbtTagListIn.func_74742_a((NBTBase)nbttagcompound1);
        }
        for (int k = 0; k < this.offHandInventory.size(); ++k) {
            if (((ItemStack)this.offHandInventory.get(k)).func_190926_b()) continue;
            NBTTagCompound nbttagcompound2 = new NBTTagCompound();
            nbttagcompound2.func_74774_a("Slot", (byte)(k + 150));
            ((ItemStack)this.offHandInventory.get(k)).func_77955_b(nbttagcompound2);
            nbtTagListIn.func_74742_a((NBTBase)nbttagcompound2);
        }
        return nbtTagListIn;
    }

    public void readFromNBT(NBTTagList nbtTagListIn) {
        this.mainInventory.clear();
        this.armorInventory.clear();
        this.offHandInventory.clear();
        for (int i = 0; i < nbtTagListIn.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound = nbtTagListIn.func_150305_b(i);
            int j = nbttagcompound.func_74771_c("Slot") & 0xFF;
            ItemStack itemstack = new ItemStack(nbttagcompound);
            if (itemstack.func_190926_b()) continue;
            if (j >= 0 && j < this.mainInventory.size()) {
                this.mainInventory.set(j, (Object)itemstack);
                continue;
            }
            if (j >= 100 && j < this.armorInventory.size() + 100) {
                this.armorInventory.set(j - 100, (Object)itemstack);
                continue;
            }
            if (j < 150 || j >= this.offHandInventory.size() + 150) continue;
            this.offHandInventory.set(j - 150, (Object)itemstack);
        }
    }

    public ItemStack getItemStack() {
        return this.itemStack;
    }

    public void setItemStack(ItemStack itemStackIn) {
        this.itemStack = itemStackIn;
    }
}

