/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.statemachine.basestatemachine;

import com.minecolonies.api.util.Log;
import com.minecolonies.coremod.entity.ai.statemachine.basestatemachine.IStateMachine;
import com.minecolonies.coremod.entity.ai.statemachine.states.IAIEventType;
import com.minecolonies.coremod.entity.ai.statemachine.states.IAIState;
import com.minecolonies.coremod.entity.ai.statemachine.transitions.IStateMachineEvent;
import com.minecolonies.coremod.entity.ai.statemachine.transitions.IStateMachineOneTimeEvent;
import com.minecolonies.coremod.entity.ai.statemachine.transitions.IStateMachineTransition;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;

public class BasicStateMachine<T extends IStateMachineTransition>
implements IStateMachine<T> {
    @NotNull
    protected final Map<IAIState, ArrayList<T>> transitionMap;
    @NotNull
    protected final Map<IAIEventType, ArrayList<T>> eventTransitionMap;
    @NotNull
    private IAIState state;
    @NotNull
    private final IAIState initState;
    @NotNull
    private final Consumer<RuntimeException> exceptionHandler;

    protected BasicStateMachine(@NotNull IAIState initialState, @NotNull Consumer<RuntimeException> exceptionHandler) {
        this.state = initialState;
        this.initState = initialState;
        this.exceptionHandler = exceptionHandler;
        this.transitionMap = new HashMap<IAIState, ArrayList<T>>();
        this.transitionMap.put(initialState, new ArrayList());
        this.eventTransitionMap = new HashMap<IAIEventType, ArrayList<T>>();
    }

    @Override
    public void addTransition(T transition) {
        if (transition.getState() != null) {
            this.transitionMap.computeIfAbsent(transition.getState(), k -> new ArrayList()).add(transition);
        }
        if (transition instanceof IStateMachineEvent) {
            this.eventTransitionMap.computeIfAbsent(((IStateMachineEvent)transition).getEventType(), k -> new ArrayList()).add(transition);
        }
    }

    @Override
    public void removeTransition(T transition) {
        if (transition instanceof IStateMachineEvent) {
            ArrayList temp = new ArrayList(this.eventTransitionMap.get(((IStateMachineEvent)transition).getEventType()));
            temp.remove(transition);
            this.eventTransitionMap.put(((IStateMachineEvent)transition).getEventType(), temp);
        } else {
            ArrayList temp = new ArrayList(this.transitionMap.get(transition.getState()));
            temp.remove(transition);
            this.transitionMap.put(transition.getState(), temp);
        }
    }

    @Override
    public void tick() {
        if (!this.eventTransitionMap.values().stream().anyMatch(k -> k.stream().anyMatch(this::checkTransition))) {
            this.transitionMap.get(this.state).stream().anyMatch(this::checkTransition);
        }
    }

    @Override
    public boolean checkTransition(@NotNull T transition) {
        try {
            if (!transition.checkCondition()) {
                return false;
            }
        }
        catch (RuntimeException e) {
            Log.getLogger().warn("Condition check for transition " + transition + " threw an exception:", (Throwable)e);
            this.onException(e);
            return false;
        }
        return this.transitionToNext(transition);
    }

    @Override
    public boolean transitionToNext(@NotNull T transition) {
        IAIState newState;
        try {
            newState = transition.getNextState();
        }
        catch (RuntimeException e) {
            Log.getLogger().warn("Statemachine for transition " + transition + " threw an exception:", (Throwable)e);
            this.onException(e);
            return false;
        }
        if (newState != null) {
            if (transition instanceof IStateMachineOneTimeEvent && ((IStateMachineOneTimeEvent)transition).shouldRemove()) {
                this.removeTransition(transition);
            }
            this.state = newState;
            return true;
        }
        return false;
    }

    protected void onException(RuntimeException e) {
        this.exceptionHandler.accept(e);
    }

    @Override
    public final IAIState getState() {
        return this.state;
    }

    @Override
    public void reset() {
        this.state = this.initState;
    }
}

